/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.HexBin;

public class SQLHexExpr
extends SQLExprImpl
implements SQLLiteralExpr {
    private final String hex;

    public SQLHexExpr(String hex) {
        this.hex = hex;
    }

    public String getHex() {
        return this.hex;
    }

    @Override
    public void output(StringBuffer buf) {
        buf.append("0x");
        buf.append(this.hex);
        String charset = (String)this.getAttribute("USING");
        if (charset != null) {
            buf.append(" USING ");
            buf.append(charset);
        }
    }

    @Override
    protected void accept0(SQLASTVisitor visitor2) {
        visitor2.visit(this);
        visitor2.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.hex == null ? 0 : this.hex.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLHexExpr other = (SQLHexExpr)obj;
        return !(this.hex == null ? other.hex != null : !this.hex.equals(other.hex));
    }

    public byte[] toBytes() {
        return HexBin.decode(this.hex);
    }
}

