/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.AlgorithmFinder;
import com.password4j.BadParametersException;
import com.password4j.Hash;
import com.password4j.HashingFunction;
import com.password4j.PepperGenerator;
import com.password4j.SaltGenerator;
import com.password4j.Utils;

public class HashBuilder {
    protected byte[] salt;
    protected CharSequence pepper;
    private byte[] plainTextPassword;

    private HashBuilder() {
    }

    protected HashBuilder(CharSequence plainTextPassword) {
        this.plainTextPassword = Utils.fromCharSequenceToBytes(plainTextPassword);
    }

    protected HashBuilder(byte[] plainTextPasswordAsBytes) {
        this.plainTextPassword = plainTextPasswordAsBytes;
    }

    public HashBuilder addSalt(String salt) {
        this.salt = Utils.fromCharSequenceToBytes(salt);
        return this;
    }

    public HashBuilder addSalt(byte[] saltAsBytes) {
        this.salt = saltAsBytes;
        return this;
    }

    public HashBuilder addRandomSalt() {
        this.salt = SaltGenerator.generate();
        return this;
    }

    public HashBuilder addRandomSalt(int length) {
        if (length <= 0) {
            throw new BadParametersException("Salt cannot have a non-positive length");
        }
        this.salt = SaltGenerator.generate(length);
        return this;
    }

    public HashBuilder addPepper() {
        this.pepper = PepperGenerator.get();
        return this;
    }

    public HashBuilder addPepper(CharSequence pepper) {
        this.pepper = pepper;
        return this;
    }

    public Hash with(HashingFunction hashingFunction) {
        return hashingFunction.hash(this.plainTextPassword, this.salt, this.pepper);
    }

    public Hash withPBKDF2() {
        return this.with(AlgorithmFinder.getPBKDF2Instance());
    }

    public Hash withCompressedPBKDF2() {
        return this.with(AlgorithmFinder.getCompressedPBKDF2Instance());
    }

    public Hash withBcrypt() {
        return this.with(AlgorithmFinder.getBcryptInstance());
    }

    public Hash withScrypt() {
        return this.with(AlgorithmFinder.getScryptInstance());
    }

    public Hash withMessageDigest() {
        return this.with(AlgorithmFinder.getMessageDigestInstance());
    }

    public Hash withArgon2() {
        return this.with(AlgorithmFinder.getArgon2Instance());
    }

    public Hash withBalloonHashing() {
        return this.with(AlgorithmFinder.getBalloonHashingInstance());
    }
}

