/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.util;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.opensearch.OpenSearchException;
import org.opensearch.security.ssl.util.KeystoreProps;
import org.opensearch.security.ssl.util.SSLCertificateHelper;

public class CertFromTruststore {
    private final KeystoreProps keystoreProps;
    private final String serverTruststoreAlias;
    private final X509Certificate[] serverTrustedCerts;
    private final String clientTruststoreAlias;
    private final X509Certificate[] clientTrustedCerts;

    public CertFromTruststore() {
        this.keystoreProps = null;
        this.serverTruststoreAlias = null;
        this.serverTrustedCerts = null;
        this.clientTruststoreAlias = null;
        this.clientTrustedCerts = null;
    }

    public static CertFromTruststore Empty() {
        return new CertFromTruststore();
    }

    public CertFromTruststore(KeystoreProps keystoreProps, String truststoreAlias) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.keystoreProps = keystoreProps;
        KeyStore ts = keystoreProps.loadKeystore();
        this.serverTruststoreAlias = truststoreAlias;
        this.serverTrustedCerts = SSLCertificateHelper.exportRootCertificates(ts, truststoreAlias);
        this.clientTruststoreAlias = this.serverTruststoreAlias;
        this.clientTrustedCerts = this.serverTrustedCerts;
        this.validate();
    }

    public CertFromTruststore(KeystoreProps keystoreProps, String serverTruststoreAlias, String clientTruststoreAlias) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.keystoreProps = keystoreProps;
        KeyStore ts = this.keystoreProps.loadKeystore();
        this.serverTruststoreAlias = serverTruststoreAlias;
        this.serverTrustedCerts = SSLCertificateHelper.exportRootCertificates(ts, this.serverTruststoreAlias);
        this.clientTruststoreAlias = clientTruststoreAlias;
        this.clientTrustedCerts = SSLCertificateHelper.exportRootCertificates(ts, this.clientTruststoreAlias);
        this.validate();
    }

    private void validate() {
        if (this.serverTrustedCerts == null || this.serverTrustedCerts.length == 0) {
            throw new OpenSearchException("No truststore configured for server certs", new Object[0]);
        }
        if (this.clientTrustedCerts == null || this.clientTrustedCerts.length == 0) {
            throw new OpenSearchException("No truststore configured for client certs", new Object[0]);
        }
    }

    public X509Certificate[] getServerTrustedCerts() {
        return this.serverTrustedCerts;
    }

    public X509Certificate[] getClientTrustedCerts() {
        return this.clientTrustedCerts;
    }
}

