/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RemoveProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, RemoveProcessor> {
    @Nonnull
    private final List<String> field;
    @Nullable
    private final Boolean ignoreMissing;
    public static final JsonpDeserializer<RemoveProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoveProcessor::setupRemoveProcessorDeserializer);

    private RemoveProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.unmodifiableRequired(builder.field, (Object)this, "field");
        this.ignoreMissing = builder.ignoreMissing;
    }

    public static RemoveProcessor of(Function<Builder, ObjectBuilder<RemoveProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Remove;
    }

    @Nonnull
    public final List<String> field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.writeStartArray();
        for (String item0 : this.field) {
            generator.write(item0);
        }
        generator.writeEnd();
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRemoveProcessorDeserializer(ObjectDeserializer<Builder> op) {
        RemoveProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreMissing);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoveProcessor other = (RemoveProcessor)o;
        return this.field.equals(other.field) && Objects.equals(this.ignoreMissing, other.ignoreMissing);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, RemoveProcessor> {
        private List<String> field;
        @Nullable
        private Boolean ignoreMissing;

        public Builder() {
        }

        private Builder(RemoveProcessor o) {
            super(o);
            this.field = Builder._listCopy(o.field);
            this.ignoreMissing = o.ignoreMissing;
        }

        private Builder(Builder o) {
            super(o);
            this.field = Builder._listCopy(o.field);
            this.ignoreMissing = o.ignoreMissing;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(List<String> list) {
            this.field = Builder._listAddAll(this.field, list);
            return this;
        }

        @Nonnull
        public final Builder field(String value, String ... values) {
            this.field = Builder._listAdd(this.field, value, values);
            return this;
        }

        @Nonnull
        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Override
        @Nonnull
        public RemoveProcessor build() {
            this._checkSingleUse();
            return new RemoveProcessor(this);
        }
    }
}

