/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.negra;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.negra.NegraPennLanguagePack;
import edu.stanford.nlp.util.Filter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NegraPennTreeNormalizer
extends TreeNormalizer {
    private final int nodeCleanup;
    private static final String nonUnaryRoot = "NUR";
    protected final TreebankLanguagePack tlp;
    private boolean insertNPinPP = false;
    private final Filter<Tree> emptyFilter;
    private final Filter<Tree> aOverAFilter;
    private static final String junkCPP = "---CJ";
    private static final String cpp = "CPP";
    private Set<String> prepositionTags = new HashSet<String>(Arrays.asList("APPR", "APPRART"));
    private Set<String> postpositionTags = new HashSet<String>(Arrays.asList("APPO", "APZR"));
    private static final long serialVersionUID = 8529514903815041064L;

    public NegraPennTreeNormalizer() {
        this(new NegraPennLanguagePack());
    }

    public NegraPennTreeNormalizer(TreebankLanguagePack tlp) {
        this(tlp, 0);
    }

    public NegraPennTreeNormalizer(TreebankLanguagePack tlp, int nodeCleanup) {
        this.tlp = tlp;
        this.nodeCleanup = nodeCleanup;
        this.emptyFilter = new Filter<Tree>(){
            private static final long serialVersionUID = -606371737889816130L;

            @Override
            public boolean accept(Tree t) {
                Tree[] kids = t.children();
                Label l = t.label();
                return l == null || l.value() == null || !l.value().matches("^\\*T.*$") || t.isLeaf() || kids.length != 1 || !kids[0].isLeaf();
            }
        };
        this.aOverAFilter = new Filter<Tree>(){
            private static final long serialVersionUID = -606371737889816130L;

            @Override
            public boolean accept(Tree t) {
                if (t.isLeaf() || t.isPreTerminal() || t.children().length != 1) {
                    return true;
                }
                return t.label() == null || !t.label().equals(t.children()[0].label());
            }
        };
    }

    public String rootSymbol() {
        return this.tlp.startSymbol();
    }

    public String nonUnaryRootSymbol() {
        return nonUnaryRoot;
    }

    public void setInsertNPinPP(boolean b) {
        this.insertNPinPP = b;
    }

    public boolean getInsertNPinPP() {
        return this.insertNPinPP;
    }

    public String normalizeTerminal(String leaf) {
        return leaf.intern();
    }

    public String normalizeNonterminal(String category) {
        if (junkCPP.equals(category)) {
            category = cpp;
        }
        return (category = this.cleanUpLabel(category)) == null ? null : category.intern();
    }

    private Tree fixNonUnaryRoot(Tree t, TreeFactory tf) {
        List<Tree> kids = t.getChildrenAsList();
        if (kids.size() == 2 && t.firstChild().isPhrasal() && this.tlp.isSentenceFinalPunctuationTag(t.lastChild().value())) {
            List<Tree> grandKids = t.firstChild().getChildrenAsList();
            grandKids.add(t.lastChild());
            t.firstChild().setChildren(grandKids);
            kids.remove(kids.size() - 1);
            t.setChildren(kids);
            t.setValue(this.tlp.startSymbol());
        } else {
            t.setValue(nonUnaryRoot);
            t = tf.newTreeNode(this.tlp.startSymbol(), Collections.singletonList(t));
        }
        return t;
    }

    public Tree normalizeWholeTree(Tree tree, TreeFactory tf) {
        if (tree.value() == null) {
            tree = this.fixNonUnaryRoot(tree, tf);
        } else if (!tree.value().equals(this.tlp.startSymbol())) {
            tree = tf.newTreeNode(this.tlp.startSymbol(), Collections.singletonList(tree));
        }
        tree = tree.prune(this.emptyFilter, tf).spliceOut(this.aOverAFilter, tf);
        if (this.insertNPinPP) {
            this.insertNPinPPall(tree);
        }
        for (Tree t : tree) {
            String cat;
            if (t.isLeaf() || t.isPreTerminal()) continue;
            if (t.value() == null || t.value().equals("")) {
                t.setValue("DUMMY");
            }
            if (t.value().matches("--.*") || (cat = t.value()) != null && !cat.equals("") || t.numChildren() != 3 || !t.firstChild().label().value().equals("NN") || !t.getChild(1).label().value().equals("$.")) continue;
            System.err.println("Correcting treebank error: giving phrase label DL to " + t);
            t.label().setValue("DL");
        }
        return tree;
    }

    private void insertNPinPPall(Tree t) {
        Tree[] kids = t.children();
        int n = kids.length;
        for (int i = 0; i < n; ++i) {
            this.insertNPinPPall(kids[i]);
        }
        this.insertNPinPP(t);
    }

    private void insertNPinPP(Tree t) {
        if (this.tlp.basicCategory(t.label().value()).equals("PP")) {
            int i;
            Tree[] kids = t.children();
            int j = kids.length - 1;
            for (i = 0; i < j && this.prepositionTags.contains(this.tlp.basicCategory(kids[i].label().value())); ++i) {
            }
            while (i < j && this.postpositionTags.contains(this.tlp.basicCategory(kids[j].label().value()))) {
                --j;
            }
            if (i > j) {
                System.err.println("##### Warning -- no NP material here!");
                return;
            }
            int npKidsLength = j - i + 1;
            Tree[] npKids = new Tree[npKidsLength];
            System.arraycopy(kids, i, npKids, 0, npKidsLength);
            Tree np = t.treeFactory().newTreeNode(t.label().labelFactory().newLabel("NP"), Arrays.asList(npKids));
            Tree[] newPPkids = new Tree[kids.length - npKidsLength + 1];
            System.arraycopy(kids, 0, newPPkids, 0, i + 1);
            newPPkids[i] = np;
            System.arraycopy(kids, j + 1, newPPkids, i + 1, kids.length - j - 1);
            t.setChildren(newPPkids);
            System.out.println("#### inserted NP in PP");
            t.pennPrint();
        }
    }

    protected String cleanUpLabel(String label) {
        if (this.nodeCleanup == 1) {
            return this.tlp.categoryAndFunction(label);
        }
        if (this.nodeCleanup == 2) {
            return this.tlp.basicCategory(label);
        }
        return label;
    }
}

