#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 bin
version:              0.1.4
visibility:           public
id:                   bin-0.1.4-7v6D7Y1jMDiBwIVKVeBd0U
key:                  bin-0.1.4-7v6D7Y1jMDiBwIVKVeBd0U
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Bin: binary natural numbers.
description:
    This package provides /binary natural numbers/ ("Data.Bin");
    also utilities to work on the type level with @DataKinds@ ("Data.Type.Bin").

    @
    data Bin
    \    = BZ       -- ^ zero
    \    | BP BinP  -- ^ non-zero

    data BinP
    \    = BE       -- ^ one
    \    | B0 BinP  -- ^ double
    \    | B1 BinP  -- ^ double plus 1
    @

    There are /ordinals/ in "Data.Bin.Pos" module, as well as
    fixed width integers in "Data.Wrd".

    Another implementation is at <https://hackage.haskell.org/package/nat>,
    this differs in naming, and provides promoted variant.

category:             Data, Dependent Types, Singletons, Math
abi:                  7e50c3798394c9fea1a5111d6ce7f0d8
exposed:              True
exposed-modules:
    Data.Bin Data.Bin.Pos Data.BinP Data.BinP.PosP Data.Type.Bin
    Data.Type.BinP Data.Wrd

hidden-modules:       TrustworthyCompat
import-dirs:          /usr/lib/ghc-9.6.6/site-local/bin-0.1.4
library-dirs:         /usr/lib/ghc-9.6.6/site-local/bin-0.1.4
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/bin-0.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-bin
hs-libraries:         HSbin-0.1.4-7v6D7Y1jMDiBwIVKVeBd0U
depends:
    QuickCheck-2.15.0.1-LaRIQHiwv8U7w9VIoXbmQQ base-4.18.2.1
    boring-0.2.2-2aq1ciWPNkQB31v6aiIRKA
    dec-0.0.6-263DLNY3k7iJhcZSv4mNkm deepseq-1.4.8.1
    fin-0.3.2-2KW0b0KG82UBkU7XNkOgpv
    hashable-1.4.7.0-2TMrYujL0SWBJEdw6jCOMM
    some-1.0.6-Ey5uT9oVYNeDPVOnvFLP1E

haddock-interfaces:   /usr/share/doc/haskell-bin/html/bin.haddock
haddock-html:         /usr/share/doc/haskell-bin/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

