---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: バーンダウンチャートとバーンアップチャート
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

[バーンダウン](#burndown-charts)チャートと[バーンアップ](#burnup-charts)チャートは、マイルストーンの完了に向けた進捗状況を示します。バーンダウンチャートは、プロジェクトの[マイルストーン](_index.md)の過程における残りのイシュー（バーンダウン）を示します。バーンアップチャートは、完了したイシューに対するイシューの総数を示します。

![バーンダウンとバーンアップチャート。時間の経過とともに残りのイシューを表示するバーンダウンチャート、および合計と完了済みのイシューを表示するバーンアップチャートで、マイルストーンの進捗状況を示しています。](img/burndown_and_burnup_charts_v15_3.png)

## 類似点と相違点 {#similarities-and-differences}

バーンダウンチャートとバーンアップチャートは、いくつかの一般的な機能を共有しています。バーンアップチャートとチャートはどちらも:

- 現在のマイルストーンの各日のイシューの総数を表示します。
- マイルストーンの各日について、イシューの合計数またはイシューの合計[ウェイト](../issues/issue_weight.md)を[切り替え](#switch-between-number-of-issues-and-issue-weight)ます。

バーンダウンチャートとバーンアップチャートの相違点は次のとおりです:

- バーンアップチャートには、マイルストーンにわたって完了したイシューを表す別の線が含まれています。
- 合計チャートは、イシューが別のマイルストーンに移動された場合（**合計**イシュー線が下がる）と、イシューがクローズされた場合（**合計**イシュー線は変更されない）の違いを反映します。
- バーンダウンチャートは毎日「合計イシューからクローズされたイシューを引いた数」を測定しますが、バーンアップチャートは、解決されたイシューとは別に、合計イシュー（オープンおよびクローズ）を測定します。

## イシュー数とイシューのウェイトの切替 {#switch-between-number-of-issues-and-issue-weight}

2つの設定を切り替えるには、チャートの上にある**イシュー**または**イシューのウェイト**を選択します。

ウェイトでソートする場合は、すべてのイシューにウェイトが割り当てられていることを確認してください。ウェイトのないイシューは、残りのウェイトの合計には表示されないためです。

## バーンダウンチャートとバーンアップチャートを使用するタイミング {#when-to-use-burndown-and-burnup-charts}

バーンダウンチャートとバーンアップチャートは、マイルストーンの進捗状況を追跡する際に貴重なインサイトを提供します。これらのチャートの使い方は、[ワークフロー](_index.md)でマイルストーンをどのように構成するかに依存します。

これらのチャートは、チームを支援します:

- マイルストーン期間全体を通して、リアルタイムで進捗状況を可視化します。
- 実際の進捗状況と理想的な進捗状況を比較することで、潜在的な遅延を早期に特定します。
- 理解しやすい視覚的なデータを使用して、ステークホルダーにステータスを伝えます。
- リソースの割り当てと優先順位付けについて、データに基づいた意思決定を行います。

残りの作業に焦点を当てるには、バーンダウンチャートを使用します。時間の経過に伴う完了した作業とスコープの変更を追跡するには、バーンアップチャートを使用します。バーンアップチャートは、チャートの合計イシューのスパイクを表示することにより、スコープクリープ（プロジェクトのスコープへの制御不能な追加）をモニタリングするのに特に役立ちます。

## バーンダウンチャート {#burndown-charts}

バーンダウンチャートは、マイルストーンの過程におけるイシューの数を示します。

![残りのイシューが減少する傾向を示すバーンダウンチャート、マイルストーンの期間](img/burndown_chart_v15_3.png)

一目で、特定のマイルストーンの完了の現在の状態がわかります。それらがなければ、マイルストーンからデータを整理し、自分でプロットして、同じような進捗状況を得る必要があります。

GitLabはそれをプロットし、明確で美しいチャートで表示します。

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>概要については、[バーンダウンチャートを使用した作業と時間のマッピング](https://www.youtube.com/watch?v=zJU2MuRChzs)に関するビデオデモをご覧ください。

プロジェクトのバーンダウンチャートを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで**Plan** > **マイルストーン**を選択します。
1. リストからマイルストーンを選択します。

グループのバーンダウンチャートを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで**Plan** > **マイルストーン**を選択します。
1. リストからマイルストーンを選択します。

### バーンダウンチャートの仕組み {#how-burndown-charts-work}

バーンダウンチャートは、**start date**（開始日）と**due date**（期日）が属性として割り当てられているすべてのプロジェクトまたはグループのマイルストーンで使用できます。

{{< alert type="note" >}}

[プロジェクト](_index.md#promote-a-project-milestone-to-a-group-milestone)をグループのマイルストーンにプロモートすることができ、ライセンスの制限を尊重しながら、それらの**burndown chart**（バーンダウン） チャートを表示することができます。

{{< /alert >}}

このチャートは、そのマイルストーン全体のプロジェクトの進捗状況を示します（それに割り当てられたイシューの場合）。

特に、マイルストーンの対応する期間に、特定の日にイシューがいくつオープンまたはまだオープンされているかを示します。

また、特定の日の[累積オープンイシューウェイト](#switch-between-number-of-issues-and-issue-weight)を表示するようにバーンダウンチャートを切り替えすることもできます。

### 固定されたバーンダウンチャート {#fixed-burndown-charts}

GitLab 13.6 以前に作成されたマイルストーンでは、バーンダウンチャートには、レガシービューと固定ビューを切り替えるための追加のトグルがあります。

| レガシー | 修正された |
| ----- | ----- |
| ![残りのイシューが減少することを示す、下降傾向線を示す従来のバーンダウンチャート。](img/burndown_chart_legacy_v13_6.png) | ![マイルストーンに多数のイシューが追加されたときのジャンプを示す固定バーンダウンチャート。](img/burndown_chart_fixed_v13_6.png) |

**Fixed burndown**（固定バーンダウン） チャートは、マイルストーンの作成からマイルストーンの有効期限が切れるまでの、マイルストーンアクティビティーの完全な履歴を追跡します。マイルストーンの期日が過ぎると、マイルストーンから削除されたイシューはチャートに影響を与えなくなります。

**Legacy burndown**（従来のバーンダウン） チャートは、イシューがいつ作成されたか、いつ最後にクローズされたかを追跡し、その完全な履歴を追跡しません。従来のバーンダウンチャートは、各日について、オープンイシューの数と、その日に作成されたイシューを取得し、その日にクローズされたイシューの数を差し引きます。開始日より以前に作成され、マイルストーンに割り当てられたイシュー（開始日時点でオープンしたまま）は、開始日にオープンしたと見なされます。したがって、マイルストーンの開始日が変更されると、各日にオープンされたイシューの数が変わる可能性があります。再度オープンされたイシューは、最後にクローズされた日の翌日にオープンされたと見なされます。

## バーンアップチャート {#burnup-charts}

バーンアップチャートは、マイルストーンに割り当てられ、完了した作業を示します。

![比較的安定した青い合計イシュー線と着実に増加するオレンジ色の完了したイシュー線という2本の線を表示するバーンアップチャート。](img/burnup_chart_v15_3.png)

プロジェクトのバーンアップチャートを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで**Plan** > **マイルストーン**を選択します。
1. リストからマイルストーンを選択します。

グループのバーンアップチャートを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. 左側のサイドバーで**Plan** > **マイルストーン**を選択します。
1. リストからマイルストーンを選択します。

### バーンアップチャートの仕組み {#how-burnup-charts-work}

バーンアップチャートには、合計作業と完了した作業に個別の線があります:

- **合計**線は、そのマイルストーンに割り当てられたイシューの数を測定することにより、マイルストーンのスコープの変更を反映します。
- **完了**線は、そのマイルストーンのクローズされたイシューの数を測定します。

オープンイシューが別のマイルストーンに移動されると、**合計**線は下がりますが、**完了**線は同じままです。**完了**線は、クローズされたイシューのみを追跡するため、変更されません。

イシューがクローズされると、**合計**線は同じままになり、**完了**線は上がります。

## ロールアップウェイト {#roll-up-weights}

{{< details >}}

- 提供形態: GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 17.1で`rollup_timebox_chart`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/381879)されました。デフォルトでは無効になっています。

{{< /history >}}

{{< alert type="flag" >}}

GitLab Self-Managedでは、デフォルトでこの機能は使用できません。詳細については、履歴を参照してください。この機能はテストには利用できますが、本番環境での使用には適していません。

{{< /alert >}}

[タスク](../../tasks.md)を使用すると、よりきめ細かい計画が可能になります。この機能が有効になっている場合、タスクを持つイシューのウェイトは、同じマイルストーン内のタスクから派生します。タスクを持つイシューは、バーンダウンチャートまたはバーンアップチャートで個別にカウントされません。

チャートでのイシューのウェイトのカウント方法:

- イシューのタスクにウェイトが割り当てられていない場合、イシューのウェイトが代わりに使用されます。
- イシューに複数のタスクがあり、一部のタスクが以前のイテレーションで完了している場合、このイテレーションのタスクのみが表示およびカウントされます。
- タスクが親なしでイテレーションに直接割り当てられている場合、それは最上位の項目であり、独自のウェイトをコントリビュートします。親のイシューは表示されません。

### ウェイトのロールアップの例 {#weight-rollup-examples}

**Example 1**（例1）

- イシューにはウェイト5があり、マイルストーン2に割り当てられています。
- タスク1にはウェイト2があり、マイルストーン1に割り当てられています。
- タスク2にはウェイト2があり、マイルストーン2に割り当てられています。
- タスク3にはウェイト2があり、マイルストーン2に割り当てられています。

マイルストーン1のチャートには、タスク1にウェイト2があると表示されます。

マイルストーン2のチャートには、イシューにウェイト4があると表示されます。

**Example 2**（例2）

- イシューにはウェイト5があり、マイルストーン2に割り当てられています。
- タスク1はウェイトなしでマイルストーン1に割り当てられています。
- タスク2はウェイトなしでマイルストーン2に割り当てられています。
- タスク3はウェイトなしでマイルストーン2に割り当てられています。

マイルストーン1のチャートには、タスク1にウェイト0があると表示されます。

マイルストーン2のチャートには、イシューにウェイト5があると表示されます。

**Example 3**（例3）

- イシューはウェイトなしでマイルストーン2に割り当てられています。
- タスク1にはウェイト2があり、マイルストーン1に割り当てられています
- タスク2にはウェイト2があり、マイルストーン2に割り当てられています
- タスク3にはウェイト2があり、マイルストーン2に割り当てられています

マイルストーン1のチャートには、タスク1にウェイト2があると表示されます。

マイルストーン2のチャートには、イシューにウェイト4があると表示されます。

## トラブルシューティング {#troubleshooting}

### バーンダウンチャートとバーンアップチャートに正しいイシューのステータスが表示されない {#burndown-and-burnup-charts-do-not-show-the-correct-issue-status}

これらのチャートの制限事項は、[日付がUTCタイムゾーンになっている](https://gitlab.com/gitlab-org/gitlab/-/issues/267967)ことです。

これにより、グラフが他のタイムゾーンで不正確になる可能性があります。例: 

- マイルストーン内のすべてのイシューは、最終日以前にクローズされたものとして記録されます。
- 1つのイシューが最終日の午後6時PST（太平洋時間、UTC-7）にクローズされました。
- イシューアクティビティーログには、マイルストーンの最終日の午後6時にクローズ時間が表示されます。
- チャートはUTCで時間をプロットするため、このイシューの場合、クローズ時間は翌日の午前1時です。
- チャートには、マイルストーンが不完全で、クローズされたイシューが1つ不足していると表示されます。
