/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

class NodeFontHyperLinkControlGroup
implements ControlGroup {
    private static final String NODE_FONT_HYPERLINK = "nodefonthyperlink";
    private RevertingProperty mSetNodeFontHyperlink;
    private BooleanProperty mNodeFontHyperlink;
    private FontHyperlinkChangeListener propertyChangeListener;

    NodeFontHyperLinkControlGroup() {
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetNodeFontHyperlink = new RevertingProperty();
        this.mNodeFontHyperlink = new BooleanProperty(NODE_FONT_HYPERLINK);
        this.propertyChangeListener = new FontHyperlinkChangeListener(this.mSetNodeFontHyperlink, new IPropertyControl[]{this.mNodeFontHyperlink});
        this.mSetNodeFontHyperlink.addPropertyChangeListener(this.propertyChangeListener);
        this.mNodeFontHyperlink.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mNodeFontHyperlink.appendToForm(formBuilder);
        this.mSetNodeFontHyperlink.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    private class FontHyperlinkChangeListener
    extends ControlGroupChangeListener {
        public FontHyperlinkChangeListener(RevertingProperty mSet, IPropertyControl ... mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MLinkController styleController = (MLinkController)Controller.getCurrentModeController().getExtension(LinkController.class);
            styleController.setFormatNodeAsHyperlink(node, enabled ? Boolean.valueOf(NodeFontHyperLinkControlGroup.this.mNodeFontHyperlink.getBooleanValue()) : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            Boolean hyperlink = NodeLinks.formatNodeAsHyperlink((NodeModel)node);
            Boolean viewhyperlink = LinkController.getController().formatNodeAsHyperlink(node);
            NodeFontHyperLinkControlGroup.this.mSetNodeFontHyperlink.setValue(hyperlink != null);
            NodeFontHyperLinkControlGroup.this.mNodeFontHyperlink.setValue(viewhyperlink.booleanValue());
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, NodeFontHyperLinkControlGroup.this.mSetNodeFontHyperlink);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)NodeFontHyperLinkControlGroup.this.mNodeFontHyperlink);
        }
    }
}

