/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.file;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleStorage;
import org.knopflerfish.framework.FWProps;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.bundlestorage.file.Archive;
import org.knopflerfish.framework.bundlestorage.file.BundleArchiveImpl;

public class BundleStorageImpl
implements BundleStorage {
    public static final String ALWAYS_UNPACK_PROP = "org.knopflerfish.framework.bundlestorage.file.always_unpack";
    public static final String REFERENCE_PROP = "org.knopflerfish.framework.bundlestorage.file.reference";
    public static final String TRUSTED_PROP = "org.knopflerfish.framework.bundlestorage.file.trusted";
    public static final String UNPACK_PROP = "org.knopflerfish.framework.bundlestorage.file.unpack";
    public static final String JAR_VERIFIER_BUG_PROP = "org.knopflerfish.framework.bundlestorage.file.jar_verifier_bug";
    protected boolean alwaysUnpack;
    protected boolean fileReference;
    protected boolean trustedStorage;
    protected boolean unpack;
    protected String execPermCmd;
    protected boolean isWindows;
    protected boolean jarVerifierBug;
    private FileTree bundlesDir;
    private long nextFreeId = 1L;
    private final ArrayList<BundleArchive> archives = new ArrayList();
    FrameworkContext framework;
    protected boolean checkSigned;
    protected boolean readOnly;

    public BundleStorageImpl(FrameworkContext framework) {
        this.framework = framework;
        this.initProps(framework.props);
        if (this.isReadOnly()) {
            if (this.alwaysUnpack) {
                throw new RuntimeException("Property 'org.knopflerfish.framework.bundlestorage.file.always_unpack' must be false when we are in read only mode!");
            }
            if (this.unpack) {
                throw new RuntimeException("Property 'org.knopflerfish.framework.bundlestorage.file.unpack' must be false when we are in read only mode!");
            }
        }
        this.bundlesDir = Util.getFileStorage(framework, "bs", !this.isReadOnly());
        if (this.bundlesDir == null) {
            throw new RuntimeException("No bundle storage area available!");
        }
        String[] list = this.bundlesDir.list();
        for (int i = 0; list != null && i < list.length; ++i) {
            int pos;
            long id;
            try {
                id = Long.parseLong(list[i]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (id == 0L) {
                System.err.println("Saved bundle with illegal id 0 is ignored.");
            }
            if ((pos = this.find(id)) < this.archives.size() && this.archives.get(pos).getBundleId() == id) {
                System.err.println("There are two bundle directories with id: " + id);
                break;
            }
            FileTree dir = new FileTree(this.bundlesDir, list[i]);
            if (!dir.isDirectory()) continue;
            try {
                boolean bUninstalled = BundleArchiveImpl.isUninstalled(dir);
                if (bUninstalled) {
                    dir.delete();
                } else {
                    BundleArchiveImpl ba = new BundleArchiveImpl(this, dir, id);
                    this.archives.add(pos, ba);
                }
                if (id < this.nextFreeId) continue;
                this.nextFreeId = id + 1L;
                continue;
            }
            catch (Exception e) {
                dir.delete();
                System.err.println("Removed corrupt bundle dir (" + e.getMessage() + "): " + dir);
            }
        }
    }

    @Override
    public BundleArchive insertBundleJar(String location, InputStream is) throws Exception {
        FileTree dir;
        long id = this.nextFreeId++;
        FileTree fileTree = dir = this.isReadOnly() ? null : new FileTree(this.bundlesDir, String.valueOf(id));
        if (dir != null) {
            if (dir.exists()) {
                dir.delete();
            }
            dir.mkdir();
        }
        try {
            BundleArchiveImpl ba = new BundleArchiveImpl(this, dir, is, location, id);
            this.archives.add(ba);
            return ba;
        }
        catch (Exception e) {
            if (dir != null) {
                dir.delete();
            }
            throw e;
        }
    }

    @Override
    public BundleArchive updateBundleArchive(BundleArchive old, InputStream is) throws Exception {
        return new BundleArchiveImpl((BundleArchiveImpl)old, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceBundleArchive(BundleArchive oldBA, BundleArchive newBA) throws Exception {
        long id = oldBA.getBundleId();
        ArrayList<BundleArchive> arrayList = this.archives;
        synchronized (arrayList) {
            int pos = this.find(id);
            if (pos >= this.archives.size() || this.archives.get(pos) != oldBA) {
                throw new Exception("replaceBundleJar: Old bundle archive not found, pos=" + pos);
            }
            this.archives.set(pos, newBA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BundleArchive[] getAllBundleArchives() {
        ArrayList<BundleArchive> arrayList = this.archives;
        synchronized (arrayList) {
            return this.archives.toArray(new BundleArchive[this.archives.size()]);
        }
    }

    @Override
    public List<String> getStartOnLaunchBundles() {
        ArrayList<String> res = new ArrayList<String>();
        for (BundleArchive ba : this.archives) {
            if (ba.getAutostartSetting() == -1) continue;
            res.add(ba.getBundleLocation());
        }
        return res;
    }

    @Override
    public void close() {
        Iterator<BundleArchive> i = this.archives.iterator();
        while (i.hasNext()) {
            BundleArchive ba = i.next();
            ba.close();
            i.remove();
        }
        this.framework = null;
        this.bundlesDir = null;
    }

    protected Archive createArchive(BundleArchiveImpl ba, FileTree dir, int rev) {
        return new Archive(ba, dir, rev);
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeArchive(BundleArchive ba) {
        ArrayList<BundleArchive> arrayList = this.archives;
        synchronized (arrayList) {
            int pos = this.find(ba.getBundleId());
            if (pos < this.archives.size() && this.archives.get(pos) == ba) {
                this.archives.remove(pos);
                return true;
            }
            return false;
        }
    }

    private void initProps(FWProps props) {
        props.setPropertyDefault(ALWAYS_UNPACK_PROP, "false");
        props.setPropertyDefault(REFERENCE_PROP, "false");
        props.setPropertyDefault(TRUSTED_PROP, "true");
        props.setPropertyDefault(UNPACK_PROP, "true");
        props.setPropertyDefault(JAR_VERIFIER_BUG_PROP, "false");
        this.alwaysUnpack = props.getBooleanProperty(ALWAYS_UNPACK_PROP);
        this.fileReference = props.getBooleanProperty(REFERENCE_PROP);
        this.trustedStorage = props.getBooleanProperty(TRUSTED_PROP);
        this.unpack = props.getBooleanProperty(UNPACK_PROP);
        this.execPermCmd = props.getProperty("org.osgi.framework.command.execpermission").trim();
        this.checkSigned = props.getBooleanProperty("org.knopflerfish.framework.bundlestorage.checksigned");
        this.isWindows = props.getProperty("org.osgi.framework.os.name").startsWith("Windows");
        this.jarVerifierBug = props.getBooleanProperty(JAR_VERIFIER_BUG_PROP);
        this.readOnly = props.getBooleanProperty("org.knopflerfish.framework.readonly");
    }

    private int find(long id) {
        int lb = 0;
        int ub = this.archives.size() - 1;
        int x = 0;
        while (lb < ub) {
            x = (lb + ub) / 2;
            long xid = this.archives.get(x).getBundleId();
            if (id == xid) {
                return x;
            }
            if (id < xid) {
                ub = x;
                continue;
            }
            lb = x + 1;
        }
        if (lb < this.archives.size() && this.archives.get(lb).getBundleId() < id) {
            return lb + 1;
        }
        return lb;
    }
}

