/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.awt.FontMetrics;
import java.util.List;
import javax.swing.Icon;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.ConnectorLabelCondition;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;

public class ConnectorLabelContainsCondition
extends ConnectorLabelCondition {
    public static final String NAME = "connector_label_contains";

    public ConnectorLabelContainsCondition(String text, boolean matchCase, boolean matchApproximately, boolean matchWordwise, boolean ignoreDiacritics) {
        super(text, matchCase, matchApproximately, matchWordwise, ignoreDiacritics);
    }

    @Override
    public boolean check(ConnectorModel connector) {
        LinkController linkController = LinkController.getController();
        String middleLabel = linkController.getMiddleLabel(connector);
        if (this.contains(middleLabel)) {
            return true;
        }
        String sourceLabel = linkController.getSourceLabel(connector);
        if (this.contains(sourceLabel)) {
            return true;
        }
        String targetLabel = linkController.getTargetLabel(connector);
        return this.contains(targetLabel);
    }

    private boolean contains(String middleLabel) {
        if (middleLabel == null) {
            return false;
        }
        return this.getStringMatchingStrategy().matches(this.normalizedValue(), this.normalize(middleLabel), this.substringMatchType());
    }

    @Override
    protected String createDescription() {
        String condition = TextUtils.getText("connector_label");
        return this.createDescription(condition, this.containsDescription(), this.getText());
    }

    @Override
    protected List<Icon> createRenderedIcons(FontMetrics fontMetrics) {
        String condition = TextUtils.getText("connector_label");
        return this.createRenderedIcons(condition, this.containsOperator(), this.getText(), fontMetrics);
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

