/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.theme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.properties.ViewTitleBarProperties;
import net.infonode.docking.properties.WindowBarProperties;
import net.infonode.docking.theme.DockingWindowsTheme;
import net.infonode.docking.theme.internal.laftheme.TitleBarUI;
import net.infonode.docking.theme.internal.laftheme.TitleBarUIListener;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.colorprovider.BackgroundColorProvider;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.CompoundComponentPainter;
import net.infonode.gui.componentpainter.SolidColorComponentPainter;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.tabbedpanel.theme.LookAndFeelTheme;
import net.infonode.tabbedpanel.titledtab.TitledTabSizePolicy;
import net.infonode.util.Direction;

public class LookAndFeelDockingTheme
extends DockingWindowsTheme {
    private static LookAndFeelTheme tpTheme;
    private static RootWindowProperties rootProps;
    private RootWindowProperties themeRootProps = new RootWindowProperties();
    private static TitleBarUI titleBarUI;
    private static int themeCounter;
    private boolean disposed = false;

    static {
        rootProps = new RootWindowProperties();
        themeCounter = 0;
    }

    public LookAndFeelDockingTheme() {
        if (themeCounter == 0) {
            tpTheme = new LookAndFeelTheme();
            titleBarUI = new TitleBarUI(new TitleBarUIListener(){

                @Override
                public void updating() {
                }

                @Override
                public void updated() {
                    LookAndFeelDockingTheme.this.initTheme(false);
                }
            }, false);
            titleBarUI.init();
            this.initTheme(true);
        }
        ++themeCounter;
        this.themeRootProps.addSuperObject(rootProps);
    }

    @Override
    public String getName() {
        return "Look and Feel Theme";
    }

    @Override
    public RootWindowProperties getRootWindowProperties() {
        return this.themeRootProps;
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            if (--themeCounter == 0) {
                titleBarUI.dispose();
                PropertyMapManager.runBatch(new Runnable(){

                    @Override
                    public void run() {
                        rootProps.getTabWindowProperties().getTabbedPanelProperties().removeSuperObject(tpTheme.getTabbedPanelProperties());
                        rootProps.getTabWindowProperties().getTabProperties().getTitledTabProperties().removeSuperObject(tpTheme.getTitledTabProperties());
                        rootProps.getMap().clear(true);
                    }
                });
                tpTheme.dispose();
            }
        }
    }

    private void initTheme(final boolean initial) {
        PropertyMapManager.runBatch(new Runnable(){

            @Override
            public void run() {
                if (initial) {
                    rootProps.getTabWindowProperties().getTabbedPanelProperties().addSuperObject(tpTheme.getTabbedPanelProperties());
                    rootProps.getTabWindowProperties().getTabProperties().getTitledTabProperties().addSuperObject(tpTheme.getTitledTabProperties());
                }
                rootProps.getMap().clear(true);
                WindowBarProperties barProps = rootProps.getWindowBarProperties();
                barProps.getTabWindowProperties().getTabProperties().getTitledTabProperties().setSizePolicy(TitledTabSizePolicy.EQUAL_SIZE);
                barProps.getComponentProperties().setBorder(null);
                final Border contentBorder = tpTheme.getTabbedPanelProperties().getContentPanelProperties().getComponentProperties().getBorder();
                ComponentPainter barContentPainter = tpTheme.getTabbedPanelProperties().getContentPanelProperties().getShapedPanelProperties().getComponentPainter();
                barProps.getTabWindowProperties().getTabbedPanelProperties().getContentPanelProperties().getShapedPanelProperties().setOpaque(true).setComponentPainter(new CompoundComponentPainter(new SolidColorComponentPainter(BackgroundColorProvider.INSTANCE), barContentPainter));
                barProps.getTabWindowProperties().getTabbedPanelProperties().getTabAreaComponentsProperties().getComponentProperties().setBorder(null);
                barProps.getTabWindowProperties().getTabbedPanelProperties().getContentPanelProperties().getComponentProperties().setBorder(new Border(){

                    @Override
                    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    }

                    @Override
                    public Insets getBorderInsets(Component c) {
                        Insets insets = (Insets)contentBorder.getBorderInsets(c).clone();
                        Direction areaOrientation = TabbedUtils.getParentTabbedPanelContentPanel(c).getTabbedPanel().getProperties().getTabAreaOrientation();
                        int minResizeEdgeInset = InsetsUtil.maxInset(insets);
                        if (areaOrientation == Direction.UP) {
                            insets.bottom = Math.max(minResizeEdgeInset, insets.bottom);
                        } else if (areaOrientation == Direction.DOWN) {
                            insets.top = Math.max(minResizeEdgeInset, insets.top);
                        } else if (areaOrientation == Direction.LEFT) {
                            insets.right = Math.max(minResizeEdgeInset, insets.right);
                        } else {
                            insets.left = Math.max(minResizeEdgeInset, insets.left);
                        }
                        return insets;
                    }

                    @Override
                    public boolean isBorderOpaque() {
                        return false;
                    }
                }).setInsets(new Insets(0, 0, 0, 0)).setBackgroundColor(null);
                final Color top = tpTheme.getBorderColor(Direction.UP);
                final Color left = tpTheme.getBorderColor(Direction.LEFT);
                final Color bottom = tpTheme.getBorderColor(Direction.DOWN);
                final Color right = tpTheme.getBorderColor(Direction.RIGHT);
                final Insets borderInsets = new Insets(top == null ? 0 : 1, left == null ? 0 : 1, bottom == null ? 0 : 1, right == null ? 0 : 1);
                final boolean borderOpaque = top != null && top.getAlpha() == 255 || left != null && left.getAlpha() == 255 || bottom != null && bottom.getAlpha() == 255 || right != null && right.getAlpha() == 255;
                Border windowAreaBorder = new Border(){

                    @Override
                    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                        if (top != null) {
                            g.setColor(top);
                            g.drawLine(x, y, x + width - (right == null ? 1 : 2), y);
                        }
                        if (right != null) {
                            g.setColor(right);
                            g.drawLine(x + width - 1, y, x + width - 1, y + height - (bottom == null ? 1 : 2));
                        }
                        if (bottom != null) {
                            g.setColor(bottom);
                            g.drawLine(left == null ? x : x + 1, y + height - 1, x + width - 1, y + height - 1);
                        }
                        if (left != null) {
                            g.setColor(left);
                            g.drawLine(x, top == null ? y : y + 1, x, y + height - 1);
                        }
                    }

                    @Override
                    public Insets getBorderInsets(Component c) {
                        return borderInsets;
                    }

                    @Override
                    public boolean isBorderOpaque() {
                        return borderOpaque;
                    }
                };
                rootProps.getWindowAreaProperties().setInsets(new Insets(2, 2, 2, 2)).setBorder(windowAreaBorder).setBackgroundColor(null);
                rootProps.getWindowAreaShapedPanelProperties().setComponentPainter(new SolidColorComponentPainter(BackgroundColorProvider.INSTANCE)).setOpaque(true);
                ViewTitleBarProperties titleBarProps = rootProps.getViewProperties().getViewTitleBarProperties();
                titleBarProps.getNormalProperties().getShapedPanelProperties().setDirection(titleBarUI.getRenderingDirection());
                ComponentPainter normalPainter = titleBarUI.getInactiveComponentPainter();
                if (normalPainter == null) {
                    titleBarProps.getNormalProperties().getShapedPanelProperties().getMap().removeValue(ShapedPanelProperties.COMPONENT_PAINTER);
                } else {
                    titleBarProps.getNormalProperties().getShapedPanelProperties().setComponentPainter(normalPainter);
                }
                ComponentPainter focusedPainter = titleBarUI.getActiveComponentPainter();
                if (focusedPainter == null) {
                    titleBarProps.getFocusedProperties().getShapedPanelProperties().getMap().removeValue(ShapedPanelProperties.COMPONENT_PAINTER);
                } else {
                    titleBarProps.getFocusedProperties().getShapedPanelProperties().setComponentPainter(focusedPainter);
                }
                titleBarProps.setMinimumSizeProvider(titleBarUI.getSizeDimensionProvider()).getNormalProperties().setTitleVisible(!titleBarUI.isRenderingTitle()).setIconVisible(!titleBarUI.isRenderingIcon());
                titleBarProps.getFocusedProperties().getComponentProperties().setInsets(titleBarUI.getInsets());
                titleBarProps.getNormalProperties().getComponentProperties().setInsets(titleBarUI.getInsets());
                LookAndFeelDockingTheme.this.updateBackgroundColor(titleBarProps.getNormalProperties().getComponentProperties(), titleBarUI.getInactiveBackgroundColor());
                LookAndFeelDockingTheme.this.updateBackgroundColor(titleBarProps.getFocusedProperties().getComponentProperties(), titleBarUI.getActiveBackgroundColor());
                rootProps.setDragRectangleBorderWidth(3);
            }
        });
    }

    private void updateBackgroundColor(ComponentProperties props, Color color) {
        if (color == null) {
            props.getMap().removeValue(ComponentProperties.BACKGROUND_COLOR);
        } else {
            props.setBackgroundColor(color);
        }
    }
}

