﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMakerRequest.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>

#include <utility>

namespace Aws {
namespace SageMaker {
namespace Model {

/**
 */
class DescribeNotebookInstanceRequest : public SageMakerRequest {
 public:
  AWS_SAGEMAKER_API DescribeNotebookInstanceRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeNotebookInstance"; }

  AWS_SAGEMAKER_API Aws::String SerializePayload() const override;

  AWS_SAGEMAKER_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The name of the notebook instance that you want information about.</p>
   */
  inline const Aws::String& GetNotebookInstanceName() const { return m_notebookInstanceName; }
  inline bool NotebookInstanceNameHasBeenSet() const { return m_notebookInstanceNameHasBeenSet; }
  template <typename NotebookInstanceNameT = Aws::String>
  void SetNotebookInstanceName(NotebookInstanceNameT&& value) {
    m_notebookInstanceNameHasBeenSet = true;
    m_notebookInstanceName = std::forward<NotebookInstanceNameT>(value);
  }
  template <typename NotebookInstanceNameT = Aws::String>
  DescribeNotebookInstanceRequest& WithNotebookInstanceName(NotebookInstanceNameT&& value) {
    SetNotebookInstanceName(std::forward<NotebookInstanceNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_notebookInstanceName;
  bool m_notebookInstanceNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
