﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/eventbridge/EventBridge_EXPORTS.h>
#include <aws/eventbridge/model/Replay.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace EventBridge {
namespace Model {
class ListReplaysResult {
 public:
  AWS_EVENTBRIDGE_API ListReplaysResult() = default;
  AWS_EVENTBRIDGE_API ListReplaysResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_EVENTBRIDGE_API ListReplaysResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An array of <code>Replay</code> objects that contain information about the
   * replay.</p>
   */
  inline const Aws::Vector<Replay>& GetReplays() const { return m_replays; }
  template <typename ReplaysT = Aws::Vector<Replay>>
  void SetReplays(ReplaysT&& value) {
    m_replaysHasBeenSet = true;
    m_replays = std::forward<ReplaysT>(value);
  }
  template <typename ReplaysT = Aws::Vector<Replay>>
  ListReplaysResult& WithReplays(ReplaysT&& value) {
    SetReplays(std::forward<ReplaysT>(value));
    return *this;
  }
  template <typename ReplaysT = Replay>
  ListReplaysResult& AddReplays(ReplaysT&& value) {
    m_replaysHasBeenSet = true;
    m_replays.emplace_back(std::forward<ReplaysT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token indicating there are more results available. If there are no more
   * results, no token is included in the response.</p> <p>The value of
   * <code>nextToken</code> is a unique pagination token for each page. To retrieve
   * the next page of results, make the call again using the returned token. Keep all
   * other arguments unchanged.</p> <p> Using an expired pagination token results in
   * an <code>HTTP 400 InvalidToken</code> error.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListReplaysResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListReplaysResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Replay> m_replays;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_replaysHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace EventBridge
}  // namespace Aws
