﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/datapipeline/DataPipeline_EXPORTS.h>
#include <aws/datapipeline/model/ValidationError.h>
#include <aws/datapipeline/model/ValidationWarning.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DataPipeline {
namespace Model {
/**
 * <p>Contains the output of PutPipelineDefinition.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/PutPipelineDefinitionOutput">AWS
 * API Reference</a></p>
 */
class PutPipelineDefinitionResult {
 public:
  AWS_DATAPIPELINE_API PutPipelineDefinitionResult() = default;
  AWS_DATAPIPELINE_API PutPipelineDefinitionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DATAPIPELINE_API PutPipelineDefinitionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The validation errors that are associated with the objects defined in
   * <code>pipelineObjects</code>.</p>
   */
  inline const Aws::Vector<ValidationError>& GetValidationErrors() const { return m_validationErrors; }
  template <typename ValidationErrorsT = Aws::Vector<ValidationError>>
  void SetValidationErrors(ValidationErrorsT&& value) {
    m_validationErrorsHasBeenSet = true;
    m_validationErrors = std::forward<ValidationErrorsT>(value);
  }
  template <typename ValidationErrorsT = Aws::Vector<ValidationError>>
  PutPipelineDefinitionResult& WithValidationErrors(ValidationErrorsT&& value) {
    SetValidationErrors(std::forward<ValidationErrorsT>(value));
    return *this;
  }
  template <typename ValidationErrorsT = ValidationError>
  PutPipelineDefinitionResult& AddValidationErrors(ValidationErrorsT&& value) {
    m_validationErrorsHasBeenSet = true;
    m_validationErrors.emplace_back(std::forward<ValidationErrorsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The validation warnings that are associated with the objects defined in
   * <code>pipelineObjects</code>.</p>
   */
  inline const Aws::Vector<ValidationWarning>& GetValidationWarnings() const { return m_validationWarnings; }
  template <typename ValidationWarningsT = Aws::Vector<ValidationWarning>>
  void SetValidationWarnings(ValidationWarningsT&& value) {
    m_validationWarningsHasBeenSet = true;
    m_validationWarnings = std::forward<ValidationWarningsT>(value);
  }
  template <typename ValidationWarningsT = Aws::Vector<ValidationWarning>>
  PutPipelineDefinitionResult& WithValidationWarnings(ValidationWarningsT&& value) {
    SetValidationWarnings(std::forward<ValidationWarningsT>(value));
    return *this;
  }
  template <typename ValidationWarningsT = ValidationWarning>
  PutPipelineDefinitionResult& AddValidationWarnings(ValidationWarningsT&& value) {
    m_validationWarningsHasBeenSet = true;
    m_validationWarnings.emplace_back(std::forward<ValidationWarningsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether there were validation errors, and the pipeline definition
   * is stored but cannot be activated until you correct the pipeline and call
   * <code>PutPipelineDefinition</code> to commit the corrected pipeline.</p>
   */
  inline bool GetErrored() const { return m_errored; }
  inline void SetErrored(bool value) {
    m_erroredHasBeenSet = true;
    m_errored = value;
  }
  inline PutPipelineDefinitionResult& WithErrored(bool value) {
    SetErrored(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  PutPipelineDefinitionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<ValidationError> m_validationErrors;

  Aws::Vector<ValidationWarning> m_validationWarnings;

  bool m_errored{false};

  Aws::String m_requestId;
  bool m_validationErrorsHasBeenSet = false;
  bool m_validationWarningsHasBeenSet = false;
  bool m_erroredHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DataPipeline
}  // namespace Aws
