/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy.tabbed;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.hierarchy.tabbed.Edge;
import org.protege.editor.owl.model.hierarchy.tabbed.HierarchyAxiomProvider;
import org.protege.editor.owl.model.hierarchy.tabbed.HierarchyNodeCreator;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class CreateHierarchyChangeGenerator<E extends OWLEntity> {
    private final HierarchyNodeCreator<E> hierarchyNodeCreator;
    private final HierarchyAxiomProvider<E> hierarchyAxiomProvider;
    private final OWLOntology targetOntology;

    public CreateHierarchyChangeGenerator(@Nonnull HierarchyNodeCreator<E> hierarchyNodeCreator, @Nonnull HierarchyAxiomProvider<E> hierarchyAxiomProvider, @Nonnull OWLOntology targetOntology) {
        this.hierarchyNodeCreator = (HierarchyNodeCreator)Preconditions.checkNotNull(hierarchyNodeCreator);
        this.hierarchyAxiomProvider = (HierarchyAxiomProvider)Preconditions.checkNotNull(hierarchyAxiomProvider);
        this.targetOntology = (OWLOntology)Preconditions.checkNotNull((Object)targetOntology);
    }

    @Nonnull
    public ImmutableSetMultimap<E, E> generateHierarchy(@Nonnull Collection<Edge> edges, List<OWLOntologyChange> changeList) {
        HashMultimap parentChildMap = HashMultimap.create();
        for (Edge edge : edges) {
            this.generateChangesForEdge(edge, changeList, (Multimap<E, E>)parentChildMap);
        }
        return ImmutableSetMultimap.copyOf((Multimap)parentChildMap);
    }

    private void generateChangesForEdge(@Nonnull Edge edge, @Nonnull List<OWLOntologyChange> changeList, @Nonnull Multimap<E, E> parentChildMap) {
        E parent = this.generateParent(edge, changeList);
        E child = this.generateChild(edge, changeList);
        parentChildMap.put(parent, child);
        Optional<OWLAxiom> parentChildRelationship = this.hierarchyAxiomProvider.getAxiom(child, parent);
        parentChildRelationship.ifPresent(ax -> changeList.add((OWLOntologyChange)new AddAxiom(this.targetOntology, ax)));
    }

    @Nonnull
    private E generateParent(@Nonnull Edge edge, @Nonnull List<OWLOntologyChange> changeList) {
        return this.hierarchyNodeCreator.createEntity(edge.getParentName(), changeList);
    }

    @Nonnull
    private E generateChild(@Nonnull Edge edge, @Nonnull List<OWLOntologyChange> changeList) {
        return this.hierarchyNodeCreator.createEntity(Optional.ofNullable(edge.getChildName()), changeList);
    }
}

