/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.model;

import java.io.IOException;
import java.time.Instant;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.schedule.CronSchedule;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;

public class ExtensionJobParameter
implements ScheduledJobParameter,
Writeable {
    public static final String NAME_FIELD = "name";
    public static final String SCHEDULE_FIELD = "schedule";
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    public static final String ENABLED_TIME_FIELD = "enabled_time";
    public static final String IS_ENABLED_FIELD = "enabled";
    public static final String LOCK_DURATION_SECONDS_FIELD = "lock_duration_seconds";
    public static final String JITTER_FIELD = "jitter";
    private String jobName;
    private Schedule schedule;
    private Instant lastUpdateTime;
    private Instant enabledTime;
    private boolean isEnabled;
    @Nullable
    private Long lockDurationSeconds;
    @Nullable
    private Double jitter;

    public ExtensionJobParameter(String jobName, Schedule schedule, Instant lastUpdateTime, Instant enabledTime, boolean isEnabled, Long lockDurationSeconds, Double jitter) {
        this.jobName = jobName;
        this.schedule = schedule;
        this.lastUpdateTime = lastUpdateTime;
        this.enabledTime = enabledTime;
        this.isEnabled = isEnabled;
        this.lockDurationSeconds = lockDurationSeconds;
        this.jitter = jitter;
    }

    public ExtensionJobParameter(ScheduledJobParameter jobParameter) {
        this.jobName = jobParameter.getName();
        this.schedule = jobParameter.getSchedule();
        this.lastUpdateTime = jobParameter.getLastUpdateTime();
        this.enabledTime = jobParameter.getEnabledTime();
        this.isEnabled = jobParameter.isEnabled();
        this.lockDurationSeconds = jobParameter.getLockDurationSeconds();
        this.jitter = jobParameter.getJitter() != null ? jobParameter.getJitter() : Double.valueOf(0.0);
    }

    public ExtensionJobParameter(StreamInput in) throws IOException {
        this.jobName = in.readString();
        this.schedule = in.readEnum(ScheduleType.class) == ScheduleType.CRON ? new CronSchedule(in) : new IntervalSchedule(in);
        this.lastUpdateTime = in.readInstant();
        this.enabledTime = in.readInstant();
        this.isEnabled = in.readBoolean();
        this.lockDurationSeconds = in.readOptionalLong();
        this.jitter = in.readOptionalDouble();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobName);
        if (this.schedule instanceof CronSchedule) {
            out.writeEnum((Enum)ScheduleType.CRON);
        } else {
            out.writeEnum((Enum)ScheduleType.INTERVAL);
        }
        this.schedule.writeTo(out);
        out.writeInstant(this.lastUpdateTime);
        out.writeInstant(this.enabledTime);
        out.writeBoolean(this.isEnabled);
        out.writeOptionalLong(this.lockDurationSeconds);
        out.writeOptionalDouble(this.jitter);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD, this.jobName).field(SCHEDULE_FIELD, (ToXContent)this.schedule).field(LAST_UPDATE_TIME_FIELD, this.lastUpdateTime.toEpochMilli()).field(ENABLED_TIME_FIELD, this.enabledTime.toEpochMilli()).field(IS_ENABLED_FIELD, this.isEnabled);
        if (this.lockDurationSeconds != null) {
            builder.field(LOCK_DURATION_SECONDS_FIELD, this.lockDurationSeconds);
        }
        if (this.jitter != null) {
            builder.field(JITTER_FIELD, this.jitter);
        }
        builder.endObject();
        return builder;
    }

    public String getName() {
        return this.jobName;
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Instant getEnabledTime() {
        return this.enabledTime;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Long getLockDurationSeconds() {
        return this.lockDurationSeconds;
    }

    public Double getJitter() {
        return this.jitter;
    }

    public static enum ScheduleType {
        CRON,
        INTERVAL;

    }
}

