/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.install4j.runtime.installer.platform.macos.MacLocalization;
import com.install4j.runtime.installer.platform.win32.Common;
import java.io.File;
import java.util.List;

public class MacAuthorization {
    private static final String FAILURE_MARKER = "__ejtf_";
    private static final int SUCCESS = 0;
    private static final String UNINITIALIZED_DEFAULT_PROMPT = "__uninitialized";
    private static volatile String defaultPrompt;

    private static native int create0(String var0);

    private static native int free0();

    private static native int execute0(String var0, String[] var1);

    private static native String executeAndWait0(String var0, String[] var1);

    private static synchronized void createAuthorization(String prompt) throws AuthorizationException {
        MacAuthorization.checkResult(MacAuthorization.create0(prompt));
    }

    private static void checkResult(int result) throws AuthorizationException {
        if (result != 0) {
            throw new AuthorizationException(result);
        }
    }

    public static synchronized void free() throws AuthorizationException {
        MacAuthorization.checkResult(MacAuthorization.free0());
    }

    public static String executeAndWait(String prompt, String command, List<String> arguments) throws BaseAuthorizationException {
        MacAuthorization.createAuthorization(prompt);
        String ret = MacAuthorization.executeAndWait0(command, MacAuthorization.getArgumentsArray(arguments));
        if (ret == null) {
            throw new ExecutionException(-1);
        }
        if (ret.startsWith(FAILURE_MARKER)) {
            int errorCode = -2;
            try {
                errorCode = Integer.parseInt(ret.substring(FAILURE_MARKER.length()));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            throw new ExecutionException(errorCode);
        }
        return ret;
    }

    public static void execute(String prompt, String command, List<String> arguments) throws BaseAuthorizationException {
        MacAuthorization.createAuthorization(prompt);
        int ret = MacAuthorization.execute0(command, MacAuthorization.getArgumentsArray(arguments));
        if (ret != 0) {
            throw new ExecutionException(ret);
        }
    }

    private static String[] getArgumentsArray(List<String> arguments) {
        return arguments == null ? null : arguments.toArray(new String[0]);
    }

    public static String getDefaultPrompt(String appName) {
        if (appName == null) {
            return null;
        }
        if (UNINITIALIZED_DEFAULT_PROMPT.equals(defaultPrompt)) {
            String bundlePath = "/System/Library/Frameworks/Security.framework/Versions/Current/MachServices/SecurityAgent.bundle";
            if (!new File(bundlePath).exists()) {
                bundlePath = "/System/Library/Frameworks/Security.framework/Versions/Current/XPCServices/SecurityAgent.xpc";
            }
            defaultPrompt = MacLocalization.getLocalizedString(bundlePath, "%1$@ wants to make changes.", appName);
        }
        return defaultPrompt;
    }

    static {
        Common.init();
        defaultPrompt = UNINITIALIZED_DEFAULT_PROMPT;
    }

    public static class ExecutionException
    extends BaseAuthorizationException {
        private ExecutionException(int errorCode) {
            super(errorCode);
        }
    }

    public static class AuthorizationException
    extends BaseAuthorizationException {
        private AuthorizationException(int errorCode) {
            super(errorCode);
        }
    }

    public static class BaseAuthorizationException
    extends Exception {
        private final int errorCode;

        private BaseAuthorizationException(int errorCode) {
            super("error code " + errorCode);
            this.errorCode = errorCode;
        }

        public int getErrorCode() {
            return this.errorCode;
        }
    }
}

