/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Classifies the intensity values of a scalar image using the K-Means
algorithm.


Given an input image with scalar values, it uses the K-Means
statistical classifier in order to define labels for every pixel in
the image. The filter is templated over the type of the input image.
The output image is predefined as having the same dimension of the
input image and pixel type unsigned char, under the assumption that
the classifier will generate less than 256 classes.

You may want to look also at the RelabelImageFilter that may be used
as a postprocessing stage, in particular if you are interested in
ordering the labels by their relative size in number of pixels.


See:
 Image

 ImageKmeansModelEstimator

 KdTreeBasedKmeansEstimator, WeightedCentroidKdTreeGenerator, KdTree

 RelabelImageFilter

 itk::simple::ScalarImageKmeans for the procedural interface

 itk::ScalarImageKmeansImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkScalarImageKmeansImageFilter.h
*/
public class ScalarImageKmeansImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ScalarImageKmeansImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ScalarImageKmeansImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ScalarImageKmeansImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ScalarImageKmeansImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ScalarImageKmeansImageFilter::~ScalarImageKmeansImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ScalarImageKmeansImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ScalarImageKmeansImageFilter::ScalarImageKmeansImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ScalarImageKmeansImageFilter() {
    this(SimpleITKJNI.new_ScalarImageKmeansImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ScalarImageKmeansImageFilter::SetClassWithInitialMean(std::vector&lt; double &gt; ClassWithInitialMean)
*/
public  void setClassWithInitialMean(VectorDouble ClassWithInitialMean) {
    SimpleITKJNI.ScalarImageKmeansImageFilter_setClassWithInitialMean(swigCPtr, this, VectorDouble.getCPtr(ClassWithInitialMean), ClassWithInitialMean);
  }

  /**
std::vector&lt;double&gt; itk::simple::ScalarImageKmeansImageFilter::GetClassWithInitialMean() const
*/
public  VectorDouble getClassWithInitialMean() {
    return new VectorDouble(SimpleITKJNI.ScalarImageKmeansImageFilter_getClassWithInitialMean(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ScalarImageKmeansImageFilter::SetUseNonContiguousLabels(bool UseNonContiguousLabels)

Set/Get the UseNonContiguousLabels flag. When this is set to false the
labels are numbered contiguously, like in {0,1,3..N}. When the flag is
set to true, the labels are selected in order to span the dynamic
range of the output image. This last option is useful when the output
image is intended only for display. The default value is false.

*/
public  void setUseNonContiguousLabels(boolean UseNonContiguousLabels) {
    SimpleITKJNI.ScalarImageKmeansImageFilter_setUseNonContiguousLabels(swigCPtr, this, UseNonContiguousLabels);
  }

  /**
Self&amp; itk::simple::ScalarImageKmeansImageFilter::UseNonContiguousLabelsOn()

Set the value of UseNonContiguousLabels to true or false respectfully.

*/
public  void useNonContiguousLabelsOn() {
    SimpleITKJNI.ScalarImageKmeansImageFilter_useNonContiguousLabelsOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ScalarImageKmeansImageFilter::UseNonContiguousLabelsOff()
*/
public  void useNonContiguousLabelsOff() {
    SimpleITKJNI.ScalarImageKmeansImageFilter_useNonContiguousLabelsOff(swigCPtr, this);
  }

  /**
bool itk::simple::ScalarImageKmeansImageFilter::GetUseNonContiguousLabels() const

Set/Get the UseNonContiguousLabels flag. When this is set to false the
labels are numbered contiguously, like in {0,1,3..N}. When the flag is
set to true, the labels are selected in order to span the dynamic
range of the output image. This last option is useful when the output
image is intended only for display. The default value is false.

*/
public  boolean getUseNonContiguousLabels() {
    return SimpleITKJNI.ScalarImageKmeansImageFilter_getUseNonContiguousLabels(swigCPtr, this);
  }

  /**
std::vector&lt;double&gt; itk::simple::ScalarImageKmeansImageFilter::GetFinalMeans() const

Return the array of Means found after the classification.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  VectorDouble getFinalMeans() {
    return new VectorDouble(SimpleITKJNI.ScalarImageKmeansImageFilter_getFinalMeans(swigCPtr, this), true);
  }

  /**
std::string itk::simple::ScalarImageKmeansImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ScalarImageKmeansImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ScalarImageKmeansImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ScalarImageKmeansImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ScalarImageKmeansImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ScalarImageKmeansImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
