/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static void throwAsUncheckedException(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable may not be null");
        ExceptionUtils.throwAs(throwable);
    }

    private static <T extends Throwable> void throwAs(Throwable t) throws T {
        throw t;
    }

    public static String printStackTrace(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable may not be null");
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }
}

