﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/frauddetector/FraudDetectorRequest.h>
#include <aws/frauddetector/FraudDetector_EXPORTS.h>

#include <utility>

namespace Aws {
namespace FraudDetector {
namespace Model {

/**
 */
class GetExternalModelsRequest : public FraudDetectorRequest {
 public:
  AWS_FRAUDDETECTOR_API GetExternalModelsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetExternalModels"; }

  AWS_FRAUDDETECTOR_API Aws::String SerializePayload() const override;

  AWS_FRAUDDETECTOR_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The Amazon SageMaker model endpoint.</p>
   */
  inline const Aws::String& GetModelEndpoint() const { return m_modelEndpoint; }
  inline bool ModelEndpointHasBeenSet() const { return m_modelEndpointHasBeenSet; }
  template <typename ModelEndpointT = Aws::String>
  void SetModelEndpoint(ModelEndpointT&& value) {
    m_modelEndpointHasBeenSet = true;
    m_modelEndpoint = std::forward<ModelEndpointT>(value);
  }
  template <typename ModelEndpointT = Aws::String>
  GetExternalModelsRequest& WithModelEndpoint(ModelEndpointT&& value) {
    SetModelEndpoint(std::forward<ModelEndpointT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The next page token for the request.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  GetExternalModelsRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of objects to return for the request.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline GetExternalModelsRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_modelEndpoint;

  Aws::String m_nextToken;

  int m_maxResults{0};
  bool m_modelEndpointHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_maxResultsHasBeenSet = false;
};

}  // namespace Model
}  // namespace FraudDetector
}  // namespace Aws
