/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.tesselatable;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Tesselatable;
import org.sunflow.core.primitive.TriangleMesh;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.Memory;
import org.sunflow.system.UI;
import org.sunflow.util.FloatArray;
import org.sunflow.util.IntArray;

public class FileMesh
implements Tesselatable {
    private String filename = null;
    private boolean smoothNormals = false;

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        return null;
    }

    public PrimitiveList tesselate() {
        if (this.filename.endsWith(".ra3")) {
            try {
                UI.printInfo(UI.Module.GEOM, "RA3 - Reading geometry: \"%s\" ...", this.filename);
                File file = new File(this.filename);
                FileInputStream fileInputStream = new FileInputStream(this.filename);
                MappedByteBuffer mappedByteBuffer = fileInputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
                mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                IntBuffer intBuffer = mappedByteBuffer.asIntBuffer();
                FloatBuffer floatBuffer = mappedByteBuffer.asFloatBuffer();
                int n = intBuffer.get(0);
                int n2 = intBuffer.get(1);
                UI.printInfo(UI.Module.GEOM, "RA3 -   * Reading %d vertices ...", n);
                float[] fArray = new float[3 * n];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = floatBuffer.get(2 + i);
                }
                UI.printInfo(UI.Module.GEOM, "RA3 -   * Reading %d triangles ...", n2);
                int[] nArray = new int[3 * n2];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = intBuffer.get(2 + fArray.length + i);
                }
                fileInputStream.close();
                UI.printInfo(UI.Module.GEOM, "RA3 -   * Creating mesh ...", new Object[0]);
                return this.generate(nArray, fArray, this.smoothNormals);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                UI.printError(UI.Module.GEOM, "Unable to read mesh file \"%s\" - file not found", this.filename);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                UI.printError(UI.Module.GEOM, "Unable to read mesh file \"%s\" - I/O error occured", this.filename);
            }
        } else if (this.filename.endsWith(".obj")) {
            int n = 1;
            try {
                String string;
                UI.printInfo(UI.Module.GEOM, "OBJ - Reading geometry: \"%s\" ...", this.filename);
                FloatArray floatArray = new FloatArray();
                IntArray intArray = new IntArray();
                FileReader fileReader = new FileReader(this.filename);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray;
                    if (string.startsWith("v")) {
                        stringArray = string.split("\\s+");
                        floatArray.add(Float.parseFloat(stringArray[1]));
                        floatArray.add(Float.parseFloat(stringArray[2]));
                        floatArray.add(Float.parseFloat(stringArray[3]));
                    } else if (string.startsWith("f")) {
                        stringArray = string.split("\\s+");
                        if (stringArray.length == 5) {
                            intArray.add(Integer.parseInt(stringArray[1]) - 1);
                            intArray.add(Integer.parseInt(stringArray[2]) - 1);
                            intArray.add(Integer.parseInt(stringArray[3]) - 1);
                            intArray.add(Integer.parseInt(stringArray[1]) - 1);
                            intArray.add(Integer.parseInt(stringArray[3]) - 1);
                            intArray.add(Integer.parseInt(stringArray[4]) - 1);
                        } else if (stringArray.length == 4) {
                            intArray.add(Integer.parseInt(stringArray[1]) - 1);
                            intArray.add(Integer.parseInt(stringArray[2]) - 1);
                            intArray.add(Integer.parseInt(stringArray[3]) - 1);
                        }
                    }
                    if (n % 100000 == 0) {
                        UI.printInfo(UI.Module.GEOM, "OBJ -   * Parsed %7d lines ...", n);
                    }
                    ++n;
                }
                fileReader.close();
                UI.printInfo(UI.Module.GEOM, "OBJ -   * Creating mesh ...", new Object[0]);
                return this.generate(intArray.trim(), floatArray.trim(), this.smoothNormals);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                UI.printError(UI.Module.GEOM, "Unable to read mesh file \"%s\" - file not found", this.filename);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                UI.printError(UI.Module.GEOM, "Unable to read mesh file \"%s\" - syntax error at line %d", n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                UI.printError(UI.Module.GEOM, "Unable to read mesh file \"%s\" - I/O error occured", this.filename);
            }
        } else if (this.filename.endsWith(".stl")) {
            try {
                UI.printInfo(UI.Module.GEOM, "STL - Reading geometry: \"%s\" ...", this.filename);
                FileInputStream fileInputStream = new FileInputStream(this.filename);
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(fileInputStream));
                fileInputStream.skip(80L);
                int n = this.getLittleEndianInt(dataInputStream.readInt());
                UI.printInfo(UI.Module.GEOM, "STL -   * Reading %d triangles ...", n);
                long l = new File(this.filename).length();
                if (l != (long)(84 + 50 * n)) {
                    UI.printWarning(UI.Module.GEOM, "STL - Size of file mismatch (expecting %s, found %s)", Memory.bytesToString(84 + 14 * n), Memory.bytesToString(l));
                    return null;
                }
                int[] nArray = new int[3 * n];
                float[] fArray = new float[9 * n];
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                while (n3 < n) {
                    dataInputStream.readInt();
                    dataInputStream.readInt();
                    dataInputStream.readInt();
                    int n6 = 0;
                    while (n6 < 3) {
                        nArray[n4 + n6] = n4 + n6;
                        fArray[n5 + 0] = this.getLittleEndianFloat(dataInputStream.readInt());
                        fArray[n5 + 1] = this.getLittleEndianFloat(dataInputStream.readInt());
                        fArray[n5 + 2] = this.getLittleEndianFloat(dataInputStream.readInt());
                        ++n6;
                        n5 += 3;
                    }
                    dataInputStream.readShort();
                    if ((n3 + 1) % 100000 == 0) {
                        UI.printInfo(UI.Module.GEOM, "STL -   * Parsed %7d triangles ...", n3 + 1);
                    }
                    ++n3;
                    n4 += 3;
                }
                fileInputStream.close();
                UI.printInfo(UI.Module.GEOM, "STL -   * Creating mesh ...", new Object[0]);
                if (this.smoothNormals) {
                    UI.printWarning(UI.Module.GEOM, "STL - format does not support shared vertices - normal smoothing disabled", new Object[0]);
                }
                return this.generate(nArray, fArray, false);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                UI.printError(UI.Module.GEOM, "Unable to read mesh file \"%s\" - file not found", this.filename);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                UI.printError(UI.Module.GEOM, "Unable to read mesh file \"%s\" - I/O error occured", this.filename);
            }
        } else {
            UI.printWarning(UI.Module.GEOM, "Unable to read mesh file \"%s\" - unrecognized format", this.filename);
        }
        return null;
    }

    private TriangleMesh generate(int[] nArray, float[] fArray, boolean bl) {
        Object object;
        ParameterList parameterList = new ParameterList();
        parameterList.addIntegerArray("triangles", nArray);
        parameterList.addPoints("points", ParameterList.InterpolationType.VERTEX, fArray);
        if (bl) {
            int n;
            object = new float[fArray.length];
            Point3 point3 = new Point3();
            Point3 point32 = new Point3();
            Point3 point33 = new Point3();
            Vector3 vector3 = new Vector3();
            for (n = 0; n < nArray.length; n += 3) {
                int n2 = nArray[n + 0];
                int n3 = nArray[n + 1];
                int n4 = nArray[n + 2];
                point3.set(fArray[3 * n2 + 0], fArray[3 * n2 + 1], fArray[3 * n2 + 2]);
                point32.set(fArray[3 * n3 + 0], fArray[3 * n3 + 1], fArray[3 * n3 + 2]);
                point33.set(fArray[3 * n4 + 0], fArray[3 * n4 + 1], fArray[3 * n4 + 2]);
                Point3.normal(point3, point32, point33, vector3);
                Object object2 = object;
                int n5 = 3 * n2 + 0;
                object2[n5] = object2[n5] + vector3.x;
                Object object3 = object;
                int n6 = 3 * n2 + 1;
                object3[n6] = object3[n6] + vector3.y;
                Object object4 = object;
                int n7 = 3 * n2 + 2;
                object4[n7] = object4[n7] + vector3.z;
                Object object5 = object;
                int n8 = 3 * n3 + 0;
                object5[n8] = object5[n8] + vector3.x;
                Object object6 = object;
                int n9 = 3 * n3 + 1;
                object6[n9] = object6[n9] + vector3.y;
                Object object7 = object;
                int n10 = 3 * n3 + 2;
                object7[n10] = object7[n10] + vector3.z;
                Object object8 = object;
                int n11 = 3 * n4 + 0;
                object8[n11] = object8[n11] + vector3.x;
                Object object9 = object;
                int n12 = 3 * n4 + 1;
                object9[n12] = object9[n12] + vector3.y;
                Object object10 = object;
                int n13 = 3 * n4 + 2;
                object10[n13] = object10[n13] + vector3.z;
            }
            for (n = 0; n < ((Object)object).length; n += 3) {
                vector3.set((float)object[n + 0], (float)object[n + 1], (float)object[n + 2]);
                vector3.normalize();
                object[n + 0] = vector3.x;
                object[n + 1] = vector3.y;
                object[n + 2] = vector3.z;
            }
            parameterList.addVectors("normals", ParameterList.InterpolationType.VERTEX, (float[])object);
        }
        if (((TriangleMesh)(object = (Object)new TriangleMesh())).update(parameterList, null)) {
            return object;
        }
        return null;
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        String string = parameterList.getString("filename", null);
        if (string != null) {
            this.filename = sunflowAPI.resolveIncludeFilename(string);
        }
        this.smoothNormals = parameterList.getBoolean("smooth_normals", this.smoothNormals);
        return this.filename != null;
    }

    private int getLittleEndianInt(int n) {
        return n >>> 24 | n >>> 8 & 0xFF00 | n << 8 & 0xFF0000 | n << 24;
    }

    private float getLittleEndianFloat(int n) {
        return Float.intBitsToFloat(this.getLittleEndianInt(n));
    }
}

