/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.audioengines.AudioEngine3DL2;
import com.sun.j3d.utils.universe.ConfigScreen;
import com.sun.j3d.utils.universe.ConfigView;
import com.sun.j3d.utils.universe.ConfiguredUniverse;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewerAvatar;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Viewer {
    private static final boolean debug = false;
    private static PhysicalBody physicalBody = null;
    private static PhysicalEnvironment physicalEnvironment = null;
    private View view;
    private ViewerAvatar avatar;
    private Canvas3D[] canvases;
    private JFrame[] j3dJFrames;
    private JPanel[] j3dJPanels;
    private Window[] j3dWindows;
    private ViewingPlatform viewingPlatform;

    public Viewer() {
        this(null, null, null, true);
    }

    public Viewer(Canvas3D canvas3D) {
        Canvas3D[] canvas3DArray;
        if (canvas3D == null) {
            canvas3DArray = null;
        } else {
            Canvas3D[] canvas3DArray2 = new Canvas3D[1];
            canvas3DArray = canvas3DArray2;
            canvas3DArray2[0] = canvas3D;
        }
        this(canvas3DArray, null, null, true);
    }

    public Viewer(Canvas3D[] canvas3DArray) {
        this(canvas3DArray, null, null, true);
    }

    public Viewer(Canvas3D[] canvas3DArray, PhysicalBody physicalBody, PhysicalEnvironment physicalEnvironment, boolean bl) {
        this.view = null;
        this.avatar = null;
        this.canvases = null;
        this.j3dJFrames = null;
        this.j3dJPanels = null;
        this.j3dWindows = null;
        this.viewingPlatform = null;
        Viewer.physicalBody = physicalBody == null ? new PhysicalBody() : physicalBody;
        Viewer.physicalEnvironment = physicalEnvironment == null ? new PhysicalEnvironment() : physicalEnvironment;
        if (canvas3DArray == null) {
            GraphicsConfiguration graphicsConfiguration = ConfiguredUniverse.getPreferredConfiguration();
            this.canvases = new Canvas3D[1];
            this.canvases[0] = new Canvas3D(graphicsConfiguration);
            this.canvases[0].setFocusable(true);
            this.createFramesAndPanels(bl);
        } else {
            this.canvases = new Canvas3D[canvas3DArray.length];
            for (int i = 0; i < canvas3DArray.length; ++i) {
                this.canvases[i] = canvas3DArray[i];
                this.canvases[i].setFocusable(true);
            }
        }
        this.view = new View();
        this.view.setUserHeadToVworldEnable(true);
        for (int i = 0; i < this.canvases.length; ++i) {
            this.view.addCanvas3D(this.canvases[i]);
        }
        this.view.setPhysicalBody(Viewer.physicalBody);
        this.view.setPhysicalEnvironment(Viewer.physicalEnvironment);
    }

    public Viewer(URL uRL) {
        this(null, uRL);
    }

    public Viewer(Canvas3D canvas3D, URL uRL) {
        this.view = null;
        this.avatar = null;
        this.canvases = null;
        this.j3dJFrames = null;
        this.j3dJPanels = null;
        this.j3dWindows = null;
        this.viewingPlatform = null;
        if (physicalBody == null) {
            physicalBody = new PhysicalBody();
        }
        if (physicalEnvironment == null) {
            physicalEnvironment = new PhysicalEnvironment();
        }
        if (canvas3D == null) {
            GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
            this.canvases = new Canvas3D[1];
            this.canvases[0] = new Canvas3D(graphicsConfiguration);
            this.createFramesAndPanels(true);
        } else {
            this.canvases = new Canvas3D[1];
            this.canvases[0] = canvas3D;
        }
        this.canvases[0].setFocusable(true);
        this.view = new View();
        this.view.setUserHeadToVworldEnable(true);
        this.view.addCanvas3D(this.canvases[0]);
        this.view.setPhysicalBody(physicalBody);
        this.view.setPhysicalEnvironment(physicalEnvironment);
    }

    Viewer(ConfigScreen[] configScreenArray, ConfigView configView, boolean bl) {
        this.view = null;
        this.avatar = null;
        this.canvases = null;
        this.j3dJFrames = null;
        this.j3dJPanels = null;
        this.j3dWindows = null;
        this.viewingPlatform = null;
        this.view = configView.j3dView;
        physicalBody = configView.physicalBody;
        physicalEnvironment = configView.physicalEnvironment;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        if (graphicsDeviceArray == null) {
            throw new RuntimeException("No screen devices available in local environment");
        }
        this.canvases = new Canvas3D[configScreenArray.length];
        this.j3dJFrames = new JFrame[configScreenArray.length];
        this.j3dJPanels = new JPanel[configScreenArray.length];
        this.j3dWindows = new Window[configScreenArray.length];
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        if (configView.stereoEnable) {
            graphicsConfigTemplate3D.setStereo(2);
        }
        if (configView.antialiasingEnable) {
            graphicsConfigTemplate3D.setSceneAntialiasing(2);
        }
        for (int i = 0; i < configScreenArray.length; ++i) {
            Container container;
            if (configScreenArray[i].frameBufferNumber >= graphicsDeviceArray.length) {
                ConfigScreen cfr_ignored_0 = configScreenArray[i];
                throw new ArrayIndexOutOfBoundsException(ConfigScreen.errorMessage(configScreenArray[i].creatingCommand, "Screen " + configScreenArray[i].frameBufferNumber + " is invalid; " + (graphicsDeviceArray.length - 1) + " is the maximum local index."));
            }
            GraphicsConfiguration graphicsConfiguration = graphicsDeviceArray[configScreenArray[i].frameBufferNumber].getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
            if (graphicsConfiguration == null) {
                throw new RuntimeException("No GraphicsConfiguration on screen " + configScreenArray[i].frameBufferNumber + " conforms to template");
            }
            GraphicsConfiguration graphicsConfiguration2 = graphicsConfiguration.getDevice().getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration2.getBounds();
            configScreenArray[i].j3dJFrame = this.j3dJFrames[i] = new JFrame(configScreenArray[i].instanceName, graphicsConfiguration2);
            if (configScreenArray[i].noBorderFullScreen) {
                this.j3dJFrames[i].setUndecorated(true);
                configScreenArray[i].j3dWindow = this.j3dWindows[i] = this.j3dJFrames[i];
                container = this.j3dJFrames[i].getContentPane();
                container.setLayout(new BorderLayout());
                this.j3dWindows[i].setSize(rectangle.width, rectangle.height);
                this.j3dWindows[i].setLocation(rectangle.x, rectangle.y);
            } else {
                configScreenArray[i].j3dWindow = this.j3dWindows[i] = this.j3dJFrames[i];
                container = this.j3dJFrames[i].getContentPane();
                container.setLayout(new BorderLayout());
                if (configScreenArray[i].fullScreen) {
                    this.j3dWindows[i].setSize(rectangle.width, rectangle.height);
                    this.j3dWindows[i].setLocation(rectangle.x, rectangle.y);
                } else {
                    this.j3dWindows[i].setSize(configScreenArray[i].windowWidthInPixels, configScreenArray[i].windowHeightInPixels);
                    this.j3dWindows[i].setLocation(rectangle.x + configScreenArray[i].windowX, rectangle.y + configScreenArray[i].windowY);
                }
            }
            configScreenArray[i].j3dCanvas = this.canvases[i] = new Canvas3D(graphicsConfiguration);
            this.canvases[i].setStereoEnable(configView.stereoEnable);
            this.canvases[i].setMonoscopicViewPolicy(configScreenArray[i].monoscopicViewPolicy);
            Screen3D screen3D = this.canvases[i].getScreen3D();
            if (configScreenArray[i].physicalScreenWidth != 0.0) {
                screen3D.setPhysicalScreenWidth(configScreenArray[i].physicalScreenWidth);
            }
            if (configScreenArray[i].physicalScreenHeight != 0.0) {
                screen3D.setPhysicalScreenHeight(configScreenArray[i].physicalScreenHeight);
            }
            if (configScreenArray[i].trackerBaseToImagePlate != null) {
                screen3D.setTrackerBaseToImagePlate(new Transform3D(configScreenArray[i].trackerBaseToImagePlate));
            }
            if (configScreenArray[i].headTrackerToLeftImagePlate != null) {
                screen3D.setHeadTrackerToLeftImagePlate(new Transform3D(configScreenArray[i].headTrackerToLeftImagePlate));
            }
            if (configScreenArray[i].headTrackerToRightImagePlate != null) {
                screen3D.setHeadTrackerToRightImagePlate(new Transform3D(configScreenArray[i].headTrackerToRightImagePlate));
            }
            configScreenArray[i].j3dJPanel = this.j3dJPanels[i] = new JPanel();
            this.j3dJPanels[i].setLayout(new BorderLayout());
            this.j3dJPanels[i].add("Center", (Component)this.canvases[i]);
            container.add("Center", this.j3dJPanels[i]);
            this.view.addCanvas3D(this.canvases[i]);
            this.addWindowCloseListener(this.j3dWindows[i]);
            this.canvases[i].setFocusable(true);
        }
        if (bl) {
            this.setVisible(true);
        }
    }

    private void createFramesAndPanels(boolean bl) {
        this.j3dJFrames = new JFrame[this.canvases.length];
        this.j3dJPanels = new JPanel[this.canvases.length];
        this.j3dWindows = new Window[this.canvases.length];
        for (int i = 0; i < this.canvases.length; ++i) {
            this.j3dJFrames[i] = new JFrame();
            this.j3dWindows[i] = this.j3dJFrames[i];
            this.j3dJFrames[i].getContentPane().setLayout(new BorderLayout());
            this.j3dJFrames[i].setSize(256, 256);
            this.j3dJPanels[i] = new JPanel();
            this.j3dJPanels[i].setLayout(new BorderLayout());
            this.j3dJPanels[i].add("Center", (Component)this.canvases[i]);
            this.j3dJFrames[i].getContentPane().add("Center", this.j3dJPanels[i]);
            if (bl) {
                this.j3dJFrames[i].setVisible(true);
            }
            this.addWindowCloseListener(this.j3dJFrames[i]);
        }
    }

    public void setVisible(boolean bl) {
        for (int i = 0; i < this.j3dWindows.length; ++i) {
            this.j3dWindows[i].setVisible(bl);
        }
    }

    public View getView() {
        return this.view;
    }

    public void setViewingPlatform(ViewingPlatform viewingPlatform) {
        if (this.viewingPlatform != null) {
            this.viewingPlatform.removeViewer(this);
        }
        this.viewingPlatform = viewingPlatform;
        if (viewingPlatform != null) {
            this.view.attachViewPlatform(viewingPlatform.getViewPlatform());
            viewingPlatform.addViewer(this);
            if (this.avatar != null) {
                this.viewingPlatform.setAvatar(this, this.avatar);
            }
        } else {
            this.view.attachViewPlatform(null);
        }
    }

    public ViewingPlatform getViewingPlatform() {
        return this.viewingPlatform;
    }

    public void setAvatar(ViewerAvatar viewerAvatar) {
        if (this.avatar == viewerAvatar) {
            return;
        }
        this.avatar = viewerAvatar;
        if (this.viewingPlatform != null) {
            this.viewingPlatform.setAvatar(this, this.avatar);
        }
    }

    public ViewerAvatar getAvatar() {
        return this.avatar;
    }

    public PhysicalBody getPhysicalBody() {
        return physicalBody;
    }

    public PhysicalEnvironment getPhysicalEnvironment() {
        return physicalEnvironment;
    }

    public Canvas3D getCanvas3D() {
        return this.canvases[0];
    }

    public Canvas3D getCanvas3D(int n) {
        if (n > this.canvases.length) {
            return null;
        }
        return this.canvases[n];
    }

    public Canvas3D[] getCanvas3Ds() {
        Canvas3D[] canvas3DArray = new Canvas3D[this.canvases.length];
        for (int i = 0; i < this.canvases.length; ++i) {
            canvas3DArray[i] = this.canvases[i];
        }
        return canvas3DArray;
    }

    public Canvas3D getCanvases() {
        return this.getCanvas3D();
    }

    public Frame getFrame() {
        throw new UnsupportedOperationException("AWT Frame components are not created by the Viewer class");
    }

    public JFrame getJFrame(int n) {
        if (this.j3dJFrames == null || n > this.j3dJFrames.length) {
            return null;
        }
        return this.j3dJFrames[n];
    }

    public JFrame[] getJFrames() {
        if (this.j3dJFrames == null) {
            return null;
        }
        JFrame[] jFrameArray = new JFrame[this.j3dJFrames.length];
        for (int i = 0; i < this.j3dJFrames.length; ++i) {
            jFrameArray[i] = this.j3dJFrames[i];
        }
        return jFrameArray;
    }

    public Panel getPanel() {
        throw new UnsupportedOperationException("AWT Panel components are not created by the Viewer class");
    }

    public JPanel getJPanel(int n) {
        if (this.j3dJPanels == null || n > this.j3dJPanels.length) {
            return null;
        }
        return this.j3dJPanels[n];
    }

    public JPanel[] getJPanels() {
        if (this.j3dJPanels == null) {
            return null;
        }
        JPanel[] jPanelArray = new JPanel[this.j3dJPanels.length];
        for (int i = 0; i < this.j3dJPanels.length; ++i) {
            jPanelArray[i] = this.j3dJPanels[i];
        }
        return jPanelArray;
    }

    public AudioDevice createAudioDevice() {
        if (physicalEnvironment == null) {
            System.err.println("Java 3D: createAudioDevice: physicalEnvironment is null");
            return null;
        }
        try {
            Object object;
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("j3d.audiodevice");
                }
            });
            if (string == null) {
                throw new UnsupportedOperationException("No AudioDevice specified");
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                object = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return ClassLoader.getSystemClassLoader();
                    }
                });
                if (object == null) {
                    throw new IllegalStateException("System ClassLoader is null");
                }
                clazz = Class.forName(string, true, (ClassLoader)object);
            }
            object = PhysicalEnvironment.class;
            Constructor<?> constructor = clazz.getConstructor(new Class[]{object});
            PhysicalEnvironment[] physicalEnvironmentArray = new PhysicalEnvironment[]{physicalEnvironment};
            AudioEngine3DL2 audioEngine3DL2 = (AudioEngine3DL2)constructor.newInstance(physicalEnvironmentArray);
            audioEngine3DL2.initialize();
            return audioEngine3DL2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            physicalEnvironment.setAudioDevice(null);
            System.err.println("Java 3D: audio is disabled");
            return null;
        }
    }

    public SimpleUniverse getUniverse() {
        return this.getViewingPlatform().getUniverse();
    }

    void addWindowCloseListener(Window window) {
        SecurityManager securityManager = System.getSecurityManager();
        boolean bl = true;
        if (securityManager != null) {
            try {
                securityManager.checkExit(0);
            }
            catch (SecurityException securityException) {
                bl = false;
            }
        }
        final boolean bl2 = bl;
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                try {
                    window.dispose();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (bl2) {
                    System.exit(0);
                }
            }
        });
    }
}

