/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.Trees;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import org.jspecify.annotations.Nullable;

public class RemoveUnusedImports {
    private static final Method GET_QUALIFIED_IDENTIFIER_METHOD = RemoveUnusedImports.getQualifiedIdentifierMethod();
    private static final @Nullable Method IS_MODULE_METHOD = RemoveUnusedImports.getIsModuleMethod();

    public static String removeUnusedImports(String contents) throws FormatterException {
        Context context = new Context();
        JCTree.JCCompilationUnit unit = RemoveUnusedImports.parse(context, contents);
        if (unit == null) {
            return contents;
        }
        UnusedImportScanner scanner = new UnusedImportScanner(JavacTrees.instance(context));
        scanner.scan((Tree)unit, null);
        return RemoveUnusedImports.applyReplacements(contents, RemoveUnusedImports.buildReplacements(contents, unit, scanner.usedNames, scanner.usedInJavadoc));
    }

    private static JCTree.JCCompilationUnit parse(Context context, final String javaInput) throws FormatterException {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        context.put(DiagnosticListener.class, diagnostics);
        Options.instance(context).put("--enable-preview", "true");
        Options.instance(context).put("allowStringFolding", "false");
        JavacFileManager fileManager = new JavacFileManager(context, true, StandardCharsets.UTF_8);
        try {
            fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, (Iterable<? extends File>)ImmutableList.of());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SimpleJavaFileObject source = new SimpleJavaFileObject(URI.create("source"), JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return javaInput;
            }
        };
        Log.instance(context).useSource(source);
        ParserFactory parserFactory = ParserFactory.instance(context);
        JavacParser parser = parserFactory.newParser(javaInput, true, true, true);
        JCTree.JCCompilationUnit unit = parser.parseCompilationUnit();
        unit.sourcefile = source;
        Iterable errorDiagnostics = Iterables.filter(diagnostics.getDiagnostics(), Formatter::errorDiagnostic);
        if (!Iterables.isEmpty((Iterable)errorDiagnostics)) {
            throw FormatterException.fromJavacDiagnostics(errorDiagnostics);
        }
        return unit;
    }

    private static RangeMap<Integer, String> buildReplacements(String contents, JCTree.JCCompilationUnit unit, Set<String> usedNames, Multimap<String, Range<Integer>> usedInJavadoc) {
        TreeRangeMap replacements = TreeRangeMap.create();
        for (JCTree importTree : unit.getImports()) {
            String sep;
            String simpleName;
            if (RemoveUnusedImports.isModuleImport(importTree) || !RemoveUnusedImports.isUnused(unit, usedNames, usedInJavadoc, importTree, simpleName = RemoveUnusedImports.getSimpleName(importTree))) continue;
            int endPosition = Trees.getEndPosition((Tree)importTree, unit);
            endPosition = Math.max(CharMatcher.isNot((char)' ').indexIn((CharSequence)contents, endPosition), endPosition);
            if (endPosition + (sep = Newlines.guessLineSeparator(contents)).length() < contents.length() && contents.subSequence(endPosition, endPosition + sep.length()).toString().equals(sep)) {
                endPosition += sep.length();
            }
            replacements.put(Range.closedOpen((Comparable)Integer.valueOf(importTree.getStartPosition()), (Comparable)Integer.valueOf(endPosition)), (Object)"");
        }
        return replacements;
    }

    private static String getSimpleName(JCTree importTree) {
        return RemoveUnusedImports.getQualifiedIdentifier(importTree).getIdentifier().toString();
    }

    private static boolean isUnused(JCTree.JCCompilationUnit unit, Set<String> usedNames, Multimap<String, Range<Integer>> usedInJavadoc, JCTree importTree, String simpleName) {
        JCTree.JCFieldAccess qualifiedIdentifier = RemoveUnusedImports.getQualifiedIdentifier(importTree);
        String qualifier = qualifiedIdentifier.getExpression().toString();
        if (qualifier.equals("java.lang")) {
            return true;
        }
        if (unit.getPackageName() != null && unit.getPackageName().toString().equals(qualifier)) {
            return true;
        }
        if (qualifiedIdentifier.getIdentifier().contentEquals("*")) {
            return false;
        }
        if (usedNames.contains(simpleName)) {
            return false;
        }
        return !usedInJavadoc.containsKey((Object)simpleName);
    }

    private static @Nullable Method getQualifiedIdentifierMethod() {
        try {
            return JCTree.JCImport.class.getMethod("getQualifiedIdentifier", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static JCTree.JCFieldAccess getQualifiedIdentifier(JCTree importTree) {
        Preconditions.checkArgument((!RemoveUnusedImports.isModuleImport(importTree) ? 1 : 0) != 0);
        try {
            return (JCTree.JCFieldAccess)GET_QUALIFIED_IDENTIFIER_METHOD.invoke((Object)importTree, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static @Nullable Method getIsModuleMethod() {
        try {
            return ImportTree.class.getMethod("isModule", new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }

    private static boolean isModuleImport(JCTree importTree) {
        if (IS_MODULE_METHOD == null) {
            return false;
        }
        try {
            return (Boolean)IS_MODULE_METHOD.invoke((Object)importTree, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static String applyReplacements(String source, RangeMap<Integer, String> replacements) {
        TreeRangeSet fixedRanges = TreeRangeSet.create();
        StringBuilder sb = new StringBuilder(source);
        int offset = 0;
        for (Map.Entry replacement : replacements.asMapOfRanges().entrySet()) {
            Range range = (Range)replacement.getKey();
            String replaceWith = (String)replacement.getValue();
            int start = offset + (Integer)range.lowerEndpoint();
            int end = offset + (Integer)range.upperEndpoint();
            sb.replace(start, end, replaceWith);
            if (!replaceWith.isEmpty()) {
                fixedRanges.add(Range.closedOpen((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)));
            }
            offset += replaceWith.length() - ((Integer)range.upperEndpoint() - (Integer)range.lowerEndpoint());
        }
        return sb.toString();
    }

    private static class UnusedImportScanner
    extends TreePathScanner<Void, Void> {
        private final Set<String> usedNames = new LinkedHashSet<String>();
        private final Multimap<String, Range<Integer>> usedInJavadoc = HashMultimap.create();
        final JavacTrees trees;
        final DocTreeScanner docTreeSymbolScanner;
        private static final Method CASE_TREE_GET_LABELS = UnusedImportScanner.caseTreeGetLabels();

        private UnusedImportScanner(JavacTrees trees) {
            this.trees = trees;
            this.docTreeSymbolScanner = new DocTreeScanner();
        }

        @Override
        public Void visitImport(ImportTree importTree, Void usedSymbols) {
            return null;
        }

        @Override
        public Void visitIdentifier(com.sun.source.tree.IdentifierTree tree, Void unused) {
            if (tree == null) {
                return null;
            }
            this.usedNames.add(tree.getName().toString());
            return null;
        }

        @Override
        public Void visitCase(CaseTree tree, Void unused) {
            if (CASE_TREE_GET_LABELS != null) {
                try {
                    this.scan((List)CASE_TREE_GET_LABELS.invoke((Object)tree, new Object[0]), null);
                }
                catch (ReflectiveOperationException e) {
                    throw new LinkageError(e.getMessage(), e);
                }
            }
            return (Void)super.visitCase(tree, null);
        }

        private static Method caseTreeGetLabels() {
            try {
                return CaseTree.class.getMethod("getLabels", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        @Override
        public Void scan(Tree tree, Void unused) {
            if (tree == null) {
                return null;
            }
            this.scanJavadoc();
            return (Void)super.scan(tree, unused);
        }

        private void scanJavadoc() {
            if (this.getCurrentPath() == null) {
                return;
            }
            DocCommentTree commentTree = this.trees.getDocCommentTree(this.getCurrentPath());
            if (commentTree == null) {
                return;
            }
            this.docTreeSymbolScanner.scan(new DocTreePath(this.getCurrentPath(), commentTree), null);
        }

        class DocTreeScanner
        extends DocTreePathScanner<Void, Void> {
            DocTreeScanner() {
            }

            @Override
            public Void visitIdentifier(IdentifierTree node, Void aVoid) {
                return null;
            }

            @Override
            public Void visitReference(ReferenceTree referenceTree, Void unused) {
                DCTree.DCReference reference = (DCTree.DCReference)referenceTree;
                long basePos = reference.pos((DCTree.DCDocComment)this.getCurrentPath().getDocComment()).getStartPosition();
                if (reference.qualifierExpression != null) {
                    new ReferenceScanner(basePos).scan(reference.qualifierExpression, null);
                }
                if (reference.paramTypes != null) {
                    for (JCTree param : reference.paramTypes) {
                        new ReferenceScanner(-1L).scan(param, null);
                    }
                }
                return null;
            }

            private class ReferenceScanner
            extends TreeScanner<Void, Void> {
                private final long basePos;

                public ReferenceScanner(long basePos) {
                    this.basePos = basePos;
                }

                @Override
                public Void visitIdentifier(com.sun.source.tree.IdentifierTree node, Void aVoid) {
                    UnusedImportScanner.this.usedInJavadoc.put((Object)node.getName().toString(), this.basePos != -1L ? Range.closedOpen((Comparable)Integer.valueOf((int)this.basePos), (Comparable)Integer.valueOf((int)this.basePos + node.getName().length())) : null);
                    return (Void)super.visitIdentifier(node, aVoid);
                }
            }
        }
    }
}

