/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.OneTimeUse;
import org.opensaml.saml.saml2.core.ProxyRestriction;

public class ConditionsImpl
extends AbstractXMLObject
implements Conditions {
    @Nonnull
    private final IndexedXMLObjectChildrenList<Condition> conditions = new IndexedXMLObjectChildrenList(this);
    @Nullable
    private Instant notBefore;
    @Nullable
    private Instant notOnOrAfter;

    protected ConditionsImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    @Nonnull
    @Live
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    @Nonnull
    @Live
    public List<Condition> getConditions(@Nonnull QName typeOrName) {
        return this.conditions.subList(typeOrName);
    }

    @Override
    @Nonnull
    @Live
    public List<AudienceRestriction> getAudienceRestrictions() {
        QName conditionQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AudienceRestriction", "saml2");
        return this.conditions.subList(conditionQName);
    }

    @Override
    @Nullable
    public OneTimeUse getOneTimeUse() {
        QName conditionQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "OneTimeUse", "saml2");
        List<Condition> list = this.conditions.subList(conditionQName);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (OneTimeUse)list.get(0);
    }

    @Override
    @Nullable
    public ProxyRestriction getProxyRestriction() {
        QName conditionQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "ProxyRestriction", "saml2");
        List<Condition> list = this.conditions.subList(conditionQName);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (ProxyRestriction)list.get(0);
    }

    @Override
    @Nullable
    public Instant getNotBefore() {
        return this.notBefore;
    }

    @Override
    public void setNotBefore(@Nullable Instant newNotBefore) {
        this.notBefore = this.prepareForAssignment(this.notBefore, newNotBefore);
    }

    @Override
    @Nullable
    public Instant getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    @Override
    public void setNotOnOrAfter(@Nullable Instant newNotOnOrAfter) {
        this.notOnOrAfter = this.prepareForAssignment(this.notOnOrAfter, newNotOnOrAfter);
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        return CollectionSupport.copyToList(this.conditions);
    }
}

