/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.configuration.ConfigurationRepository;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RestApiPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.node.NodeClient;

public class PermissionsInfoAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix(Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/permissionsinfo")));
    private static final List<RestHandler.DeprecatedRoute> deprecatedRoutes = Utils.addLegacyRoutesPrefix((List<RestHandler.DeprecatedRoute>)ImmutableList.of((Object)new RestHandler.DeprecatedRoute(RestRequest.Method.GET, "/permissionsinfo", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead.")));
    private final RestApiPrivilegesEvaluator restApiPrivilegesEvaluator;
    private final ThreadPool threadPool;
    private final PrivilegesEvaluator privilegesEvaluator;
    private final ConfigurationRepository configurationRepository;

    protected PermissionsInfoAction(Settings settings, Path configPath, RestController controller, Client client, AdminDNs adminDNs, ConfigurationRepository configurationRepository, ClusterService cs, PrincipalExtractor principalExtractor, PrivilegesEvaluator privilegesEvaluator, ThreadPool threadPool, AuditLog auditLog) {
        this.threadPool = threadPool;
        this.privilegesEvaluator = privilegesEvaluator;
        this.restApiPrivilegesEvaluator = new RestApiPrivilegesEvaluator(settings, adminDNs, privilegesEvaluator, principalExtractor, configPath, threadPool);
        this.configurationRepository = configurationRepository;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return deprecatedRoutes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        switch (request.method()) {
            case GET: {
                return this.handleGet(request, client);
            }
        }
        throw new IllegalArgumentException(String.valueOf(request.method()) + " not supported");
    }

    private BaseRestHandler.RestChannelConsumer handleGet(RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    User user = (User)PermissionsInfoAction.this.threadPool.getThreadContext().getTransient("_opendistro_security_user");
                    TransportAddress remoteAddress = (TransportAddress)PermissionsInfoAction.this.threadPool.getThreadContext().getTransient("_opendistro_security_remote_address");
                    Set<String> userRoles = PermissionsInfoAction.this.privilegesEvaluator.mapRoles(user, remoteAddress);
                    Boolean hasApiAccess = PermissionsInfoAction.this.restApiPrivilegesEvaluator.currentUserHasRestApiAccess(userRoles);
                    Map<Endpoint, List<RestRequest.Method>> disabledEndpoints = PermissionsInfoAction.this.restApiPrivilegesEvaluator.getDisabledEndpointsForCurrentUser(user.getName(), userRoles);
                    if (!PermissionsInfoAction.this.configurationRepository.isAuditHotReloadingEnabled()) {
                        disabledEndpoints.put(Endpoint.AUDIT, (List<RestRequest.Method>)ImmutableList.copyOf((Object[])RestRequest.Method.values()));
                    }
                    builder.startObject();
                    builder.field("user", user == null ? null : user.toString());
                    builder.field("user_name", user == null ? null : user.getName());
                    builder.field("has_api_access", hasApiAccess);
                    builder.startObject("disabled_endpoints");
                    for (Map.Entry<Endpoint, List<RestRequest.Method>> entry : disabledEndpoints.entrySet()) {
                        builder.field(entry.getKey().name(), (Iterable)entry.getValue());
                    }
                    builder.endObject();
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }
}

