/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.string;

import java.util.Locale;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;

@SdkInternalApi
@ThreadSafe
@Immutable
public class LocaleStringConverter
implements StringConverter<Locale> {
    private LocaleStringConverter() {
    }

    public static LocaleStringConverter create() {
        return new LocaleStringConverter();
    }

    @Override
    public EnhancedType<Locale> type() {
        return EnhancedType.of(Locale.class);
    }

    @Override
    public Locale fromString(String string) {
        return Locale.forLanguageTag(string);
    }

    @Override
    public String toString(Locale locale) {
        return locale.toLanguageTag();
    }
}

