/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardSearchBackpressureTaskCancellationStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardSearchBackpressureTaskCancellationStats> {
    @Nullable
    private final Long cancellationCount;
    @Nullable
    private final Long cancellationLimitReachedCount;
    @Nullable
    private final Double cancelledTaskPercentage;
    @Nullable
    private final Long currentCancellationEligibleTasksCount;
    public static final JsonpDeserializer<ShardSearchBackpressureTaskCancellationStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardSearchBackpressureTaskCancellationStats::setupShardSearchBackpressureTaskCancellationStatsDeserializer);

    private ShardSearchBackpressureTaskCancellationStats(Builder builder) {
        this.cancellationCount = builder.cancellationCount;
        this.cancellationLimitReachedCount = builder.cancellationLimitReachedCount;
        this.cancelledTaskPercentage = builder.cancelledTaskPercentage;
        this.currentCancellationEligibleTasksCount = builder.currentCancellationEligibleTasksCount;
    }

    public static ShardSearchBackpressureTaskCancellationStats of(Function<Builder, ObjectBuilder<ShardSearchBackpressureTaskCancellationStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long cancellationCount() {
        return this.cancellationCount;
    }

    @Nullable
    public final Long cancellationLimitReachedCount() {
        return this.cancellationLimitReachedCount;
    }

    @Nullable
    public final Double cancelledTaskPercentage() {
        return this.cancelledTaskPercentage;
    }

    @Nullable
    public final Long currentCancellationEligibleTasksCount() {
        return this.currentCancellationEligibleTasksCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.cancellationCount != null) {
            generator.writeKey("cancellation_count");
            generator.write(this.cancellationCount.longValue());
        }
        if (this.cancellationLimitReachedCount != null) {
            generator.writeKey("cancellation_limit_reached_count");
            generator.write(this.cancellationLimitReachedCount.longValue());
        }
        if (this.cancelledTaskPercentage != null) {
            generator.writeKey("cancelled_task_percentage");
            generator.write(this.cancelledTaskPercentage.doubleValue());
        }
        if (this.currentCancellationEligibleTasksCount != null) {
            generator.writeKey("current_cancellation_eligible_tasks_count");
            generator.write(this.currentCancellationEligibleTasksCount.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardSearchBackpressureTaskCancellationStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cancellationCount, JsonpDeserializer.longDeserializer(), "cancellation_count");
        op.add(Builder::cancellationLimitReachedCount, JsonpDeserializer.longDeserializer(), "cancellation_limit_reached_count");
        op.add(Builder::cancelledTaskPercentage, JsonpDeserializer.doubleDeserializer(), "cancelled_task_percentage");
        op.add(Builder::currentCancellationEligibleTasksCount, JsonpDeserializer.longDeserializer(), "current_cancellation_eligible_tasks_count");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.cancellationCount);
        result = 31 * result + Objects.hashCode(this.cancellationLimitReachedCount);
        result = 31 * result + Objects.hashCode(this.cancelledTaskPercentage);
        result = 31 * result + Objects.hashCode(this.currentCancellationEligibleTasksCount);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardSearchBackpressureTaskCancellationStats other = (ShardSearchBackpressureTaskCancellationStats)o;
        return Objects.equals(this.cancellationCount, other.cancellationCount) && Objects.equals(this.cancellationLimitReachedCount, other.cancellationLimitReachedCount) && Objects.equals(this.cancelledTaskPercentage, other.cancelledTaskPercentage) && Objects.equals(this.currentCancellationEligibleTasksCount, other.currentCancellationEligibleTasksCount);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardSearchBackpressureTaskCancellationStats> {
        @Nullable
        private Long cancellationCount;
        @Nullable
        private Long cancellationLimitReachedCount;
        @Nullable
        private Double cancelledTaskPercentage;
        @Nullable
        private Long currentCancellationEligibleTasksCount;

        public Builder() {
        }

        private Builder(ShardSearchBackpressureTaskCancellationStats o) {
            this.cancellationCount = o.cancellationCount;
            this.cancellationLimitReachedCount = o.cancellationLimitReachedCount;
            this.cancelledTaskPercentage = o.cancelledTaskPercentage;
            this.currentCancellationEligibleTasksCount = o.currentCancellationEligibleTasksCount;
        }

        private Builder(Builder o) {
            this.cancellationCount = o.cancellationCount;
            this.cancellationLimitReachedCount = o.cancellationLimitReachedCount;
            this.cancelledTaskPercentage = o.cancelledTaskPercentage;
            this.currentCancellationEligibleTasksCount = o.currentCancellationEligibleTasksCount;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder cancellationCount(@Nullable Long value) {
            this.cancellationCount = value;
            return this;
        }

        @Nonnull
        public final Builder cancellationLimitReachedCount(@Nullable Long value) {
            this.cancellationLimitReachedCount = value;
            return this;
        }

        @Nonnull
        public final Builder cancelledTaskPercentage(@Nullable Double value) {
            this.cancelledTaskPercentage = value;
            return this;
        }

        @Nonnull
        public final Builder currentCancellationEligibleTasksCount(@Nullable Long value) {
            this.currentCancellationEligibleTasksCount = value;
            return this;
        }

        @Override
        @Nonnull
        public ShardSearchBackpressureTaskCancellationStats build() {
            this._checkSingleUse();
            return new ShardSearchBackpressureTaskCancellationStats(this);
        }
    }
}

