/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.text.impl;

import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tribuo.Feature;
import org.tribuo.data.text.FeatureAggregator;

public class SumAggregator
implements FeatureAggregator {
    private final ThreadLocal<Map<String, Double>> map = ThreadLocal.withInitial(HashMap::new);

    @Override
    public List<Feature> aggregate(List<Feature> input) {
        Map<String, Double> curMap = this.map.get();
        curMap.clear();
        for (Feature f : input) {
            double curValue = f.getValue();
            curMap.merge(f.getName(), curValue, Double::sum);
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Map.Entry<String, Double> e : curMap.entrySet()) {
            features.add(new Feature(e.getKey(), e.getValue().doubleValue()));
        }
        return features;
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "FeatureAggregator");
    }
}

