/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.contextmanagement;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.action.contextmanagement.ContextManagementTemplateService;
import org.opensearch.ml.common.transport.contextmanagement.MLDeleteContextManagementTemplateRequest;
import org.opensearch.ml.common.transport.contextmanagement.MLDeleteContextManagementTemplateResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class DeleteContextManagementTemplateTransportAction
extends HandledTransportAction<MLDeleteContextManagementTemplateRequest, MLDeleteContextManagementTemplateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteContextManagementTemplateTransportAction.class);
    private final Client client;
    private final ContextManagementTemplateService contextManagementTemplateService;

    @Inject
    public DeleteContextManagementTemplateTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ContextManagementTemplateService contextManagementTemplateService) {
        super("cluster:admin/opensearch/ml/context_management/delete", transportService, actionFilters, MLDeleteContextManagementTemplateRequest::new);
        this.client = client;
        this.contextManagementTemplateService = contextManagementTemplateService;
    }

    protected void doExecute(Task task, MLDeleteContextManagementTemplateRequest request, ActionListener<MLDeleteContextManagementTemplateResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            log.info("Deleting context management template: {}", (Object)request.getTemplateName());
            this.contextManagementTemplateService.deleteTemplate(request.getTemplateName(), (ActionListener<Boolean>)ActionListener.wrap(success -> {
                if (success.booleanValue()) {
                    log.info("Successfully deleted context management template: {}", (Object)request.getTemplateName());
                    listener.onResponse((Object)new MLDeleteContextManagementTemplateResponse(request.getTemplateName(), "deleted"));
                } else {
                    log.warn("Context management template not found for deletion: {}", (Object)request.getTemplateName());
                    listener.onFailure((Exception)new RuntimeException("Context management template not found: " + request.getTemplateName()));
                }
            }, exception -> {
                log.error("Error deleting context management template: {}", (Object)request.getTemplateName(), exception);
                listener.onFailure(exception);
            }));
        }
        catch (Exception e) {
            log.error("Unexpected error deleting context management template: {}", (Object)request.getTemplateName(), (Object)e);
            listener.onFailure(e);
        }
    }
}

