/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.fi;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fi extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Keski-Afrikan aika",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskovan normaaliaika",
               "MST",
               "Moskovan kes\u00e4aika",
               "MST",
               "Moskovan aika",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japanin normaaliaika",
               "JST",
               "Japanin kes\u00e4aika",
               "JDT",
               "Japanin aika",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Pakistanin normaaliaika",
               "PST",
               "Pakistanin kes\u00e4aika",
               "PST",
               "Pakistanin aika",
               "PT",
            };
        final String[] Hovd = new String[] {
               "Hovdin normaaliaika",
               "HST",
               "Hovdin kes\u00e4aika",
               "HST",
               "Hovdin aika",
               "HT",
            };
        final String[] Magadan = new String[] {
               "Magadanin normaaliaika",
               "MST",
               "Magadan kes\u00e4aika",
               "MST",
               "Magadan aika",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "L\u00e4ntisen Keski-Australian normaaliaika",
               "ACWST",
               "L\u00e4ntisen Keski-Australian kes\u00e4aika",
               "ACWDT",
               "L\u00e4ntisen Keski-Australian aika",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Keski-Euroopan normaaliaika",
               "CEST",
               "Keski-Euroopan kes\u00e4aika",
               "CEST",
               "Keski-Euroopan aika",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalinin normaaliaika",
               "SST",
               "Sakhalinin kes\u00e4aika",
               "SST",
               "Sakhalinin aika",
               "ST",
            };
        final String[] Paraguay = new String[] {
               "Paraguayn normaaliaika",
               "PST",
               "Paraguayn kes\u00e4aika",
               "PST",
               "Paraguayn aika",
               "PT",
            };
        final String[] America_Eastern = new String[] {
               "Yhdysvaltain it\u00e4inen normaaliaika",
               "EST",
               "Yhdysvaltain it\u00e4inen kes\u00e4aika",
               "EDT",
               "Yhdysvaltain it\u00e4inen aika",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howen normaaliaika",
               "LHST",
               "Lord Howen kes\u00e4aika",
               "LHDT",
               "Lord Howen aika",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Uuden-Seelannin normaaliaika",
               "NZST",
               "Uuden-Seelannin kes\u00e4aika",
               "NZDT",
               "Uuden-Seelannin aika",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Intian valtameren aika",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Jakutskin normaaliaika",
               "YST",
               "Jakutskin kes\u00e4aika",
               "YST",
               "Jakutskin aika",
               "YT",
            };
        final String[] Mauritius = new String[] {
               "Mauritiuksen aika",
               "MST",
               "Mauritius Summer Time",
               "MST",
               "Mauritius Time",
               "MT",
            };
        final String[] Africa_Eastern = new String[] {
               "It\u00e4-Afrikan aika",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Europe_Eastern = new String[] {
               "It\u00e4-Euroopan normaaliaika",
               "EEST",
               "It\u00e4-Euroopan kes\u00e4aika",
               "EEST",
               "It\u00e4-Euroopan aika",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundlandin normaaliaika",
               "NST",
               "Newfoundlandin kes\u00e4aika",
               "NDT",
               "Newfoundlandin aika",
               "NT",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongin normaaliaika",
               "HKST",
               "Hongkongin kes\u00e4aika",
               "HKST",
               "Hongkongin aika",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "L\u00e4nsi-Argentiinan normaaliaika",
               "WAST",
               "L\u00e4nsi-Argentiinan kes\u00e4aika",
               "WAST",
               "L\u00e4nsi-Argentiinan aika",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "Kanadan Atlantin normaaliaika",
               "AST",
               "Kanadan Atlantin kes\u00e4aika",
               "ADT",
               "Kanadan Atlantin aika",
               "AT",
            };
        final String[] Bolivia = new String[] {
               "Bolivian aika",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Pierren ja Miquelonin normaaliaika",
               "PMST",
               "Pierren ja Miquelonin kes\u00e4aika",
               "PMDT",
               "Pierren ja Miquelonin aika",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Indokiinan aika",
               "IT",
               "Indochina Summer Time",
               "IST",
               "Indochina Time",
               "IT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgin normaaliaika",
               "YST",
               "Jekaterinburgin kes\u00e4aika",
               "YST",
               "Jekaterinburgin aika",
               "YT",
            };
        final String[] Maldives = new String[] {
               "Malediivien aika",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Israel = new String[] {
               "Israelin normaaliaika",
               "IST",
               "Israelin kes\u00e4aika",
               "IDT",
               "Israelin aika",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Keski-Indonesian aika",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Africa_Southern = new String[] {
               "Etel\u00e4-Afrikan normaaliaika",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Syowan aika",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistanin normaaliaika",
               "UST",
               "Uzbekistanin kes\u00e4aika",
               "UST",
               "Uzbekistanin aika",
               "UT",
            };
        final String[] Omsk = new String[] {
               "Omskin normaaliaika",
               "OST",
               "Omskin kes\u00e4aika",
               "OST",
               "Omskin aika",
               "OT",
            };
        final String[] Uruguay = new String[] {
               "Uruguayn normaaliaika",
               "UST",
               "Uruguayn kes\u00e4aika",
               "UST",
               "Uruguayn aika",
               "UT",
            };
        final String[] Nepal = new String[] {
               "Nepalin aika",
               "NT",
               "Nepal Summer Time",
               "NST",
               "Nepal Time",
               "NT",
            };
        final String[] Mongolia = new String[] {
               "Ulan Batorin normaaliaika",
               "UBST",
               "Ulan Batorin kes\u00e4aika",
               "UBST",
               "Ulan Batorin aika",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "Yhdysvaltain keskinen normaaliaika",
               "CST",
               "Yhdysvaltain keskinen kes\u00e4aika",
               "CDT",
               "Yhdysvaltain keskinen aika",
               "CT",
            };
        final String[] Falkland = new String[] {
               "Falklandinsaarten normaaliaika",
               "FIST",
               "Falklandinsaarten kes\u00e4aika",
               "FIST",
               "Falklandinsaarten aika",
               "FIT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirskin normaaliaika",
               "NST",
               "Novosibirskin kes\u00e4aika",
               "NST",
               "Novosibirskin aika",
               "NT",
            };
        final String[] Azores = new String[] {
               "Azorien normaaliaika",
               "AST",
               "Azorien kes\u00e4aika",
               "AST",
               "Azorien aika",
               "AT",
            };
        final String[] Bhutan = new String[] {
               "Bhutanin aika",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Suriname = new String[] {
               "Surinamin aika",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarskin normaaliaika",
               "KST",
               "Krasnojarskin kes\u00e4aika",
               "KST",
               "Krasnojarskin aika",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "L\u00e4nsi-Kazakstanin aika",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Myanmar = new String[] {
               "Myanmarin aika",
               "MT",
               "Myanmar Summer Time",
               "MST",
               "Myanmar Time",
               "MT",
            };
        final String[] Christmas = new String[] {
               "Joulusaaren aika",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Amazonin normaaliaika",
               "AST",
               "Amazonin kes\u00e4aika",
               "AST",
               "Amazonin aika",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "It\u00e4-Kazakstanin aika",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Cocos = new String[] {
               "Kookossaarten aika",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Vostok = new String[] {
               "Vostokin aika",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Argentina = new String[] {
               "Argentiinan normaaliaika",
               "AST",
               "Argentiinan kes\u00e4aika",
               "AST",
               "Argentiinan aika",
               "AT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie Island Time",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarien aika",
               "MIT",
            };
        final String[] Venezuela = new String[] {
               "Venezuelan aika",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havaijin-Aleuttien normaaliaika",
               "HAST",
               "Havaijin-Aleuttien kes\u00e4aika",
               "HADT",
               "Havaijin-Aleuttien aika",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Keski-Australian normaaliaika",
               "ACST",
               "Keski-Australian kes\u00e4aika",
               "ACDT",
               "Keski-Australian aika",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "Yhdysvaltain Tyynenmeren normaaliaika",
               "PST",
               "Yhdysvaltain Tyynenmeren kes\u00e4aika",
               "PDT",
               "Yhdysvaltain Tyynenmeren aika",
               "PT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistanin normaaliaika",
               "TST",
               "Turkmenistanin kes\u00e4aika",
               "TST",
               "Turkmenistanin aika",
               "TT",
            };
        final String[] Europe_Western = new String[] {
               "L\u00e4nsi-Euroopan normaaliaika",
               "WEST",
               "L\u00e4nsi-Euroopan kes\u00e4aika",
               "WEST",
               "L\u00e4nsi-Euroopan aika",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Kap Verden normaaliaika",
               "CVST",
               "Kap Verden kes\u00e4aika",
               "CVST",
               "Kap Verden aika",
               "CVT",
            };
        final String[] Guyana = new String[] {
               "Guyanan aika",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Rothera = new String[] {
               "Rotheran aika",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaid\u017eanin normaaliaika",
               "AST",
               "Azerbaid\u017eanin kes\u00e4aika",
               "AST",
               "Azerbaid\u017eanin aika",
               "AT",
            };
        final String[] Mawson = new String[] {
               "Mawsonin aika",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Davis = new String[] {
               "Davisin aika",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "Kuuban normaaliaika",
               "CST",
               "Kuuban kes\u00e4aika",
               "CDT",
               "Kuuban aika",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "L\u00e4nsi-Afrikan normaaliaika",
               "WAST",
               "L\u00e4nsi-Afrikan kes\u00e4aika",
               "WAST",
               "L\u00e4nsi-Afrikan aika",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Greenwichin normaaliaika",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Philippines = new String[] {
               "Filippiinien normaaliaika",
               "PST",
               "Filippiinien kes\u00e4aika",
               "PST",
               "Filippiinien aika",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Ranskan etel\u00e4isten ja antarktisten alueiden aika",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] South_Georgia = new String[] {
               "Etel\u00e4-Georgian aika",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] Volgograd = new String[] {
               "Volgogradin normaaliaika",
               "VST",
               "Volgogradin kes\u00e4aika",
               "VST",
               "Volgogradin aika",
               "VT",
            };
        final String[] Brunei = new String[] {
               "Brunein aika",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d'Urvillen aika",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017eikistanin aika",
               "TT",
               "Tajikistan Summer Time",
               "TST",
               "Tajikistan Time",
               "TT",
            };
        final String[] Bangladesh = new String[] {
               "Bangladeshin aika",
               "BST",
               "Bangladesh Summer Time",
               "BST",
               "Bangladesh Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "Perun normaaliaika",
               "PST",
               "Perun kes\u00e4aika",
               "PST",
               "Perun aika",
               "PT",
            };
        final String[] Greenland_Western = new String[] {
               "L\u00e4nsi-Gr\u00f6nlannin normaaliaika",
               "WGST",
               "L\u00e4nsi-Gr\u00f6nlannin kes\u00e4aika",
               "WGST",
               "L\u00e4nsi-Gr\u00f6nlannin aika",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ecuadorin aika",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Greenland_Eastern = new String[] {
               "It\u00e4-Gr\u00f6nlannin normaaliaika",
               "EGST",
               "It\u00e4-Gr\u00f6nlannin kes\u00e4aika",
               "EGST",
               "It\u00e4-Gr\u00f6nlannin aika",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Arabiemiirikuntien normaaliaika",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "It\u00e4-Indonesian aika",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "Korean normaaliaika",
               "KST",
               "Korean kes\u00e4aika",
               "KDT",
               "Korean aika",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "L\u00e4nsi-Australian normaaliaika",
               "AWST",
               "L\u00e4nsi-Australian kes\u00e4aika",
               "AWDT",
               "L\u00e4nsi-Australian aika",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "L\u00e4nsi-Indonesian aika",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "It\u00e4-Australian normaaliaika",
               "AEST",
               "It\u00e4-Australian kes\u00e4aika",
               "AEDT",
               "It\u00e4-Australian aika",
               "EAT",
            };
        final String[] French_Guiana = new String[] {
               "Ranskan Guianan aika",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Colombia = new String[] {
               "Kolumbian normaaliaika",
               "CST",
               "Kolumbian kes\u00e4aika",
               "CST",
               "Kolumbian aika",
               "CT",
            };
        final String[] Chile = new String[] {
               "Chilen normaaliaika",
               "CST",
               "Chilen kes\u00e4aika",
               "CST",
               "Chilen aika",
               "CT",
            };
        final String[] America_Mountain = new String[] {
               "Kalliovuorten normaaliaika",
               "MST",
               "Kalliovuorten kes\u00e4aika",
               "MDT",
               "Kalliovuorten aika",
               "MT",
            };
        final String[] Arabian = new String[] {
               "Saudi-Arabian normaaliaika",
               "AST",
               "Saudi-Arabian kes\u00e4aika",
               "ADT",
               "Saudi-Arabian aika",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alaskan normaaliaika",
               "AKST",
               "Alaskan kes\u00e4aika",
               "AKDT",
               "Alaskan aika",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostokin normaaliaika",
               "VST",
               "Vladivostokin kes\u00e4aika",
               "VST",
               "Vladivostokin aika",
               "VT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutskin normaaliaika",
               "IST",
               "Irkutskin kes\u00e4aika",
               "IST",
               "Irkutskin aika",
               "IT",
            };
        final String[] Georgia = new String[] {
               "Georgian normaaliaika",
               "GST",
               "Georgian kes\u00e4aika",
               "GST",
               "Georgian aika",
               "GT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronhan normaaliaika",
               "FNST",
               "Fernando de Noronhan kes\u00e4aika",
               "FNST",
               "Fernando de Noronhan aika",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "T\u0161oibalsan normaaliaika",
               "CST",
               "T\u0161oibalsan kes\u00e4aika",
               "CST",
               "T\u0161oibalsan aika",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "Brasilian normaaliaika",
               "BST",
               "Brasilian kes\u00e4aika",
               "BST",
               "Brasilian aika",
               "BT",
            };
        final String[] China = new String[] {
               "Kiinan normaaliaika",
               "CST",
               "Kiinan kes\u00e4aika",
               "CDT",
               "Kiinan aika",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Armenian normaaliaika",
               "AST",
               "Armenian kes\u00e4aika",
               "AST",
               "Armenian aika",
               "AT",
            };
        final String[] India = new String[] {
               "Intian normaaliaika",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Antarctica/Syowa", Syowa },
            { "Europe/Kaliningrad", GMT },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Africa/Bamako", GMT },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Atlantic/Stanley", Falkland },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Resolute", America_Central },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Indian/Cocos", Cocos },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
