/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.InsensitiveScrollableResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;

class ForwardOnlyResultSet
extends InsensitiveScrollableResultSet {
    ForwardOnlyResultSet(PhysicalConnection conn, OracleStatement stmt) throws SQLException {
        super(conn, stmt);
    }

    @Override
    protected boolean isForwardOnly() {
        return true;
    }

    @Override
    public int getType() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen("getType");
            int n = 1003;
            return n;
        }
    }

    @Override
    boolean isComplete() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            boolean bl = this.closed || this.isEmptyResultSet() || this.currentRow == this.fetchedRowCount;
            return bl;
        }
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.doClose();
        }
    }

    @Override
    protected void doClose() throws SQLException {
        if (this.closed) {
            return;
        }
        this.connection.assertLockHeldByCurrentThread();
        this.statement.cleanAllRowLobs();
        super.doClose();
    }
}

