/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.reference;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.reference.DereferencerContext;
import io.swagger.v3.parser.reference.ReferenceUtils;
import io.swagger.v3.parser.reference.Traverser;
import io.swagger.v3.parser.reference.Visitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;

public class IdsTraverser
implements Traverser {
    private DereferencerContext context;
    public Set<Object> visiting = new HashSet<Object>();
    protected HashMap<Object, Object> visitedMap = new HashMap();

    public IdsTraverser(DereferencerContext context) {
        this.context = context;
    }

    public DereferencerContext getContext() {
        return this.context;
    }

    public void setContext(DereferencerContext context) {
        this.context = context;
    }

    public IdsTraverser context(DereferencerContext context) {
        this.context = context;
        return this;
    }

    @Override
    public OpenAPI traverse(OpenAPI openAPI, Visitor visitor) throws Exception {
        return this.traverseOpenApi(openAPI, visitor);
    }

    public OpenAPI traverseOpenApi(OpenAPI openAPI, Visitor visitor) {
        Components components;
        if (openAPI == null) {
            return null;
        }
        if (this.visiting.contains(openAPI)) {
            return openAPI;
        }
        if (this.visitedMap.containsKey(openAPI)) {
            return (OpenAPI)this.visitedMap.get(openAPI);
        }
        this.visiting.add(openAPI);
        OpenAPI resolved = openAPI;
        Paths paths = this.traversePaths(resolved.getPaths(), visitor);
        if (paths != null) {
            resolved.paths(paths);
        }
        if ((components = this.traverseComponents(resolved.getComponents(), visitor)) != null) {
            resolved.components(components);
        }
        this.traverseMap(resolved.getWebhooks(), visitor, this::traversePathItem);
        this.visitedMap.put(openAPI, resolved);
        this.visiting.remove(openAPI);
        return resolved;
    }

    public Components traverseComponents(Components components, Visitor visitor) {
        if (components == null) {
            return null;
        }
        if (this.visiting.contains(components)) {
            return components;
        }
        if (this.visitedMap.containsKey(components)) {
            return (Components)this.visitedMap.get(components);
        }
        this.visiting.add(components);
        Components resolved = components;
        this.traverseMap(resolved.getPathItems(), visitor, this::traversePathItem);
        this.traverseMap(resolved.getParameters(), visitor, this::traverseParameter);
        this.traverseMap(resolved.getCallbacks(), visitor, this::traverseCallback);
        this.traverseMap(resolved.getRequestBodies(), visitor, this::traverseRequestBody);
        this.traverseMap(resolved.getSecuritySchemes(), visitor, this::traverseSecurityScheme);
        this.traverseSchemaMap(resolved.getSchemas(), visitor, new ArrayList<String>());
        this.traverseMap(resolved.getHeaders(), visitor, this::traverseHeader);
        this.traverseMap(resolved.getLinks(), visitor, this::traverseLink);
        this.traverseMap(resolved.getResponses(), visitor, this::traverseResponse);
        this.traverseMap(resolved.getExamples(), visitor, this::traverseExample);
        this.visitedMap.put(components, resolved);
        this.visiting.remove(components);
        return resolved;
    }

    public Paths traversePaths(Paths paths, Visitor visitor) {
        if (paths == null) {
            return null;
        }
        if (this.visiting.contains(paths)) {
            return paths;
        }
        if (this.visitedMap.containsKey(paths)) {
            return (Paths)this.visitedMap.get(paths);
        }
        this.visiting.add(paths);
        Paths resolved = paths;
        this.traverseMap(resolved, visitor, this::traversePathItem);
        this.visitedMap.put(paths, resolved);
        this.visiting.remove(paths);
        return resolved;
    }

    public Operation traverseOperation(Operation operation, Visitor visitor) {
        ApiResponses resolvedResponses;
        RequestBody resolvedRequestBody;
        if (operation == null) {
            return null;
        }
        if (this.visiting.contains(operation)) {
            return operation;
        }
        if (this.visitedMap.containsKey(operation)) {
            return (Operation)this.visitedMap.get(operation);
        }
        this.visiting.add(operation);
        Operation resolved = operation;
        if (resolved.getParameters() != null) {
            for (int i = 0; i < resolved.getParameters().size(); ++i) {
                Parameter resolvedParameter = this.traverseParameter(resolved.getParameters().get(i), visitor);
                if (resolvedParameter == null) continue;
                resolved.getParameters().set(i, resolvedParameter);
            }
        }
        if (resolved.getRequestBody() != null && (resolvedRequestBody = this.traverseRequestBody(resolved.getRequestBody(), visitor)) != null) {
            resolved.setRequestBody(resolvedRequestBody);
        }
        if (resolved.getResponses() != null && (resolvedResponses = this.traverseResponses(resolved.getResponses(), visitor)) != null) {
            resolved.setResponses(resolvedResponses);
        }
        this.traverseMap(resolved.getCallbacks(), visitor, this::traverseCallback);
        this.visitedMap.put(operation, resolved);
        this.visiting.remove(operation);
        return resolved;
    }

    public ApiResponses traverseResponses(ApiResponses responses, Visitor visitor) {
        if (responses == null) {
            return null;
        }
        if (this.visiting.contains(responses)) {
            return responses;
        }
        if (this.visitedMap.containsKey(responses)) {
            return (ApiResponses)this.visitedMap.get(responses);
        }
        this.visiting.add(responses);
        ApiResponses resolved = responses;
        this.traverseMap(resolved, visitor, this::traverseResponse);
        this.visitedMap.put(responses, resolved);
        this.visiting.remove(responses);
        return resolved;
    }

    public ApiResponse traverseResponse(ApiResponse response, Visitor visitor) {
        if (response == null) {
            return null;
        }
        if (this.visiting.contains(response)) {
            return response;
        }
        if (this.visitedMap.containsKey(response)) {
            return (ApiResponse)this.visitedMap.get(response);
        }
        this.visiting.add(response);
        ApiResponse resolved = response;
        this.traverseMap(resolved.getContent(), visitor, this::traverseMediaType);
        this.traverseMap(resolved.getHeaders(), visitor, this::traverseHeader);
        this.traverseMap(resolved.getLinks(), visitor, this::traverseLink);
        this.visitedMap.put(response, this.deepcopy(resolved, ApiResponse.class));
        this.visiting.remove(response);
        return resolved;
    }

    public RequestBody traverseRequestBody(RequestBody requestBody, Visitor visitor) {
        if (requestBody == null) {
            return null;
        }
        if (this.visiting.contains(requestBody)) {
            return requestBody;
        }
        if (this.visitedMap.containsKey(requestBody)) {
            return (RequestBody)this.visitedMap.get(requestBody);
        }
        this.visiting.add(requestBody);
        RequestBody resolved = requestBody;
        this.traverseMap(resolved.getContent(), visitor, this::traverseMediaType);
        this.visitedMap.put(requestBody, this.deepcopy(resolved, RequestBody.class));
        this.visiting.remove(requestBody);
        return resolved;
    }

    public PathItem traversePathItem(PathItem pathItem, Visitor visitor) {
        Operation traceOp;
        Operation postOp;
        Operation headOp;
        Operation optionsOp;
        Operation patchOp;
        Operation deleteOp;
        Operation putOp;
        if (pathItem == null) {
            return null;
        }
        if (this.visiting.contains(pathItem)) {
            return pathItem;
        }
        if (this.visitedMap.containsKey(pathItem)) {
            return (PathItem)this.visitedMap.get(pathItem);
        }
        this.visiting.add(pathItem);
        PathItem resolved = pathItem;
        Operation getOp = resolved.getGet();
        Operation resolvedOperation = this.traverseOperation(getOp, visitor);
        if (resolvedOperation != null) {
            resolved.setGet(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(putOp = resolved.getPut(), visitor)) != null) {
            resolved.setPut(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(deleteOp = resolved.getDelete(), visitor)) != null) {
            resolved.setDelete(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(patchOp = resolved.getPatch(), visitor)) != null) {
            resolved.setPatch(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(optionsOp = resolved.getOptions(), visitor)) != null) {
            resolved.setOptions(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(headOp = resolved.getHead(), visitor)) != null) {
            resolved.setHead(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(postOp = resolved.getPost(), visitor)) != null) {
            resolved.setPost(resolvedOperation);
        }
        if ((resolvedOperation = this.traverseOperation(traceOp = resolved.getTrace(), visitor)) != null) {
            resolved.setTrace(resolvedOperation);
        }
        if (resolved.getParameters() != null) {
            for (int i = 0; i < resolved.getParameters().size(); ++i) {
                Parameter resolvedParameter = this.traverseParameter(resolved.getParameters().get(i), visitor);
                if (resolvedParameter == null) continue;
                resolved.getParameters().set(i, resolvedParameter);
            }
        }
        this.visitedMap.put(pathItem, this.deepcopy(resolved, PathItem.class));
        this.visiting.remove(pathItem);
        return resolved;
    }

    public Parameter traverseParameter(Parameter parameter, Visitor visitor) {
        Schema schema;
        if (parameter == null) {
            return null;
        }
        if (this.visiting.contains(parameter)) {
            return parameter;
        }
        if (this.visitedMap.containsKey(parameter)) {
            return (Parameter)this.visitedMap.get(parameter);
        }
        this.visiting.add(parameter);
        Parameter resolved = parameter;
        this.traverseMap(resolved.getContent(), visitor, this::traverseMediaType);
        if (resolved.getSchema() != null && (schema = this.traverseSchema(resolved.getSchema(), visitor, new ArrayList<String>())) != null) {
            resolved.setSchema(schema);
        }
        this.traverseMap(resolved.getExamples(), visitor, this::traverseExample);
        this.visitedMap.put(parameter, this.deepcopy(resolved, Parameter.class));
        this.visiting.remove(parameter);
        return resolved;
    }

    public Example traverseExample(Example example, Visitor visitor) {
        if (example == null) {
            return null;
        }
        if (this.visiting.contains(example)) {
            return example;
        }
        if (this.visitedMap.containsKey(example)) {
            return (Example)this.visitedMap.get(example);
        }
        this.visiting.add(example);
        Example resolved = example;
        this.visitedMap.put(example, this.deepcopy(resolved, Example.class));
        this.visiting.remove(example);
        return resolved;
    }

    public Callback traverseCallback(Callback callback, Visitor visitor) {
        if (callback == null) {
            return null;
        }
        if (this.visiting.contains(callback)) {
            return callback;
        }
        if (this.visitedMap.containsKey(callback)) {
            return (Callback)this.visitedMap.get(callback);
        }
        this.visiting.add(callback);
        this.traverseMap(callback, visitor, this::traversePathItem);
        this.visitedMap.put(callback, callback);
        this.visiting.remove(callback);
        return callback;
    }

    public MediaType traverseMediaType(MediaType mediaType, Visitor visitor) {
        if (mediaType == null) {
            return null;
        }
        if (this.visiting.contains(mediaType)) {
            return mediaType;
        }
        if (this.visitedMap.containsKey(mediaType)) {
            return (MediaType)this.visitedMap.get(mediaType);
        }
        this.visiting.add(mediaType);
        MediaType resolved = mediaType;
        if (resolved.getSchema() != null) {
            this.traverseSchema(resolved.getSchema(), visitor, new ArrayList<String>());
        }
        this.traverseMap(resolved.getEncoding(), visitor, this::traverseEncoding);
        this.traverseMap(resolved.getExamples(), visitor, this::traverseExample);
        this.visitedMap.put(mediaType, resolved);
        this.visiting.remove(mediaType);
        return resolved;
    }

    public Encoding traverseEncoding(Encoding encoding, Visitor visitor) {
        if (encoding == null) {
            return null;
        }
        if (this.visiting.contains(encoding)) {
            return encoding;
        }
        if (this.visitedMap.containsKey(encoding)) {
            return (Encoding)this.visitedMap.get(encoding);
        }
        this.visiting.add(encoding);
        Encoding resolved = encoding;
        this.traverseMap(resolved.getHeaders(), visitor, this::traverseHeader);
        this.visitedMap.put(encoding, resolved);
        this.visiting.remove(encoding);
        return resolved;
    }

    public Header traverseHeader(Header header, Visitor visitor) {
        if (header == null) {
            return null;
        }
        if (this.visiting.contains(header)) {
            return header;
        }
        if (this.visitedMap.containsKey(header)) {
            return (Header)this.visitedMap.get(header);
        }
        this.visiting.add(header);
        Header resolved = header;
        this.traverseMap(resolved.getContent(), visitor, this::traverseMediaType);
        if (resolved.getSchema() != null) {
            this.traverseSchema(resolved.getSchema(), visitor, new ArrayList<String>());
        }
        this.visitedMap.put(header, this.deepcopy(resolved, Header.class));
        this.visiting.remove(header);
        return resolved;
    }

    public SecurityScheme traverseSecurityScheme(SecurityScheme securityScheme, Visitor visitor) {
        if (securityScheme == null) {
            return null;
        }
        if (this.visiting.contains(securityScheme)) {
            return securityScheme;
        }
        if (this.visitedMap.containsKey(securityScheme)) {
            return (SecurityScheme)this.visitedMap.get(securityScheme);
        }
        this.visiting.add(securityScheme);
        SecurityScheme resolved = securityScheme;
        this.visitedMap.put(securityScheme, this.deepcopy(resolved, SecurityScheme.class));
        this.visiting.remove(securityScheme);
        return resolved;
    }

    public Link traverseLink(Link link, Visitor visitor) {
        if (link == null) {
            return null;
        }
        if (this.visiting.contains(link)) {
            return link;
        }
        if (this.visitedMap.containsKey(link)) {
            return (Link)this.visitedMap.get(link);
        }
        this.visiting.add(link);
        Link resolved = link;
        this.traverseMap(resolved.getHeaders(), visitor, this::traverseHeader);
        this.visitedMap.put(link, this.deepcopy(resolved, Link.class));
        this.visiting.remove(link);
        return resolved;
    }

    public Schema traverseSchema(Schema schema, Visitor visitor, List<String> inheritedIds) {
        Schema resolvedSchema;
        Schema traversedSchema;
        if (schema == null) {
            return null;
        }
        if (this.visiting.contains(schema)) {
            return schema;
        }
        if (this.visitedMap.containsKey(schema)) {
            return (Schema)this.visitedMap.get(schema);
        }
        this.visiting.add(schema);
        if (StringUtils.isNotBlank(schema.get$id())) {
            inheritedIds.add(schema.get$id());
            try {
                String resolvedURI = this.context.currentUri;
                for (String id : inheritedIds) {
                    String urlWithoutHash = ReferenceUtils.toBaseURI(id);
                    resolvedURI = ReferenceUtils.resolve(urlWithoutHash, resolvedURI);
                    resolvedURI = ReferenceUtils.toBaseURI(resolvedURI);
                }
                this.context.getIdsCache().put(resolvedURI, Json31.pretty(schema));
            }
            catch (Exception resolvedURI) {
                // empty catch block
            }
        }
        Schema resolved = schema;
        this.traverseSchemaMap(resolved.getProperties(), visitor, inheritedIds);
        if (resolved.getAdditionalItems() != null && (traversedSchema = this.traverseSchema(resolved.getAdditionalItems(), visitor, inheritedIds)) != null) {
            resolved.setAdditionalItems(traversedSchema);
        }
        if (resolved.getAdditionalProperties() != null && resolved.getAdditionalProperties() instanceof Schema && (traversedSchema = this.traverseSchema((Schema)resolved.getAdditionalProperties(), visitor, inheritedIds)) != null) {
            resolved.setAdditionalProperties(traversedSchema);
        }
        if (resolved.getAllOf() != null) {
            for (int i = 0; i < resolved.getAllOf().size(); ++i) {
                resolvedSchema = this.traverseSchema(resolved.getAllOf().get(i), visitor, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved.getAllOf().set(i, resolvedSchema);
            }
        }
        if (resolved.getAnyOf() != null) {
            for (int i = 0; i < resolved.getAnyOf().size(); ++i) {
                resolvedSchema = this.traverseSchema(resolved.getAnyOf().get(i), visitor, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved.getAnyOf().set(i, resolvedSchema);
            }
        }
        if (resolved.getContains() != null && (traversedSchema = this.traverseSchema(resolved.getContains(), visitor, inheritedIds)) != null) {
            resolved.setContains(traversedSchema);
        }
        if (resolved.getContentSchema() != null && (traversedSchema = this.traverseSchema(resolved.getContentSchema(), visitor, inheritedIds)) != null) {
            resolved.setContentSchema(traversedSchema);
        }
        this.traverseSchemaMap(resolved.getDependentSchemas(), visitor, inheritedIds);
        if (resolved.getElse() != null && (traversedSchema = this.traverseSchema(resolved.getElse(), visitor, inheritedIds)) != null) {
            resolved.setElse(traversedSchema);
        }
        if (resolved.getIf() != null && (traversedSchema = this.traverseSchema(resolved.getIf(), visitor, inheritedIds)) != null) {
            resolved.setIf(traversedSchema);
        }
        if (resolved.getItems() != null && (traversedSchema = this.traverseSchema(resolved.getItems(), visitor, inheritedIds)) != null) {
            resolved.setItems(traversedSchema);
        }
        if (resolved.getNot() != null && (traversedSchema = this.traverseSchema(resolved.getNot(), visitor, inheritedIds)) != null) {
            resolved.setNot(traversedSchema);
        }
        if (resolved.getOneOf() != null) {
            for (int i = 0; i < resolved.getOneOf().size(); ++i) {
                resolvedSchema = this.traverseSchema(resolved.getOneOf().get(i), visitor, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved.getOneOf().set(i, resolvedSchema);
            }
        }
        this.traverseSchemaMap(resolved.getPatternProperties(), visitor, inheritedIds);
        if (resolved.getPrefixItems() != null) {
            for (int i = 0; i < resolved.getPrefixItems().size(); ++i) {
                resolvedSchema = this.traverseSchema(resolved.getPrefixItems().get(i), visitor, inheritedIds);
                if (resolvedSchema == null) continue;
                resolved.getPrefixItems().set(i, resolvedSchema);
            }
        }
        if (resolved.getThen() != null && (traversedSchema = this.traverseSchema(resolved.getThen(), visitor, inheritedIds)) != null) {
            resolved.setThen(traversedSchema);
        }
        if (resolved.getUnevaluatedItems() != null && (traversedSchema = this.traverseSchema(resolved.getUnevaluatedItems(), visitor, inheritedIds)) != null) {
            resolved.setUnevaluatedItems(traversedSchema);
        }
        if (resolved.getAdditionalProperties() != null && resolved.getUnevaluatedProperties() instanceof Schema && (traversedSchema = this.traverseSchema(resolved.getUnevaluatedProperties(), visitor, inheritedIds)) != null) {
            resolved.setUnevaluatedProperties(traversedSchema);
        }
        if (StringUtils.isNotBlank(schema.get$id())) {
            inheritedIds.remove(schema.get$id());
        }
        this.visitedMap.put(schema, this.deepcopy(resolved, Schema.class));
        this.visiting.remove(schema);
        return resolved;
    }

    public <T> T deepcopy(T entity, Class<T> clazz) {
        try {
            return Json31.mapper().readValue(Json31.mapper().writeValueAsString(entity), clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> void traverseMap(Map<String, T> map, Visitor visitor, BiFunction<T, Visitor, T> traverser) {
        if (map != null) {
            LinkedHashMap<String, T> copy = new LinkedHashMap<String, T>(map);
            for (String key : copy.keySet()) {
                Object entity = copy.get(key);
                T resolved = traverser.apply(entity, visitor);
                if (resolved == null) continue;
                map.put(key, resolved);
            }
        }
    }

    public void traverseSchemaMap(Map<String, Schema> map, Visitor visitor, List<String> inheritedIds) {
        if (map != null) {
            LinkedHashMap<String, Schema> copy = new LinkedHashMap<String, Schema>(map);
            for (String key : copy.keySet()) {
                Schema entity = (Schema)copy.get(key);
                Schema resolved = this.traverseSchema(entity, visitor, inheritedIds);
                if (resolved == null) continue;
                map.put(key, resolved);
            }
        }
    }
}

