
// State Assignments

// Pixel Pipe

CG_STATE_ASSIGNMENT_MACRO( STATE_ERROR                       )
CG_STATE_ASSIGNMENT_MACRO( STATE_ALPHA_BLEND_ENABLE          )
CG_STATE_ASSIGNMENT_MACRO( STATE_ALPHA_FUNC                  )
CG_STATE_ASSIGNMENT_MACRO( STATE_ALPHA_FUNC2                 ) // GL's AlphaFunc wants 2 parameters (func & ref)
CG_STATE_ASSIGNMENT_MACRO( STATE_ALPHA_REF                   )
CG_STATE_ASSIGNMENT_MACRO( STATE_ALPHA_TEST_ENABLE           )  
CG_STATE_ASSIGNMENT_MACRO( STATE_BLEND_OP                    ) // BlendEquation
CG_STATE_ASSIGNMENT_MACRO( STATE_COLOR_WRITE_ENABLE          ) // ColorMask
CG_STATE_ASSIGNMENT_MACRO( STATE_DEPTH_BIAS                  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_DEST_BLEND                  )
CG_STATE_ASSIGNMENT_MACRO( STATE_DITHER_ENABLE               )
CG_STATE_ASSIGNMENT_MACRO( STATE_FILL_MODE                   ) // PolygonMode
CG_STATE_ASSIGNMENT_MACRO( STATE_LAST_PIXEL                  )
CG_STATE_ASSIGNMENT_MACRO( STATE_SHADE_MODE                  ) // ShadeModel
CG_STATE_ASSIGNMENT_MACRO( STATE_SLOPE_SCALE_DEPTH_BIAS      )    
CG_STATE_ASSIGNMENT_MACRO( STATE_SRC_BLEND                   )
CG_STATE_ASSIGNMENT_MACRO( STATE_STENCIL_ENABLE              ) // StencilTestEnable
CG_STATE_ASSIGNMENT_MACRO( STATE_STENCIL_FAIL                )
CG_STATE_ASSIGNMENT_MACRO( STATE_STENCIL_FUNC                )
CG_STATE_ASSIGNMENT_MACRO( STATE_STENCIL_FUNC2               ) // GL's calls func, ref, & mask
CG_STATE_ASSIGNMENT_MACRO( STATE_STENCIL_MASK                )
CG_STATE_ASSIGNMENT_MACRO( STATE_STENCIL_PASS                )
CG_STATE_ASSIGNMENT_MACRO( STATE_STENCIL_REF                 )
CG_STATE_ASSIGNMENT_MACRO( STATE_STENCIL_WRITE_MASK          )
CG_STATE_ASSIGNMENT_MACRO( STATE_STENCIL_ZFAIL               )
CG_STATE_ASSIGNMENT_MACRO( STATE_TFACTOR                     ) // TextureFactor (not in GL?)*
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP0                       )  
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP1                       )  
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP2                       )  
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP3                       )  
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP4                       )  
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP5                       ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP6                       )  
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP7                       )  
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP8                       )  
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP9                       )  
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP10                      )  
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP11                      )  
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP12                      )  
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP13                      )  
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP14                      )  
CG_STATE_ASSIGNMENT_MACRO( STATE_WRAP15                      )  
CG_STATE_ASSIGNMENT_MACRO( STATE_ZENABLE                     ) // DepthTestEnable
CG_STATE_ASSIGNMENT_MACRO( STATE_ZFUNC                       ) // DepthFunc
CG_STATE_ASSIGNMENT_MACRO( STATE_ZWRITE_ENABLE               ) // DepthMask
CG_STATE_ASSIGNMENT_MACRO( STATE_BLEND_FUNC                  ) // GL's aggregate (45 -ignore this)

CG_STATE_ASSIGNMENT_MACRO( STATE_MATERIAL_AMBIENT            )
CG_STATE_ASSIGNMENT_MACRO( STATE_MATERIAL_DIFFUSE            )
CG_STATE_ASSIGNMENT_MACRO( STATE_MATERIAL_EMISSIVE           ) // MaterialEmission
CG_STATE_ASSIGNMENT_MACRO( STATE_MATERIAL_POWER              ) // MaterialShininess
CG_STATE_ASSIGNMENT_MACRO( STATE_MATERIAL_SPECULAR           )

// The light states have an index [n]

CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_AMBIENT               ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_ATTENUATION0          ) // LightConstantAttenuation
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_ATTENUATION1          ) // LightLinearAttenuation
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_ATTENUATION2          ) // LightQuadraticAttenuation
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_DIFFUSE               ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_DIRECTION             ) // LightSpotDirection?
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_ENABLE                ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_FALLOFF               ) // LightSpotCutoff?
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_PHI                   ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_POSITION              ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_RANGE                 ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_SPECULAR              ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_THETA                 ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_TYPE                  ) 

// Vertex Pipe

CG_STATE_ASSIGNMENT_MACRO( STATE_AMBIENT                     ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_AMBIENT_MATERIAL_SOURCE     ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_CLIPPING                    ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_CLIP_PLANE_ENABLE           ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_COLOR_VERTEX                ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_CULL_MODE                   ) // CullFace
CG_STATE_ASSIGNMENT_MACRO( STATE_DIFFUSE_MATERIAL_SOURCE     ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_EMISSIVE_MATERIAL_SOURCE    ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_FOG_COLOR                   ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_FOG_DENSITY                 ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_FOG_ENABLE                  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_FOG_END                     ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_FOG_START                   ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_FOG_TABLE_MODE              ) // FogMode / FogCoordSrc
CG_STATE_ASSIGNMENT_MACRO( STATE_FOG_VERTEX_MODE             ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_INDEXED_VERTEX_BLEND_ENABLE ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHTING_ENABLE             ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LOCAL_VIEWER                ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_MULTI_SAMPLE_AA             ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_MULTI_SAMPLE_MASK           ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_NORMALIZE_NORMALS           ) // NormalizeEnable
CG_STATE_ASSIGNMENT_MACRO( STATE_PATCH_SEGMENTS              ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POINT_SCALE_A               ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POINT_SCALE_B               ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POINT_SCALE_C               ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POINT_SCALE_ENABLE          ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POINT_SIZE                  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POINT_SIZE_MIN              ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POINT_SIZE_MAX              ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POINT_SPRITE_ENABLE         ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_RANGE_FOG_ENABLE            ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_SPECULAR_ENABLE             ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_SPECULAR_MATERIAL_SOURCE    ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_TWEEN_FACTOR                ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_VERTEX_BLEND                ) 

CG_STATE_ASSIGNMENT_MACRO( STATE_VERTEX_PROGRAM_PSIZE_ENABLE    )
CG_STATE_ASSIGNMENT_MACRO( STATE_VERTEX_PROGRAM_TWO_SIDE_ENABLE )

// sampler stage states (these have an index [n] where n -> [0)15])

CG_STATE_ASSIGNMENT_MACRO( STATE_ADDRESS_U                   ) // WrapS
CG_STATE_ASSIGNMENT_MACRO( STATE_ADDRESS_V                   ) // WrapT
CG_STATE_ASSIGNMENT_MACRO( STATE_ADDRESS_W                   ) // WrapR
CG_STATE_ASSIGNMENT_MACRO( STATE_BORDER_COLOR                ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_MAX_ANISOTROPY              ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_MAX_MIP_LEVEL               ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_MIN_MIP_LEVEL               ) // not in D3D
CG_STATE_ASSIGNMENT_MACRO( STATE_MIN_FILTER                  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_MAG_FILTER                  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_MIP_FILTER                  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_MIPMAP_LOD_BIAS             ) // LODBias
CG_STATE_ASSIGNMENT_MACRO( STATE_SRGB_TEXTURE                ) // (D3D only)

// texture stage states (these have an index [n] where n -> [0)7]

CG_STATE_ASSIGNMENT_MACRO( STATE_ALPHA_OP                    ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_ALPHA_ARG0                  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_ALPHA_ARG1                  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_ALPHA_ARG2                  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_COLOR_ARG0                  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_COLOR_ARG1                  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_COLOR_ARG2                  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_COLOR_OP                    ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_BUMP_ENV_LSCALE             ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_BUMP_ENV_LOFFSET            ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_BUMP_ENV_MAT00              ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_BUMP_ENV_MAT01              ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_BUMP_ENV_MAT10              ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_BUMP_ENV_MAT11              ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_RESULT_ARG                  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_TEX_COORD_INDEX             ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_TRANSFORM_FLAGS     ) 

// transform states

CG_STATE_ASSIGNMENT_MACRO( STATE_PROJECTION_TRANSFORM        ) // ProjectionMatrix
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_TRANSFORM           ) // TextureMatrix
CG_STATE_ASSIGNMENT_MACRO( STATE_VIEW_TRANSFORM              ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_WORLD_TRANSFORM             ) 

// Misc

CG_STATE_ASSIGNMENT_MACRO( STATE_CLEAR_COLOR                 )
CG_STATE_ASSIGNMENT_MACRO( STATE_CLEAR_STENCIL               )
CG_STATE_ASSIGNMENT_MACRO( STATE_CLEAR_DEPTH                 )
CG_STATE_ASSIGNMENT_MACRO( STATE_CLIP_PLANE                  ) // Is this not in HLSL effects?
CG_STATE_ASSIGNMENT_MACRO( STATE_COLOR_MATERIAL              )
CG_STATE_ASSIGNMENT_MACRO( STATE_SCISSOR_TEST_ENABLE         )
CG_STATE_ASSIGNMENT_MACRO( STATE_SCISSOR                     )
CG_STATE_ASSIGNMENT_MACRO( STATE_STENCIL_OP                  ) // Calls 3 d3d calls
CG_STATE_ASSIGNMENT_MACRO( STATE_STENCIL_FUNC_SEPARATE       )
CG_STATE_ASSIGNMENT_MACRO( STATE_STENCIL_MASK_SEPARATE       )
CG_STATE_ASSIGNMENT_MACRO( STATE_STENCIL_OP_SEPARATE         )        
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_S_MODE               ) // TexGenSMode
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_T_MODE               ) // etc
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_R_MODE               )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_Q_MODE               )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_ENV_COLOR           )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_ENV_MODE            )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_S_OBJECT_PLANE       )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_T_OBJECT_PLANE       )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_R_OBJECT_PLANE       )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_Q_OBJECT_PLANE       )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_S_EYE_PLANE          )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_T_EYE_PLANE          )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_R_EYE_PLANE          )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_Q_EYE_PLANE          )

CG_STATE_ASSIGNMENT_MACRO( STATE_AUTO_NORMAL_ENABLE          ) // uses D3DRS_NORMALIZENORMALS
CG_STATE_ASSIGNMENT_MACRO( STATE_BLEND_ENABLE                )
CG_STATE_ASSIGNMENT_MACRO( STATE_CULL_FACE                   )
CG_STATE_ASSIGNMENT_MACRO( STATE_CULL_FACE_ENABLE            )
CG_STATE_ASSIGNMENT_MACRO( STATE_POINT_SMOOTH_ENABLE         ) // ?
CG_STATE_ASSIGNMENT_MACRO( STATE_POLYGON_SMOOTH_ENABLE       )
CG_STATE_ASSIGNMENT_MACRO( STATE_STENCIL_TEST_TWO_SIDE_ENABLE)

// Should we have U)V,W also?

CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_S_ENABLE             ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_T_ENABLE             ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_R_ENABLE             )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXGEN_Q_ENABLE             )
    
// Now the GL specific ones (a few can be done in D3D however)

CG_STATE_ASSIGNMENT_MACRO( STATE_MODELVIEW_TRANSFORM         ) // ModelViewMatrix

CG_STATE_ASSIGNMENT_MACRO( STATE_BLEND_FUNC_SEPARATE         )
CG_STATE_ASSIGNMENT_MACRO( STATE_BLEND_COLOR                 ) // D3DRS_BLENDFACTOR for D3D
CG_STATE_ASSIGNMENT_MACRO( STATE_BLEND_EQUATION_SEPARATE     ) // Just impt BlendOp
CG_STATE_ASSIGNMENT_MACRO( STATE_FRONT_FACE                  ) // D3DRS_CULLMODE
    
// No D3D eq states

CG_STATE_ASSIGNMENT_MACRO( STATE_DEPTH_BOUNDS                ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_DEPTH_RANGE                 ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_FOG_DISTANCE_MODE           ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_FRAGMENT_ENV_PARAM          ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_FRAGMENT_LOCAL_PARAM        ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_MODEL_LOCAL_VIEWER_ENABLE ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_MODEL_AMBIENT         ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_MODEL_TWO_SIDE_ENABLE ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_MODEL_COLOR_CONTROL   ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LOGIC_OP                    ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LOGIC_OP_ENABLE             ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POINT_SPRITE_COORD_ORIGIN   ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POINT_SPRITE_COORD_REPLACE  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POINT_SPRITE_R_MODE         ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POINT_FADE_THRESHOLD_SIZE   ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POINT_DISTANCE_ATTENUATION  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POLYGON_OFFSET              ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POLYGON_OFFSET_FILL_ENABLE  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POLYGON_OFFSET_LINE_ENABLE  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_POLYGON_OFFSET_POINT_ENABLE ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_VERTEX_ENV_PARAM            ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_VERTEX_LOCAL_PARAM          ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_RESCALE_NORMAL_ENABLE       ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_SAMPLE_ALPHA_TO_COV_ENABLE  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_SAMPLE_ALPHA_TO_ONE_ENABLE  ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_SAMPLE_COVERAGE_ENABLE      ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_DEPTH_MODE                  ) // uses GL_DEPTH_TEXTURE_MODE 
CG_STATE_ASSIGNMENT_MACRO( STATE_COMPARE_MODE                ) // uses GL_TEXTURE_COMPARE_MODE
CG_STATE_ASSIGNMENT_MACRO( STATE_COMPARE_FUNC                ) // uses GL_TEXTURE_COMPARE_FUNC
CG_STATE_ASSIGNMENT_MACRO( STATE_GENERATE_MIPMAP             )    
CG_STATE_ASSIGNMENT_MACRO( STATE_COLOR_MATRIX                )
CG_STATE_ASSIGNMENT_MACRO( STATE_COLOR_LOGIC_OP_ENABLE       )
CG_STATE_ASSIGNMENT_MACRO( STATE_DEPTH_BOUNDS_ENABLE         )
CG_STATE_ASSIGNMENT_MACRO( STATE_DEPTH_CLAMP_ENABLE          )
CG_STATE_ASSIGNMENT_MACRO( STATE_POLYGON_STIPPLE_ENABLE      )
CG_STATE_ASSIGNMENT_MACRO( STATE_LIGHT_SPOT_EXP              )
    
// ID3DXLine for D3D?

CG_STATE_ASSIGNMENT_MACRO( STATE_LINE_STIPPLE                ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_LINE_STIPPLE_ENABLE         )
CG_STATE_ASSIGNMENT_MACRO( STATE_LINE_WIDTH                  )
CG_STATE_ASSIGNMENT_MACRO( STATE_LINE_SMOOTH_ENABLE          )

CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_1D                  ) // Texture1D (same in d3d too)
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_2D                  ) // etc..
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_3D                  )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_RECT                ) // TextureRectangle
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_CUBE_MAP            )

CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_1D_ENABLE           ) // Tex enables not used in d3d
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_2D_ENABLE           )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_3D_ENABLE           )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_RECT_ENABLE         )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_CUBE_MAP_ENABLE     )

CG_STATE_ASSIGNMENT_MACRO( STATE_SHADER                      )
CG_STATE_ASSIGNMENT_MACRO( STATE_CALL_SETMATERIAL            ) // If sv.usedMaterial is true then call this state
CG_STATE_ASSIGNMENT_MACRO( STATE_CALL_SETLIGHT               )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE                     ) // used in a sampler state block
    
// For FX compatability in CgFX-D3D9

CG_STATE_ASSIGNMENT_MACRO( STATE_PIXEL_SHADER_CONSTANT       )
CG_STATE_ASSIGNMENT_MACRO( STATE_PIXEL_SHADER_CONSTANT1      )
CG_STATE_ASSIGNMENT_MACRO( STATE_PIXEL_SHADER_CONSTANT2      )
CG_STATE_ASSIGNMENT_MACRO( STATE_PIXEL_SHADER_CONSTANT3      )
CG_STATE_ASSIGNMENT_MACRO( STATE_PIXEL_SHADER_CONSTANT4      )
CG_STATE_ASSIGNMENT_MACRO( STATE_PIXEL_SHADER_CONSTANT_B     )
CG_STATE_ASSIGNMENT_MACRO( STATE_PIXEL_SHADER_CONSTANT_I     )
CG_STATE_ASSIGNMENT_MACRO( STATE_PIXEL_SHADER_CONSTANT_F     )
CG_STATE_ASSIGNMENT_MACRO( STATE_VERTEX_SHADER_CONSTANT      )
CG_STATE_ASSIGNMENT_MACRO( STATE_VERTEX_SHADER_CONSTANT1     )
CG_STATE_ASSIGNMENT_MACRO( STATE_VERTEX_SHADER_CONSTANT2     )
CG_STATE_ASSIGNMENT_MACRO( STATE_VERTEX_SHADER_CONSTANT3     )
CG_STATE_ASSIGNMENT_MACRO( STATE_VERTEX_SHADER_CONSTANT4     )
CG_STATE_ASSIGNMENT_MACRO( STATE_VERTEX_SHADER_CONSTANT_B    )
CG_STATE_ASSIGNMENT_MACRO( STATE_VERTEX_SHADER_CONSTANT_I    )
CG_STATE_ASSIGNMENT_MACRO( STATE_VERTEX_SHADER_CONSTANT_F    )
CG_STATE_ASSIGNMENT_MACRO( STATE_TEXTURE_PASS                ) // Texture[n] in a pass
CG_STATE_ASSIGNMENT_MACRO( STATE_SAMPLER                     ) // Used in a pass

// Sampler States in a pass (also for FX compat)

CG_STATE_ASSIGNMENT_MACRO( STATE_ADDRESS_U_16                )
CG_STATE_ASSIGNMENT_MACRO( STATE_ADDRESS_V_16                )
CG_STATE_ASSIGNMENT_MACRO( STATE_ADDRESS_W_16                )
CG_STATE_ASSIGNMENT_MACRO( STATE_BORDER_COLOR_16             ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_MAX_ANISOTROPY_16           ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_MAX_MIP_LEVEL_16            ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_MIN_FILTER_16               ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_MAG_FILTER_16               ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_MIP_FILTER_16               ) 
CG_STATE_ASSIGNMENT_MACRO( STATE_MIPMAP_LOD_BIAS_16          ) 

CG_STATE_ASSIGNMENT_MACRO( STATE_COLOR_WRITE_ENABLE_1        )
CG_STATE_ASSIGNMENT_MACRO( STATE_COLOR_WRITE_ENABLE_2        )
CG_STATE_ASSIGNMENT_MACRO( STATE_COLOR_WRITE_ENABLE_3        )

CG_STATE_ASSIGNMENT_MACRO( STATE_BLEND_OP_ALPHA              )
CG_STATE_ASSIGNMENT_MACRO( STATE_SRC_BLEND_ALPHA             )
CG_STATE_ASSIGNMENT_MACRO( STATE_DEST_BLEND_ALPHA            )
CG_STATE_ASSIGNMENT_MACRO( STATE_SEPARATE_ALPHA_BLEND_ENABLE )

#undef CG_STATE_ASSIGNMENT_MACRO
