/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

class CHTBLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int DATETIME = 8;
    public static final int DATEINHEADER = 14;
    public static final int HEADER = 12;
    public static final int PREAMBLE = 16;
    public static final int DOCNO = 2;
    public static final int SRCID = 10;
    public static final int YYINITIAL = 0;
    public static final int DOCID = 4;
    public static final int DOCTYPE = 6;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8};
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0018\u0001\u0016\u0001\u0017\u0001\u0017\u0001\u0015\u0012\u0000\u0001\u0018\u0007\u0000\u0001\u0014\u0001\u0014\u0005\u0000\u0001\b\f\u0000\u0001\u0001\u0001\u0000\u0001\u0002\u0002\u0000\u0001\u0005\u0001\u0012\u0001\n\u0001\u0006\u0001\u0004\u0002\u0000\u0001\u0003\u0001\f\u0002\u0000\u0001\u0013\u0001\u0010\u0001\u000b\u0001\t\u0001\u000f\u0001\u0000\u0001\u0007\u0001\u0011\u0001\r\u0004\u0000\u0001\u000e+\u0000\u0001\u0017\u1fa2\u0000\u0001\u0017\u0001\u0017\udfd6\u0000";
    private static final char[] ZZ_CMAP = CHTBLexer.zzUnpackCMap("\t\u0000\u0001\u0018\u0001\u0016\u0001\u0017\u0001\u0017\u0001\u0015\u0012\u0000\u0001\u0018\u0007\u0000\u0001\u0014\u0001\u0014\u0005\u0000\u0001\b\f\u0000\u0001\u0001\u0001\u0000\u0001\u0002\u0002\u0000\u0001\u0005\u0001\u0012\u0001\n\u0001\u0006\u0001\u0004\u0002\u0000\u0001\u0003\u0001\f\u0002\u0000\u0001\u0013\u0001\u0010\u0001\u000b\u0001\t\u0001\u000f\u0001\u0000\u0001\u0007\u0001\u0011\u0001\r\u0004\u0000\u0001\u000e+\u0000\u0001\u0017\u1fa2\u0000\u0001\u0017\u0001\u0017\udfd6\u0000");
    private static final int[] ZZ_ACTION = CHTBLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\t\u0000\u0003\u0001\u0004\u0002\u0001\u0003\u0001\u0004\u0006\u0003\u0006\u0001\t\u0000\u0001\u0002\u0006\u0001\t\u0000\u0005\u0001\t\u0000\u0007\u0001\b\u0000\u0001\u0001\u0001\u0005\u0005\u0001\u0005\u0000\u0001\u0006\u0004\u0000\u0002\u0001\u0001\u0007\u0001\u0001\u0001\b\u0001\u0001\u0002\u0000\u0001\t\u0004\u0000\u0001\n\u0002\u0000\u0001\u000b\u0002\u0001\u0001\u0000\u0002\u0001\u0001\f\u0002\u0000\u0001\r\u0004\u0000\u0002\u0001\u0001\u0000\u0001\u000e\u0001\u0001\u0003\u0000\u0001\u000f\u0002\u0000\u0002\u0001\u0001\u0000\u0001\u0010\u0001\u0011\u0004\u0000\u0001\u0001\u0003\u0000\u0001\u0012\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0002\u0001\u0002\u0000\u0001\u0001\u0001\u0000";
    private static final int[] ZZ_ROWMAP = CHTBLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0019\u00002\u0000K\u0000d\u0000}\u0000\u0096\u0000\u00af\u0000\u00c8\u0000\u00e1\u0000\u00fa\u0000\u0113\u0000\u012c\u0000\u0113\u0000\u0145\u0000\u015e\u0000\u0177\u0000\u0113\u0000\u0190\u0000\u01a9\u0000\u01c2\u0000\u01db\u0000\u01f4\u0000\u020d\u0000\u0226\u0000\u023f\u0000\u0258\u0000\u0271\u0000\u028a\u0000\u02a3\u0000\u02bc\u0000\u02d5\u0000\u02ee\u0000\u0307\u0000\u0320\u0000\u0339\u0000\u0352\u0000\u036b\u0000\u0384\u0000\u00e1\u0000\u039d\u0000\u03b6\u0000\u03cf\u0000\u03e8\u0000\u0401\u0000\u041a\u0000\u0433\u0000\u044c\u0000\u0465\u0000\u047e\u0000\u0497\u0000\u04b0\u0000\u04c9\u0000\u04e2\u0000\u04fb\u0000\u0514\u0000\u052d\u0000\u0546\u0000\u055f\u0000\u0578\u0000\u0591\u0000\u05aa\u0000\u05c3\u0000\u05dc\u0000\u05f5\u0000\u060e\u0000\u0627\u0000\u0640\u0000\u0659\u0000\u0672\u0000\u068b\u0000\u06a4\u0000\u06bd\u0000\u06d6\u0000\u06ef\u0000\u0708\u0000\u0721\u0000\u073a\u0000\u0753\u0000\u076c\u0000\u0785\u0000\u079e\u0000\u07b7\u0000\u07d0\u0000\u07e9\u0000\u00e1\u0000\u0802\u0000\u081b\u0000\u0834\u0000\u084d\u0000\u0866\u0000\u087f\u0000\u0898\u0000\u08b1\u0000\u08ca\u0000\u08e3\u0000\u0113\u0000\u08fc\u0000\u0915\u0000\u092e\u0000\u0947\u0000\u0960\u0000\u0979\u0000\u0992\u0000\u09ab\u0000\u00e1\u0000\u09c4\u0000\u09dd\u0000\u09f6\u0000\u0113\u0000\u0a0f\u0000\u0a28\u0000\u0a41\u0000\u0a5a\u0000\u0113\u0000\u0a73\u0000\u0a8c\u0000\u00e1\u0000\u0aa5\u0000\u0abe\u0000\u0ad7\u0000\u0af0\u0000\u0b09\u0000\u0113\u0000\u0b22\u0000\u0b3b\u0000\u0113\u0000\u0b54\u0000\u0b6d\u0000\u0b86\u0000\u0b9f\u0000\u0bb8\u0000\u0bd1\u0000\u0bea\u0000\u00e1\u0000\u0c03\u0000\u0c1c\u0000\u0c35\u0000\u0c4e\u0000\u0113\u0000\u0c67\u0000\u0c80\u0000\u0c99\u0000\u0cb2\u0000\u0ccb\u0000\u00e1\u0000\u0113\u0000\u0ce4\u0000\u0cfd\u0000\u0d16\u0000\u0d2f\u0000\u0d48\u0000\u0d61\u0000\u0d7a\u0000\u0d93\u0000\u0113\u0000\u0dac\u0000\u0dc5\u0000\u0dde\u0000\u0df7\u0000\u0e10\u0000\u0e29\u0000\u0e42\u0000\u0e5b\u0000\u0e74\u0000\u0e8d";
    private static final int[] ZZ_TRANS = CHTBLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\n\u0001\u000b\u0012\n\u0001\f\u0001\r\u0002\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0017\u0010\u0019\u0012\u0001\u0010\u0001\u0013\u0018\u0010\u0001\u0014\u0018\u0010\u0001\u0015\u0018\u0010\u0001\u0016\u0018\u0010\u0001\u0017\u0018\u0010\u0001\u0018\u0017\u0010\u0014\n\u0005\u0000\u0002\u0019\u0001\n\u0001\u001a\u0002\u0019\u0001\u001b\u0003\u0019\u0001\u001c\u0004\u0019\u0001\u001d\u0001\u0019\u0001\u001e\u0002\u0019\u0005\u001f/\u0000\u0001\u000e\u001a\u0000\u0001\u000f\u0001\u0010\u0001\u0000\u0017\u0010\b\u0000\u0001 \u0018\u0000\u0001!\u0018\u0000\u0001\"\u0018\u0000\u0001#\u0016\u0000\u0001$\u0001\u0000\u0001%\u0018\u0000\u0001&\u0018\u0000\u0001'\u0010\u0000\u0002\u0019\u0001(\u0011\u0019\u0005\u001f\u0002\u0019\u0001(\u0001\u0019\u0001)\u000f\u0019\u0005\u001f\u0002\u0019\u0001(\u0002\u0019\u0001*\u0003\u0019\u0001+\n\u0019\u0005\u001f\u0002\u0019\u0001(\n\u0019\u0001,\u0006\u0019\u0005\u001f\u0002\u0019\u0001(\u0004\u0019\u0001-\f\u0019\u0005\u001f\u0002\u0019\u0001(\u0004\u0019\u0001.\f\u0019\u0007\u001f\u0001\u000e\u0016\u001f\u0006\u0000\u0001/\u0018\u0000\u00010\u0018\u0000\u00011\u001c\u0000\u00012\u0006\u0000\u00013\f\u0000\u00014\u0016\u0000\u00015\u001b\u0000\u00016!\u0000\u00017\t\u0000\u0002\u0019\u0001(\u0002\u0019\u00018\u000e\u0019\u0005\u001f\u0002\u0019\u0001(\n\u0019\u00019\u0006\u0019\u0005\u001f\u0002\u0019\u0001(\u0007\u0019\u0001:\t\u0019\u0005\u001f\u0002\u0019\u0001(\u000f\u0019\u0001;\u0001\u0019\u0005\u001f\u0002\u0019\u0001(\u0001\u0019\u0001<\u000f\u0019\u0005\u001f\u0002\u0019\u0001(\u0007\u0019\u0001;\t\u0019\u0005\u001f\t\u0000\u0001=\u0018\u0000\u0001>\u0014\u0000\u0001? \u0000\u0001@\u0012\u0000\u0001A\u001e\u0000\u0001B\u000f\u0000\u0001C\u0019\u0000\u0001D\u001a\u0000\u0001E\u0011\u0000\u0002\u0019\u0001(\u0003\u0019\u0001F\r\u0019\u0005\u001f\u0002\u0019\u0001(\u0001\u0019\u0001G\u000f\u0019\u0005\u001f\u0002\u0019\u0001(\b\u0019\u0001H\u0001I\u0001J\u0006\u0019\u0005\u001f\u0002\u0019\u0001(\t\u0019\u0001K\u0007\u0019\u0005\u001f\u0002\u0019\u0001(\u0002\u0019\u0001L\u000e\u0019\u0005\u001f\n\u0000\u0001M\u0018\u0000\u0001N\u001b\u0000\u0001O\u001d\u0000\u0001P\u0010\u0000\u0001P\u0012\u0000\u0001Q\u0019\u0000\u0001R \u0000\u0001S\u000f\u0000\u0001T\u0014\u0000\u0002\u0019\u0001(\u0001\u0019\u0001U\u000f\u0019\u0005\u001f\u0002\u0019\u0001V\u0005\u0019\u0001W\u000b\u0019\u0005\u001f\u0002\u0019\u0001(\u0006\u0019\u0001X\n\u0019\u0005\u001f\u0002\u0019\u0001(\u0003\u0019\u0001X\r\u0019\u0005\u001f\u0002\u0019\u0001(\u000b\u0019\u0001Y\u0005\u0019\u0005\u001f\u0002\u0019\u0001(\u0003\u0019\u0001Z\r\u0019\u0005\u001f\u0002\u0019\u0001(\r\u0019\u0001[\u0003\u0019\u0005\u001f\u000b\u0000\u0001\\\u0001]\u0019\u0000\u0001^\u000f\u0000\u0001_ \u0000\u0001`\u000e\u0000\u0001a\u0005\u0000\u0001b\u0016\u0000\u0001c\u0016\u0000\u0001d\u0019\u0000\u0001e\u0013\u0000\u0002\u0019\u0001(\u0004\u0019\u0001f\f\u0019\u0005\u001f\u0002\u0019\u0001(\n\u0019\u0001g\u0006\u0019\u0005\u001f\u0002\u0019\u0001h\u0011\u0019\u0005\u001f\u0002\u0019\u0001(\f\u0019\u0001i\u0004\u0019\u0005\u001f\u0002\u0019\u0001j\u0011\u0019\u0005\u001f\u0002\u0019\u0001(\u000f\u0019\u0001k\u0001\u0019\u0005\u001f\t\u0000\u0001l\u0015\u0000\u0001l \u0000\u0001m\f\u0000\u0001n\u0005\u0000\u0001o\u0016\u0000\u0001p\u001f\u0000\u0001q\u000f\u0000\u0001r\u0016\u0000\u0001s\u0005\u0000\u0001t \u0000\u0001u\b\u0000\u0002\u0019\u0001v\u0011\u0019\u0005\u001f\u0002\u0019\u0001(\t\u0019\u0001w\u0007\u0019\u0005\u001f\u0001x\u0001\n\u0012x\u0005y\u0002\u0019\u0001(\u0001\u0019\u0001z\u000f\u0019\u0005\u001f\u0002\u0019\u0001(\u0010\u0019\u0001{\u0005\u001f\u0002\u0000\u0001|%\u0000\u0001}\u0016\u0000\u0001~\r\u0000\u0001\u007f\"\u0000\u0001\u0080\u0013\u0000\u0001\u0081\u001e\u0000\u0001\u0082\u001d\u0000\u0001\u0083\u0006\u0000\u0002\u0019\u0001(\r\u0019\u0001\u0084\u0003\u0019\u0005\u001f\u0001x\u0001\u0085\u0012x\u0006y\u0001\u0086\u0017y\u0002\u0019\u0001\u0087\u0011\u0019\u0005\u001f\u0002\u0019\u0001(\u0001\u0019\u0001\u0088\u000f\u0019\u0005\u001f\u0004\u0000\u0001\u0089 \u0000\u0001\u008a\u001c\u0000\u0001\u008b\n\u0000\u0001\u008c\"\u0000\u0001\u008d\u001f\u0000\u0001\u008e\u0005\u0000\u0002\u0019\u0001(\u0001\u0019\u0001\u008f\u000f\u0019\u0005\u001f\b\n\u0001\u0090\u000b\n\r\u0000\u0001\u0091\u0010\u0000\u0002\u0019\u0001\u0092\u0011\u0019\u0005\u001f\u0002\u0000\u0001\u0093&\u0000\u0001\u0094\f\u0000\u0001\u0095$\u0000\u0001\u0096\f\u0000\u0001\u0097\u0014\u0000\u0002\u0019\u0001V\u0011\u0019\u0005\u001f\u0006\n\u0001\u0098\r\n\u000b\u0000\u0001\u0099\u0016\u0000\u0001\u009a\u0016\u0000\u0001a\u001a\u0000\u0001\u009b\u0016\u0000\u0001\u009c\u0016\u0000\t\n\u0001\u009d\n\n\u000e\u0000\u0001\u009e\u0011\u0000\u0001n\u0018\u0000\u0001s\u0016\u0000\n\n\u0001\u009f\t\n\u000f\u0000\u0001\u00a0\u000e\u0000\u000b\n\u0001\u00a1\u0001\u00a2\u0007\n\u0010\u0000\u0001\u00a3\u0001\u00a4\f\u0000\t\n\u0001\u00a5\n\n\u0005\u0000\u0006\n\u0001\u00a5\r\n\u000e\u0000\u0001\u00a6\u0015\u0000\u0001\u00a6\u0012\u0000\u0002\n\u0001(\u0011\n\u0007\u0000\u0001\u000e\u0016\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = CHTBLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\t\u0000\u0002\u0001\u0001\t\u0001\u0001\u0001\t\u0003\u0001\u0001\t\f\u0001\t\u0000\u0007\u0001\t\u0000\u0005\u0001\t\u0000\u0007\u0001\b\u0000\u0007\u0001\u0005\u0000\u0001\t\u0004\u0000\u0006\u0001\u0002\u0000\u0001\t\u0004\u0000\u0001\t\u0002\u0000\u0003\u0001\u0001\u0000\u0002\u0001\u0001\t\u0002\u0000\u0001\t\u0004\u0000\u0002\u0001\u0001\u0000\u0002\u0001\u0003\u0000\u0001\t\u0002\u0000\u0002\u0001\u0001\u0000\u0001\u0001\u0001\t\u0004\u0000\u0001\u0001\u0003\u0000\u0001\t\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0002\u0001\u0002\u0000\u0001\u0001\u0001\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    public static final int IGNORE = 0;
    public static final int ACCEPT = 1;

    private static int[] zzUnpackAction() {
        int[] result = new int[166];
        int offset = 0;
        offset = CHTBLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[166];
        int offset = 0;
        offset = CHTBLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[3750];
        int offset = 0;
        offset = CHTBLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[166];
        int offset = 0;
        offset = CHTBLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public void pushback(int n) {
        this.yypushback(n);
    }

    public String match() {
        return this.yytext();
    }

    private static void reportError(String yytext) {
        try {
            PrintWriter p = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, "GB18030"), true);
            p.println("chtbl.flex tokenization error: \"" + yytext + "\"");
            if (yytext.length() >= 1) {
                p.println("First character is: " + yytext.charAt(0));
                if (yytext.length() >= 2) {
                    p.println("Second character is: " + yytext.charAt(1));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("chtbl.flex tokenization and encoding present error");
        }
    }

    CHTBLexer(Reader in) {
        this.zzReader = in;
    }

    CHTBLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 88) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public int yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block38: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 4: {
                    System.out.print(this.yytext());
                }
                case 19: {
                    continue block38;
                }
                case 8: {
                    this.yybegin(10);
                    return 0;
                }
                case 20: {
                    continue block38;
                }
                case 10: {
                    this.yybegin(12);
                    return 0;
                }
                case 21: {
                    continue block38;
                }
                case 14: {
                    this.yybegin(6);
                    return 0;
                }
                case 22: {
                    continue block38;
                }
                case 9: {
                    this.yybegin(0);
                    return 0;
                }
                case 23: {
                    continue block38;
                }
                case 17: {
                    this.yybegin(0);
                    return 0;
                }
                case 24: {
                    continue block38;
                }
                case 5: {
                    this.yybegin(8);
                    return 0;
                }
                case 25: {
                    continue block38;
                }
                case 6: {
                    this.yybegin(14);
                    return 0;
                }
                case 26: {
                    continue block38;
                }
                case 12: {
                    this.yybegin(0);
                    return 0;
                }
                case 27: {
                    continue block38;
                }
                case 18: {
                    this.yybegin(0);
                    return 0;
                }
                case 28: {
                    continue block38;
                }
                case 7: {
                    this.yybegin(2);
                    return 0;
                }
                case 29: {
                    continue block38;
                }
                case 2: {
                    return 0;
                }
                case 30: {
                    continue block38;
                }
                case 13: {
                    this.yybegin(0);
                    return 0;
                }
                case 31: {
                    continue block38;
                }
                case 15: {
                    this.yybegin(0);
                    return 0;
                }
                case 32: {
                    continue block38;
                }
                case 16: {
                    this.yybegin(16);
                    return 0;
                }
                case 33: {
                    continue block38;
                }
                case 1: {
                    return 1;
                }
                case 34: {
                    continue block38;
                }
                case 3: {
                    CHTBLexer.reportError(this.yytext());
                }
                case 35: {
                    continue block38;
                }
                case 11: {
                    this.yybegin(12);
                    return 0;
                }
                case 36: {
                    continue block38;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return -1;
            }
            this.zzScanError(1);
        }
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.out.println("Usage : java CHTBLexer <inputfile>");
        } else {
            for (int i = 0; i < argv.length; ++i) {
                CHTBLexer scanner = null;
                try {
                    scanner = new CHTBLexer(new FileReader(argv[i]));
                    while (!scanner.zzAtEOF) {
                        scanner.yylex();
                    }
                    continue;
                }
                catch (FileNotFoundException e) {
                    System.out.println("File not found : \"" + argv[i] + "\"");
                    continue;
                }
                catch (IOException e) {
                    System.out.println("IO error scanning file \"" + argv[i] + "\"");
                    System.out.println(e);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Unexpected exception:");
                    e.printStackTrace();
                }
            }
        }
    }
}

