/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.vault.model.ScheduleSecretVersionDeletionDetails;
import java.util.Objects;

public class ScheduleSecretVersionDeletionRequest
extends BmcRequest<ScheduleSecretVersionDeletionDetails> {
    private String secretId;
    private Long secretVersionNumber;
    private ScheduleSecretVersionDeletionDetails scheduleSecretVersionDeletionDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getSecretId() {
        return this.secretId;
    }

    public Long getSecretVersionNumber() {
        return this.secretVersionNumber;
    }

    public ScheduleSecretVersionDeletionDetails getScheduleSecretVersionDeletionDetails() {
        return this.scheduleSecretVersionDeletionDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ScheduleSecretVersionDeletionDetails getBody$() {
        return this.scheduleSecretVersionDeletionDetails;
    }

    public Builder toBuilder() {
        return new Builder().secretId(this.secretId).secretVersionNumber(this.secretVersionNumber).scheduleSecretVersionDeletionDetails(this.scheduleSecretVersionDeletionDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",secretId=").append(String.valueOf(this.secretId));
        sb.append(",secretVersionNumber=").append(String.valueOf(this.secretVersionNumber));
        sb.append(",scheduleSecretVersionDeletionDetails=").append(String.valueOf((Object)this.scheduleSecretVersionDeletionDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduleSecretVersionDeletionRequest)) {
            return false;
        }
        ScheduleSecretVersionDeletionRequest other = (ScheduleSecretVersionDeletionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.secretId, other.secretId) && Objects.equals(this.secretVersionNumber, other.secretVersionNumber) && Objects.equals((Object)this.scheduleSecretVersionDeletionDetails, (Object)other.scheduleSecretVersionDeletionDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.secretId == null ? 43 : this.secretId.hashCode());
        result = result * 59 + (this.secretVersionNumber == null ? 43 : this.secretVersionNumber.hashCode());
        result = result * 59 + (this.scheduleSecretVersionDeletionDetails == null ? 43 : this.scheduleSecretVersionDeletionDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ScheduleSecretVersionDeletionRequest, ScheduleSecretVersionDeletionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String secretId = null;
        private Long secretVersionNumber = null;
        private ScheduleSecretVersionDeletionDetails scheduleSecretVersionDeletionDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public Builder secretVersionNumber(Long secretVersionNumber) {
            this.secretVersionNumber = secretVersionNumber;
            return this;
        }

        public Builder scheduleSecretVersionDeletionDetails(ScheduleSecretVersionDeletionDetails scheduleSecretVersionDeletionDetails) {
            this.scheduleSecretVersionDeletionDetails = scheduleSecretVersionDeletionDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ScheduleSecretVersionDeletionRequest o) {
            this.secretId(o.getSecretId());
            this.secretVersionNumber(o.getSecretVersionNumber());
            this.scheduleSecretVersionDeletionDetails(o.getScheduleSecretVersionDeletionDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ScheduleSecretVersionDeletionRequest build() {
            ScheduleSecretVersionDeletionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ScheduleSecretVersionDeletionDetails body) {
            this.scheduleSecretVersionDeletionDetails(body);
            return this;
        }

        public ScheduleSecretVersionDeletionRequest buildWithoutInvocationCallback() {
            ScheduleSecretVersionDeletionRequest request = new ScheduleSecretVersionDeletionRequest();
            request.secretId = this.secretId;
            request.secretVersionNumber = this.secretVersionNumber;
            request.scheduleSecretVersionDeletionDetails = this.scheduleSecretVersionDeletionDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

