/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.vars;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.netbeans.lib.chrome_devtools_protocol.debugger.EvaluateOnCallFrameRequest;
import org.netbeans.lib.chrome_devtools_protocol.runtime.RemoteObject;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.vars.EvaluationError;

public class CDTEvaluator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteObject evaluate(CDTDebugger debugger, String expression) throws EvaluationError {
        RemoteObject[] valueRef = new RemoteObject[]{null};
        String[] errRef = new String[]{null};
        EvaluateOnCallFrameRequest eocfr = new EvaluateOnCallFrameRequest();
        eocfr.setCallFrameId(debugger.getCurrentFrame().getCallFrameId());
        eocfr.setExpression(expression);
        debugger.getConnection().getDebugger().evaluateOnCallFrame(eocfr).handle((res, thr) -> {
            RemoteObject[] remoteObjectArray = valueRef;
            synchronized (valueRef) {
                if (res != null) {
                    if (res.getResult() != null) {
                        valueRef[0] = res.getResult();
                    } else {
                        errRef[0] = res.getExceptionDetails() != null ? res.getExceptionDetails().getText() : ">Evaluation failed<";
                    }
                } else {
                    errRef[0] = thr.getMessage();
                }
                valueRef.notifyAll();
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return null;
            }
        });
        RemoteObject[] remoteObjectArray = valueRef;
        synchronized (valueRef) {
            if (valueRef[0] == null && errRef[0] == null) {
                try {
                    valueRef.wait();
                }
                catch (InterruptedException ex) {
                    throw new EvaluationError(ex.getLocalizedMessage());
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (errRef[0] != null) {
                throw new EvaluationError(errRef[0]);
            }
            return valueRef[0];
        }
    }

    public static String getStringValue(RemoteObject value) {
        if (value == null) {
            return ">NULL<";
        }
        switch (CDTEvaluator.nvl(value.getType(), "")) {
            case "string": {
                return "\"" + String.valueOf(value.getValue()) + "\"";
            }
            case "number": 
            case "boolean": 
            case "object": {
                switch (CDTEvaluator.nvl(value.getSubtype(), "")) {
                    case "null": {
                        return "null";
                    }
                    case "": 
                    case "array": {
                        return value.getDescription() != null ? value.getDescription() : String.valueOf(value.getValue());
                    }
                }
            }
        }
        return value.getDescription() != null ? value.getDescription() : String.valueOf(value.getValue());
    }

    public static String getStringType(RemoteObject value) {
        if (value == null) {
            return ">NULL<";
        }
        ArrayList<String> elements = new ArrayList<String>(3);
        if (value.getType() != null && !value.getType().isBlank()) {
            elements.add(value.getType());
        }
        if (value.getSubtype() != null && !value.getSubtype().isBlank()) {
            elements.add(value.getSubtype());
        }
        if (value.getClassName() != null && !value.getClassName().isBlank()) {
            elements.add(value.getClassName());
        }
        return elements.stream().collect(Collectors.joining("/"));
    }

    private static String nvl(String input, String nullValue) {
        if (input == null) {
            return nullValue;
        }
        return input;
    }
}

