/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.devops;

import com.oracle.bmc.devops.DevopsClient;
import com.oracle.bmc.devops.model.BuildRun;
import com.oracle.bmc.devops.model.CreateBuildRunDetails;
import com.oracle.bmc.devops.requests.CreateBuildRunRequest;
import com.oracle.bmc.devops.responses.CreateBuildRunResponse;
import com.oracle.bmc.model.BmcException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCISessionInitiator;
import org.netbeans.modules.cloud.oracle.devops.BuildPipelineItem;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class CreateBuildRunAction
extends AbstractAction
implements ContextAwareAction {
    private final BuildPipelineItem pipeline;
    private final OCISessionInitiator session;

    public CreateBuildRunAction(BuildPipelineItem pipeline) {
        this.pipeline = pipeline;
        this.session = OCIManager.getDefault().getActiveSession();
    }

    CreateBuildRunAction(OCISessionInitiator session, BuildPipelineItem pipeline) {
        this.session = session;
        this.pipeline = pipeline;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        OCISessionInitiator session = (OCISessionInitiator)actionContext.lookup(OCISessionInitiator.class);
        return new CreateBuildRunAction(session, this.pipeline);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try (DevopsClient client = this.session.newClient(DevopsClient.class);){
            CreateBuildRunDetails createBuildRunDetails = CreateBuildRunDetails.builder().buildPipelineId(this.pipeline.getKey().getValue()).build();
            CreateBuildRunRequest request = CreateBuildRunRequest.builder().createBuildRunDetails(createBuildRunDetails).build();
            CreateBuildRunResponse response = client.createBuildRun(request);
            BuildRun buildRun = response.getBuildRun();
        }
        catch (BmcException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

