/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.util.concurrent.CompletableFuture;
import org.netbeans.api.project.Project;
import org.openide.util.Lookup;

public abstract class OpenProjectsFinder {
    private static OpenProjectsFinder finder;

    public abstract CompletableFuture<Project[]> findOpenProjects();

    public abstract CompletableFuture<Project[]> findTopLevelProjects();

    public static OpenProjectsFinder getDefault() {
        if (finder == null) {
            finder = (OpenProjectsFinder)Lookup.getDefault().lookup(OpenProjectsFinder.class);
        }
        if (finder == null) {
            finder = new DefaultOpenProjectsFinder();
        }
        return finder;
    }

    static class DefaultOpenProjectsFinder
    extends OpenProjectsFinder {
        DefaultOpenProjectsFinder() {
        }

        @Override
        public CompletableFuture<Project[]> findOpenProjects() {
            return CompletableFuture.completedFuture(new Project[0]);
        }

        @Override
        public CompletableFuture<Project[]> findTopLevelProjects() {
            return CompletableFuture.completedFuture(new Project[0]);
        }
    }
}

