/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer.internal;

import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.transfer.UploadConfiguration;
import com.oracle.bmc.util.VisibleForTesting;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultipartUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartUtils.class);
    @VisibleForTesting
    public static final long MiB = 0x100000L;
    static final long MAX_SUPPORTED_CONTENT_LENGTH = 0xA0000000000L;

    public static boolean shouldUseMultipart(@Nonnull UploadConfiguration config, long contentLength) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        return config.isAllowMultipartUploads() && MultipartUtils.meetsMinimumSize(config, contentLength);
    }

    public static long calculatePartSize(@Nonnull UploadConfiguration config, long contentLength) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        Validate.isTrue((contentLength <= 0xA0000000000L ? 1 : 0) != 0, (String)String.format("Content length [%s] exceeds max supported by ObjectStorage [%s]", contentLength, 0xA0000000000L), (Object[])new Object[0]);
        long configuredSizePerPart = config.getMinimumLengthPerUploadPart() * 0x100000L;
        return MultipartUtils.isCalculatedPartsLessThanOrEqualToMaxParts(configuredSizePerPart, contentLength) ? configuredSizePerPart : MultipartUtils.fetchSizePerPartBasedOnMaxAllowed(contentLength, configuredSizePerPart);
    }

    public static boolean shouldCalculateMd5(@Nonnull UploadConfiguration config, @Nonnull PutObjectRequest request) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return config.isEnforceMd5BeforeUpload() && request.getContentMD5() == null;
    }

    private static boolean meetsMinimumSize(UploadConfiguration config, long contentLength) {
        long min = config.getMinimumLengthForMultipartUpload() * 0x100000L;
        return contentLength >= min;
    }

    private static boolean isCalculatedPartsLessThanOrEqualToMaxParts(long configuredLengthPerPart, long contentLength) {
        long calculatedNumParts = (long)Math.ceil((double)contentLength / (double)configuredLengthPerPart);
        if (calculatedNumParts <= 10000L) {
            return true;
        }
        LOG.warn("Number of parts to upload [%s] is greater than the maximum number of parts allowed [%s] for given content length [%s]. Consider increasing the MinimumLengthPerUploadPart configuration option", (Object)calculatedNumParts, (Object)contentLength);
        return false;
    }

    private static long fetchSizePerPartBasedOnMaxAllowed(long contentLength, long configuredSizePerPart) {
        double calculatedSizePerPart = (double)contentLength / 10000.0;
        long sizePerPart = (long)Math.ceil(calculatedSizePerPart);
        assert (sizePerPart <= 0xC80000000L);
        LOG.info("Ignoring MinimumLengthPerUploadPart [{} bytes] and using {} bytes per part for upload", (Object)configuredSizePerPart, (Object)sizePerPart);
        return sizePerPart;
    }

    private MultipartUtils() {
    }
}

