/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseManagementConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="databaseManagementStatus")
    private final DatabaseManagementStatus databaseManagementStatus;
    @JsonProperty(value="databaseManagementConnectionId")
    private final String databaseManagementConnectionId;
    @JsonProperty(value="licenseModel")
    private final LicenseModel licenseModel;

    @Deprecated
    @ConstructorProperties(value={"databaseManagementStatus", "databaseManagementConnectionId", "licenseModel"})
    public DatabaseManagementConfig(DatabaseManagementStatus databaseManagementStatus, String databaseManagementConnectionId, LicenseModel licenseModel) {
        this.databaseManagementStatus = databaseManagementStatus;
        this.databaseManagementConnectionId = databaseManagementConnectionId;
        this.licenseModel = licenseModel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public DatabaseManagementStatus getDatabaseManagementStatus() {
        return this.databaseManagementStatus;
    }

    public String getDatabaseManagementConnectionId() {
        return this.databaseManagementConnectionId;
    }

    public LicenseModel getLicenseModel() {
        return this.licenseModel;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseManagementConfig(");
        sb.append("super=").append(super.toString());
        sb.append("databaseManagementStatus=").append(String.valueOf((Object)this.databaseManagementStatus));
        sb.append(", databaseManagementConnectionId=").append(String.valueOf(this.databaseManagementConnectionId));
        sb.append(", licenseModel=").append(String.valueOf((Object)this.licenseModel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseManagementConfig)) {
            return false;
        }
        DatabaseManagementConfig other = (DatabaseManagementConfig)((Object)o);
        return Objects.equals((Object)this.databaseManagementStatus, (Object)other.databaseManagementStatus) && Objects.equals(this.databaseManagementConnectionId, other.databaseManagementConnectionId) && Objects.equals((Object)this.licenseModel, (Object)other.licenseModel) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.databaseManagementStatus == null ? 43 : this.databaseManagementStatus.hashCode());
        result = result * 59 + (this.databaseManagementConnectionId == null ? 43 : this.databaseManagementConnectionId.hashCode());
        result = result * 59 + (this.licenseModel == null ? 43 : this.licenseModel.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LicenseModel implements BmcEnum
    {
        LicenseIncluded("LICENSE_INCLUDED"),
        BringYourOwnLicense("BRING_YOUR_OWN_LICENSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LicenseModel> map;

        private LicenseModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LicenseModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LicenseModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LicenseModel.class);
            map = new HashMap<String, LicenseModel>();
            for (LicenseModel v : LicenseModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseManagementStatus implements BmcEnum
    {
        Enabling("ENABLING"),
        Enabled("ENABLED"),
        Disabling("DISABLING"),
        NotEnabled("NOT_ENABLED"),
        FailedEnabling("FAILED_ENABLING"),
        FailedDisabling("FAILED_DISABLING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DatabaseManagementStatus> map;

        private DatabaseManagementStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseManagementStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DatabaseManagementStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DatabaseManagementStatus.class);
            map = new HashMap<String, DatabaseManagementStatus>();
            for (DatabaseManagementStatus v : DatabaseManagementStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="databaseManagementStatus")
        private DatabaseManagementStatus databaseManagementStatus;
        @JsonProperty(value="databaseManagementConnectionId")
        private String databaseManagementConnectionId;
        @JsonProperty(value="licenseModel")
        private LicenseModel licenseModel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder databaseManagementStatus(DatabaseManagementStatus databaseManagementStatus) {
            this.databaseManagementStatus = databaseManagementStatus;
            this.__explicitlySet__.add("databaseManagementStatus");
            return this;
        }

        public Builder databaseManagementConnectionId(String databaseManagementConnectionId) {
            this.databaseManagementConnectionId = databaseManagementConnectionId;
            this.__explicitlySet__.add("databaseManagementConnectionId");
            return this;
        }

        public Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel = licenseModel;
            this.__explicitlySet__.add("licenseModel");
            return this;
        }

        public DatabaseManagementConfig build() {
            DatabaseManagementConfig model = new DatabaseManagementConfig(this.databaseManagementStatus, this.databaseManagementConnectionId, this.licenseModel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseManagementConfig model) {
            if (model.wasPropertyExplicitlySet("databaseManagementStatus")) {
                this.databaseManagementStatus(model.getDatabaseManagementStatus());
            }
            if (model.wasPropertyExplicitlySet("databaseManagementConnectionId")) {
                this.databaseManagementConnectionId(model.getDatabaseManagementConnectionId());
            }
            if (model.wasPropertyExplicitlySet("licenseModel")) {
                this.licenseModel(model.getLicenseModel());
            }
            return this;
        }
    }
}

