/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.AppVersionSummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousContainerDatabaseVersionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="details")
    private final String details;
    @JsonProperty(value="supportedApps")
    private final List<AppVersionSummary> supportedApps;

    @Deprecated
    @ConstructorProperties(value={"version", "details", "supportedApps"})
    public AutonomousContainerDatabaseVersionSummary(String version, String details, List<AppVersionSummary> supportedApps) {
        this.version = version;
        this.details = details;
        this.supportedApps = supportedApps;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVersion() {
        return this.version;
    }

    public String getDetails() {
        return this.details;
    }

    public List<AppVersionSummary> getSupportedApps() {
        return this.supportedApps;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutonomousContainerDatabaseVersionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("version=").append(String.valueOf(this.version));
        sb.append(", details=").append(String.valueOf(this.details));
        sb.append(", supportedApps=").append(String.valueOf(this.supportedApps));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutonomousContainerDatabaseVersionSummary)) {
            return false;
        }
        AutonomousContainerDatabaseVersionSummary other = (AutonomousContainerDatabaseVersionSummary)((Object)o);
        return Objects.equals(this.version, other.version) && Objects.equals(this.details, other.details) && Objects.equals(this.supportedApps, other.supportedApps) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.details == null ? 43 : this.details.hashCode());
        result = result * 59 + (this.supportedApps == null ? 43 : this.supportedApps.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="details")
        private String details;
        @JsonProperty(value="supportedApps")
        private List<AppVersionSummary> supportedApps;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder details(String details) {
            this.details = details;
            this.__explicitlySet__.add("details");
            return this;
        }

        public Builder supportedApps(List<AppVersionSummary> supportedApps) {
            this.supportedApps = supportedApps;
            this.__explicitlySet__.add("supportedApps");
            return this;
        }

        public AutonomousContainerDatabaseVersionSummary build() {
            AutonomousContainerDatabaseVersionSummary model = new AutonomousContainerDatabaseVersionSummary(this.version, this.details, this.supportedApps);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutonomousContainerDatabaseVersionSummary model) {
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("details")) {
                this.details(model.getDetails());
            }
            if (model.wasPropertyExplicitlySet("supportedApps")) {
                this.supportedApps(model.getSupportedApps());
            }
            return this;
        }
    }
}

