/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.nodes.actions;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javaee.wildfly.ide.WildflyKiller;
import org.netbeans.modules.javaee.wildfly.ide.WildflyOutputSupport;
import org.netbeans.modules.javaee.wildfly.nodes.WildflyManagerNode;
import org.netbeans.modules.javaee.wildfly.nodes.actions.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;

public class KillServerAction
extends CookieAction {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("JBoss kill UI", 1);
    private static final Logger LOGGER = Logger.getLogger(KillServerAction.class.getName());
    private final WildflyKiller killer = new WildflyKiller();

    protected int mode() {
        return 8;
    }

    protected void performAction(Node[] nodes) {
        if (nodes == null || nodes.length != 1) {
            return;
        }
        final WildflyManagerNode managerNode = (WildflyManagerNode)nodes[0].getCookie(WildflyManagerNode.class);
        if (managerNode == null) {
            return;
        }
        final Future killed = RequestProcessor.getDefault().submit((Callable)new Callable<Boolean>(){
            final /* synthetic */ KillServerAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Boolean call() {
                Process p;
                WildflyOutputSupport output = WildflyOutputSupport.getInstance(managerNode.getDeploymentManager().getInstanceProperties(), false);
                if (output != null && (p = output.getProcess()) != null) {
                    p.destroy();
                    try {
                        boolean ok = p.waitFor(5L, TimeUnit.SECONDS);
                        if (!ok) {
                            ok = p.destroyForcibly().waitFor(5L, TimeUnit.SECONDS);
                        }
                        if (ok) {
                            LOGGER.log(Level.INFO, "Succesfully killed WildFly");
                            return true;
                        }
                    }
                    catch (InterruptedException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                        Thread.currentThread().interrupt();
                        return false;
                    }
                }
                return this.this$0.killer.killServers();
            }
        });
        PROCESSOR.post(new Runnable(){
            final /* synthetic */ KillServerAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    if (((Boolean)killed.get(15L, TimeUnit.SECONDS)).booleanValue()) {
                        managerNode.getDeploymentManager().getInstanceProperties().refreshServerInstance();
                    }
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    LOGGER.log(Level.INFO, "Kill action failed", ex);
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)Bundle.MSG_KillFailed(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                }
            }
        });
    }

    public String getName() {
        return NbBundle.getMessage(KillServerAction.class, (String)"LBL_KillServerGUIAction");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean enable(Node[] nodes) {
        return true;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected Class<?>[] cookieClasses() {
        return new Class[0];
    }
}

