/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OauthMetadata
extends ExplicitlySetBmcModel {
    @JsonProperty(value="idcsAccountNameUrl")
    private final String idcsAccountNameUrl;
    @JsonProperty(value="clientAppId")
    private final String clientAppId;
    @JsonProperty(value="clientAppSecret")
    private final String clientAppSecret;

    @Deprecated
    @ConstructorProperties(value={"idcsAccountNameUrl", "clientAppId", "clientAppSecret"})
    public OauthMetadata(String idcsAccountNameUrl, String clientAppId, String clientAppSecret) {
        this.idcsAccountNameUrl = idcsAccountNameUrl;
        this.clientAppId = clientAppId;
        this.clientAppSecret = clientAppSecret;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getIdcsAccountNameUrl() {
        return this.idcsAccountNameUrl;
    }

    public String getClientAppId() {
        return this.clientAppId;
    }

    public String getClientAppSecret() {
        return this.clientAppSecret;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OauthMetadata(");
        sb.append("super=").append(super.toString());
        sb.append("idcsAccountNameUrl=").append(String.valueOf(this.idcsAccountNameUrl));
        sb.append(", clientAppId=").append(String.valueOf(this.clientAppId));
        sb.append(", clientAppSecret=").append("<redacted>");
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OauthMetadata)) {
            return false;
        }
        OauthMetadata other = (OauthMetadata)((Object)o);
        return Objects.equals(this.idcsAccountNameUrl, other.idcsAccountNameUrl) && Objects.equals(this.clientAppId, other.clientAppId) && Objects.equals(this.clientAppSecret, other.clientAppSecret) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.idcsAccountNameUrl == null ? 43 : this.idcsAccountNameUrl.hashCode());
        result = result * 59 + (this.clientAppId == null ? 43 : this.clientAppId.hashCode());
        result = result * 59 + (this.clientAppSecret == null ? 43 : this.clientAppSecret.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="idcsAccountNameUrl")
        private String idcsAccountNameUrl;
        @JsonProperty(value="clientAppId")
        private String clientAppId;
        @JsonProperty(value="clientAppSecret")
        private String clientAppSecret;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder idcsAccountNameUrl(String idcsAccountNameUrl) {
            this.idcsAccountNameUrl = idcsAccountNameUrl;
            this.__explicitlySet__.add("idcsAccountNameUrl");
            return this;
        }

        public Builder clientAppId(String clientAppId) {
            this.clientAppId = clientAppId;
            this.__explicitlySet__.add("clientAppId");
            return this;
        }

        public Builder clientAppSecret(String clientAppSecret) {
            this.clientAppSecret = clientAppSecret;
            this.__explicitlySet__.add("clientAppSecret");
            return this;
        }

        public OauthMetadata build() {
            OauthMetadata model = new OauthMetadata(this.idcsAccountNameUrl, this.clientAppId, this.clientAppSecret);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OauthMetadata model) {
            if (model.wasPropertyExplicitlySet("idcsAccountNameUrl")) {
                this.idcsAccountNameUrl(model.getIdcsAccountNameUrl());
            }
            if (model.wasPropertyExplicitlySet("clientAppId")) {
                this.clientAppId(model.getClientAppId());
            }
            if (model.wasPropertyExplicitlySet("clientAppSecret")) {
                this.clientAppSecret(model.getClientAppSecret());
            }
            return this;
        }
    }
}

