/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring.rename;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.web.refactoring.RefactoringUtil;
import org.netbeans.modules.web.refactoring.rename.BaseWebXmlRename;
import org.netbeans.modules.web.refactoring.rename.RenameItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class WebXmlFolderMove
extends BaseWebXmlRename {
    private final MoveRefactoring move;
    private final FileObject folder;

    public WebXmlFolderMove(FileObject webDD, FileObject folder, MoveRefactoring move) {
        super(webDD);
        this.folder = folder;
        this.move = move;
    }

    @Override
    protected List<RenameItem> getRenameItems() {
        ArrayList<RenameItem> result = new ArrayList<RenameItem>();
        ArrayList<FileObject> fos = new ArrayList<FileObject>();
        RefactoringUtil.collectChildren(this.folder, fos);
        for (FileObject each : fos) {
            if (RefactoringUtil.isPackageInfo(each)) continue;
            String oldFqn = JavaIdentifiers.getQualifiedName((FileObject)each);
            String targetPackageName = this.getTargetPackageName(each.getParent());
            String oldUnqualifiedName = JavaIdentifiers.unqualify((String)oldFqn);
            String newFqn = targetPackageName.length() == 0 ? oldUnqualifiedName : targetPackageName + "." + oldUnqualifiedName;
            result.add(new RenameItem(newFqn, oldFqn));
        }
        return result;
    }

    private String getTargetPackageName(FileObject fo) {
        String newPackageName = RefactoringUtil.getPackageName((URL)this.move.getTarget().lookup(URL.class));
        String postfix = FileUtil.getRelativePath((FileObject)this.folder.getParent(), (FileObject)fo).replace('/', '.');
        if (newPackageName.length() == 0) {
            return postfix;
        }
        if (postfix.length() == 0) {
            return newPackageName;
        }
        return newPackageName + "." + postfix;
    }

    @Override
    protected AbstractRefactoring getRefactoring() {
        return this.move;
    }
}

