/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.openide.util.NbBundle;

public class MapFormat
extends Format {
    private static final int BUFSIZE = 255;
    static final long serialVersionUID = -7695811542873819435L;
    private Locale locale = Locale.getDefault();
    private String ldel = "{";
    private String rdel = "}";
    private Map<String, ?> argmap;
    private int[] offsets;
    private String[] arguments;
    private int maxOffset;
    private boolean throwex = false;
    private boolean exactmatch = true;

    public MapFormat(Map<String, ?> arguments) {
        this.setMap(arguments);
    }

    public static String format(String pattern, Map arguments) {
        MapFormat temp = new MapFormat(arguments);
        return temp.format(pattern);
    }

    protected Object processKey(String key) {
        return this.argmap.get(key);
    }

    public String processPattern(String newPattern) throws IllegalArgumentException {
        int idx = 0;
        int offnum = -1;
        StringBuffer outpat = new StringBuffer();
        this.offsets = new int[255];
        this.arguments = new String[255];
        this.maxOffset = -1;
        while (true) {
            int ridx = -1;
            int lidx = newPattern.indexOf(this.ldel, idx);
            if (lidx < 0) break;
            ridx = newPattern.indexOf(this.rdel, lidx + this.ldel.length());
            if (++offnum >= 255) {
                throw new IllegalArgumentException(NbBundle.getBundle(MapFormat.class).getString("MSG_TooManyArguments"));
            }
            if (ridx < 0) {
                if (!this.exactmatch) break;
                throw new IllegalArgumentException(NbBundle.getBundle(MapFormat.class).getString("MSG_UnmatchedBraces") + " " + lidx);
            }
            outpat.append(newPattern.substring(idx, lidx));
            this.offsets[offnum] = outpat.length();
            this.arguments[offnum] = newPattern.substring(lidx + this.ldel.length(), ridx);
            idx = ridx + this.rdel.length();
            ++this.maxOffset;
        }
        outpat.append(newPattern.substring(idx));
        return outpat.toString();
    }

    private String formatObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return NumberFormat.getInstance(this.locale).format(obj);
        }
        if (obj instanceof Date) {
            return DateFormat.getDateTimeInstance(3, 3, this.locale).format(obj);
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    @Override
    public StringBuffer format(Object pat, StringBuffer result, FieldPosition fpos) {
        String pattern = this.processPattern((String)pat);
        int lastOffset = 0;
        for (int i = 0; i <= this.maxOffset; ++i) {
            String newkey;
            String newsubst;
            String lessgreedy;
            int fromright;
            int offidx = this.offsets[i];
            result.append(pattern.substring(lastOffset, this.offsets[i]));
            lastOffset = offidx;
            String key = this.arguments[i];
            if (key.length() <= 0) {
                result.append(this.ldel);
                result.append(this.rdel);
                continue;
            }
            String obj = this.formatObject(this.processKey(key));
            if (obj == null && (fromright = (lessgreedy = this.ldel + key).lastIndexOf(this.ldel)) > 0 && (newsubst = this.formatObject(this.processKey(newkey = lessgreedy.substring(fromright + this.ldel.length())))) != null) {
                obj = lessgreedy.substring(0, fromright) + newsubst;
            }
            if (obj == null) {
                if (this.throwex) {
                    throw new IllegalArgumentException(MessageFormat.format(NbBundle.getBundle(MapFormat.class).getString("MSG_FMT_ObjectForKey"), Integer.valueOf(key)));
                }
                obj = this.ldel + key + this.rdel;
            }
            result.append(obj);
        }
        result.append(pattern.substring(lastOffset));
        return result;
    }

    @Override
    public Object parseObject(String text, ParsePosition status) {
        return this.parse(text);
    }

    public String parse(String source) {
        StringBuffer sbuf = new StringBuffer(source);
        for (String it_key : this.argmap.keySet()) {
            String it_obj = this.formatObject(this.argmap.get(it_key));
            int it_idx = -1;
            do {
                ++it_idx;
                it_idx = sbuf.toString().indexOf(it_obj, it_idx);
                if (it_idx < 0) continue;
                sbuf.replace(it_idx, it_idx + it_obj.length(), this.ldel + it_key + this.rdel);
            } while (it_idx != -1);
        }
        return sbuf.toString();
    }

    public boolean willThrowExceptionIfKeyWasNotFound() {
        return this.throwex;
    }

    public void setThrowExceptionIfKeyWasNotFound(boolean flag) {
        this.throwex = flag;
    }

    public boolean isExactMatch() {
        return this.exactmatch;
    }

    public void setExactMatch(boolean flag) {
        this.exactmatch = flag;
    }

    public String getLeftBrace() {
        return this.ldel;
    }

    public void setLeftBrace(String delimiter) {
        this.ldel = delimiter;
    }

    public String getRightBrace() {
        return this.rdel;
    }

    public void setRightBrace(String delimiter) {
        this.rdel = delimiter;
    }

    public Map getMap() {
        return this.argmap;
    }

    public void setMap(Map<String, ?> map) {
        this.argmap = map;
    }
}

