/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.wizards;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMQName;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginExecution;
import org.netbeans.modules.xml.jaxb.spi.SchemaCompiler;
import org.netbeans.modules.xml.retriever.Retriever;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class MavenSchemaCompiler
implements SchemaCompiler {
    private static final String JAXB_PLUGIN_GROUP_ID = "org.jvnet.jaxb";
    private static final String JAXB_PLUGIN_ARTIFACT_ID = "jaxb-maven-plugin";
    private static final String JAXB_PLUGIN_VERSION_JAVAX = "2.0.9";
    private static final String JAXB_PLUGIN_VERSION_JAKARTA = "4.0.0";
    private static final String JAXB_GENERATE_PREFIX = "jaxb-generate-";
    private final Project project;

    MavenSchemaCompiler(Project project) {
        this.project = project;
    }

    public void compileSchema(final WizardDescriptor wiz) {
        final String schemaName = (String)wiz.getProperty("schema.name");
        String catalogFilePrep = (String)wiz.getProperty("jaxb.catalog.file");
        if (catalogFilePrep != null && catalogFilePrep.trim().isEmpty()) {
            catalogFilePrep = null;
        }
        final String catalogFile = catalogFilePrep;
        final List bindingFileList = (List)wiz.getProperty("jaxb.binding.files");
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){
            final /* synthetic */ MavenSchemaCompiler this$0;
            {
                this.this$0 = this$0;
            }

            public void performOperation(POMModel model) {
                Plugin plugin = this.this$0.addJaxb2Plugin(model);
                String packageName = (String)wiz.getProperty("xsd.package.name");
                if (packageName != null && packageName.trim().length() == 0) {
                    packageName = null;
                }
                MavenSchemaCompiler.addJaxb2Execution(plugin, schemaName, packageName, catalogFile, bindingFileList);
            }
        };
        Utilities.performPOMModelOperations((FileObject)this.project.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(operation));
    }

    public void importResources(WizardDescriptor wiz) throws IOException {
        block6: {
            List xsdFileList = (List)wiz.getProperty("xsd.file.list");
            if (xsdFileList == null) break block6;
            String schemaName = (String)wiz.getProperty("schema.name");
            boolean srcLocTypeUrl = "url".equals((String)wiz.getProperty("xsd.locatiom.type"));
            if (srcLocTypeUrl) {
                for (int i = 0; i < xsdFileList.size(); ++i) {
                    String url = (String)xsdFileList.get(i);
                    URL schemaURL = new URL(url);
                    try {
                        MavenSchemaCompiler.retrieveResource(this.getSchemaFolder(schemaName), schemaURL.toURI());
                        continue;
                    }
                    catch (URISyntaxException ex) {
                        throw new IOException(ex.getMessage());
                    }
                }
            } else {
                FileObject projFO = this.project.getProjectDirectory();
                File projDir = FileUtil.toFile((FileObject)projFO);
                for (int i = 0; i < xsdFileList.size(); ++i) {
                    File srcFile = MavenSchemaCompiler.Relative2AbsolutePath(projDir, (String)xsdFileList.get(i));
                    MavenSchemaCompiler.retrieveResource(this.getSchemaFolder(schemaName), srcFile.toURI());
                }
            }
        }
    }

    private static FileObject retrieveResource(FileObject targetFolder, URI source) {
        Retriever retriever = Retriever.getDefault();
        FileObject result = null;
        try {
            result = retriever.retrieveResource(targetFolder, source);
        }
        catch (UnknownHostException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (result == null) {
            // empty if block
        }
        return result;
    }

    public FileObject getSchemaFolder(String schemaName) throws IOException {
        FileObject mainFolder = this.project.getProjectDirectory().getFileObject("src/main");
        if (mainFolder != null) {
            FileObject resourcesFolder = mainFolder.getFileObject("resources");
            if (resourcesFolder == null) {
                resourcesFolder = mainFolder.createFolder("resources");
            }
            if (resourcesFolder != null) {
                FileObject jaxbFolder = resourcesFolder.getFileObject("jaxb");
                if (jaxbFolder == null) {
                    jaxbFolder = resourcesFolder.createFolder("jaxb");
                }
                if (jaxbFolder != null) {
                    FileObject schemaFolder = jaxbFolder.getFileObject(schemaName);
                    if (schemaFolder == null) {
                        schemaFolder = jaxbFolder.createFolder(schemaName);
                    }
                    return schemaFolder;
                }
            }
        }
        return null;
    }

    private static File Relative2AbsolutePath(File base, String relPath) {
        File relPathFile = new File(relPath);
        File absPath = null;
        absPath = !relPathFile.isAbsolute() ? new File(base, relPath) : relPathFile;
        return absPath;
    }

    private Plugin addJaxb2Plugin(POMModel model) {
        Plugin plugin;
        assert (model.isIntransaction()) : "need to call model modifications under transaction.";
        Build bld = model.getProject().getBuild();
        if (bld == null) {
            bld = model.getFactory().createBuild();
            model.getProject().setBuild(bld);
        }
        if ((plugin = bld.findPluginById(JAXB_PLUGIN_GROUP_ID, JAXB_PLUGIN_ARTIFACT_ID)) != null) {
            return plugin;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)this.project.getProjectDirectory().getFileObject("src/main/java"), (String)"classpath/compile");
        boolean javaxXmlBindingPresent = cp.findResource("javax/xml/bind/JAXBContext.class") != null;
        boolean jakartaXmlBindingPresent = cp.findResource("jakarta/xml/bind/JAXBContext.class") != null;
        boolean jakartaNamespace = jakartaXmlBindingPresent || !javaxXmlBindingPresent;
        plugin = model.getFactory().createPlugin();
        plugin.setGroupId(JAXB_PLUGIN_GROUP_ID);
        plugin.setArtifactId(JAXB_PLUGIN_ARTIFACT_ID);
        if (jakartaNamespace) {
            plugin.setVersion(JAXB_PLUGIN_VERSION_JAKARTA);
        } else {
            plugin.setVersion(JAXB_PLUGIN_VERSION_JAVAX);
        }
        bld.addPlugin(plugin);
        Configuration config = plugin.getConfiguration();
        if (config == null) {
            config = model.getFactory().createConfiguration();
            config.setSimpleParameter("verbose", "true");
            plugin.setConfiguration(config);
        }
        return plugin;
    }

    public static void addJaxb2Execution(Plugin plugin, String id, String packageName, String catalogFile, List<String> bindingFiles) {
        POMModel model = plugin.getModel();
        assert (model.isIntransaction());
        PluginExecution exec = model.getFactory().createExecution();
        String uniqueId = MavenSchemaCompiler.getUniqueId(plugin, id);
        exec.setId(JAXB_GENERATE_PREFIX + uniqueId);
        exec.addGoal("generate");
        plugin.addExecution(exec);
        Configuration config = model.getFactory().createConfiguration();
        exec.setConfiguration(config);
        POMExtensibilityElement schemaIncludes = MavenSchemaCompiler.createPOMExtensibilityElement("schemaIncludes", model);
        config.addExtensibilityElement(schemaIncludes);
        POMExtensibilityElement include = MavenSchemaCompiler.createPOMExtensibilityElement("include", model);
        include.setElementText("jaxb/" + id + "/*.xsd");
        schemaIncludes.addExtensibilityElement(include);
        POMExtensibilityElement episodeFile = MavenSchemaCompiler.createPOMExtensibilityElement("episodeFile", model);
        episodeFile.setElementText("${project.build.directory}/generated-sources/xjc-" + id + "/META-INF/jaxb-" + id + ".episode");
        config.addExtensibilityElement(episodeFile);
        if (catalogFile != null) {
            POMExtensibilityElement catalog = MavenSchemaCompiler.createPOMExtensibilityElement("catalog", model);
            catalog.setElementText(catalogFile);
            config.addExtensibilityElement(catalog);
        }
        if (bindingFiles != null && !bindingFiles.isEmpty()) {
            POMExtensibilityElement bindings = MavenSchemaCompiler.createPOMExtensibilityElement("bindings", model);
            config.addExtensibilityElement(bindings);
            for (String bindingFile : bindingFiles) {
                File bindingFileObject = new File(bindingFile);
                POMExtensibilityElement binding = MavenSchemaCompiler.createPOMExtensibilityElement("binding", model);
                bindings.addExtensibilityElement(binding);
                POMExtensibilityElement fileset = MavenSchemaCompiler.createPOMExtensibilityElement("fileset", model);
                binding.addExtensibilityElement(fileset);
                POMExtensibilityElement directory = MavenSchemaCompiler.createPOMExtensibilityElement("directory", model);
                fileset.addExtensibilityElement(directory);
                directory.setElementText(bindingFileObject.getParent());
                POMExtensibilityElement includes = MavenSchemaCompiler.createPOMExtensibilityElement("includes", model);
                fileset.addExtensibilityElement(includes);
                POMExtensibilityElement include2 = MavenSchemaCompiler.createPOMExtensibilityElement("include", model);
                includes.addExtensibilityElement(include2);
                include2.setElementText(bindingFileObject.getName());
            }
        }
        POMExtensibilityElement outputDirectory = MavenSchemaCompiler.createPOMExtensibilityElement("generateDirectory", model);
        outputDirectory.setElementText("${project.build.directory}/generated-sources/xjc-" + id);
        config.addExtensibilityElement(outputDirectory);
        if (packageName != null) {
            POMExtensibilityElement generatePackage = MavenSchemaCompiler.createPOMExtensibilityElement("generatePackage", model);
            generatePackage.setElementText(packageName);
            config.addExtensibilityElement(generatePackage);
        }
    }

    private static POMExtensibilityElement createPOMExtensibilityElement(String name, POMModel model) {
        QName qname = POMQName.createQName((String)name, (boolean)model.getPOMQNames().isNSAware());
        return model.getFactory().createPOMExtensibilityElement(qname);
    }

    private static String getUniqueId(Plugin plugin, String id) {
        String result = id;
        List executions = plugin.getExecutions();
        if (executions != null) {
            HashSet<String> execIdSet = new HashSet<String>();
            for (PluginExecution ex : executions) {
                String execId = ex.getId();
                if (execId == null) continue;
                if (execId.startsWith(JAXB_GENERATE_PREFIX)) {
                    execIdSet.add(execId.substring(JAXB_GENERATE_PREFIX.length()));
                    continue;
                }
                execIdSet.add(execId);
            }
            int i = 1;
            while (execIdSet.contains(result)) {
                result = id + "_" + String.valueOf(i++);
            }
        }
        return result;
    }
}

