/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.repository.RemoteRepository;
import org.netbeans.modules.apisupport.project.api.EditableManifest;
import org.netbeans.modules.maven.api.archetype.ProjectInfo;
import org.netbeans.modules.maven.apisupport.MavenNbModuleImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMQName;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.modules.maven.model.pom.Repository;
import org.netbeans.modules.maven.model.pom.RepositoryPolicy;
import org.netbeans.modules.maven.options.MavenVersionSettings;
import org.netbeans.modules.maven.spi.newproject.CreateProjectBuilder;
import org.openide.util.Exceptions;

final class NBMNativeMWI {
    NBMNativeMWI() {
    }

    static void instantiate(ProjectInfo vi, File projFile, String nbVersion, boolean useOsgi, MavenProject mp) {
        CreateProjectBuilder builder = new CreateProjectBuilder(projFile, vi.groupId, vi.artifactId, vi.version).setPackageName(vi.packageName).setPackaging("nbm").setAdditionalNonPomWork((CreateProjectBuilder.AdditionalChangeHandle)new AdditionalFiles()).setAdditionalOperations((CreateProjectBuilder.PomOperationsHandle)new AdditionalOperations(nbVersion, useOsgi));
        if (mp != null) {
            builder = builder.setParentProject(mp);
        }
        builder.create();
    }

    private static class AdditionalFiles
    implements CreateProjectBuilder.AdditionalChangeHandle,
    Runnable {
        private CreateProjectBuilder.Context context;
        private final String EMPTY_BUNDLE_FILE = "Localized module labels. Defaults taken from POM (<name>, <description>, <groupId>) if unset.\n#OpenIDE-Module-Name=\n#OpenIDE-Module-Short-Description=\n#OpenIDE-Module-Long-Description=\n#OpenIDE-Module-Display-Category=";

        public Runnable createAdditionalChange(CreateProjectBuilder.Context context) {
            this.context = context;
            return this;
        }

        @Override
        public void run() {
            String path;
            File main = new File(this.context.getProjectDirectory(), "src" + File.separator + "main");
            File src = new File(main, "java");
            src.mkdirs();
            String packageName = this.context.getPackageName();
            if (packageName != null) {
                String path2 = packageName.replace(".", File.separator);
                new File(src, path2).mkdirs();
            }
            src = new File(main, "nbm");
            src.mkdirs();
            EditableManifest mf = new EditableManifest();
            mf.setAttribute("Manifest-Version", "1.0", null);
            if (packageName != null) {
                path = packageName.replace(".", "/") + "/Bundle.properties";
                mf.setAttribute("OpenIDE-Module-Localizing-Bundle", path, null);
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(src, "manifest.mf")));){
                    mf.write((OutputStream)os);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            src = new File(main, "resources");
            src.mkdirs();
            if (packageName != null) {
                path = packageName.replace(".", File.separator);
                File res = new File(src, path);
                res.mkdirs();
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(res, "Bundle.properties")));){
                    Properties p = new Properties();
                    p.store(os, "Localized module labels. Defaults taken from POM (<name>, <description>, <groupId>) if unset.\n#OpenIDE-Module-Name=\n#OpenIDE-Module-Short-Description=\n#OpenIDE-Module-Long-Description=\n#OpenIDE-Module-Display-Category=");
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static class AdditionalOperations
    implements CreateProjectBuilder.PomOperationsHandle,
    ModelOperation<POMModel> {
        private CreateProjectBuilder.Context context;
        private final String netbeansDependencyVersion;
        private final boolean useOsgi;
        private static final String JAR_PLUGIN_VERSION_MANIFEST_CONFIG_CHANGE = "3.0.0";

        private AdditionalOperations(String netbeansDependencyVersion, boolean useOsgi) {
            this.netbeansDependencyVersion = netbeansDependencyVersion;
            this.useOsgi = useOsgi;
        }

        public List<ModelOperation<POMModel>> createPomOperations(CreateProjectBuilder.Context context) {
            this.context = context;
            return Collections.singletonList(this);
        }

        public void performOperation(POMModel model) {
            Project root = model.getProject();
            if (root != null) {
                PluginManagement pm;
                PluginManagement pm2;
                org.netbeans.modules.maven.model.pom.Plugin p;
                PluginManagement pm3;
                List repos;
                MavenProject parent = this.context.getParent();
                boolean addRepository = true;
                boolean isSnapshot = "dev-SNAPSHOT".equals(this.netbeansDependencyVersion);
                String snapshotRepoUrl = "https://repository.apache.org/content/repositories/snapshots/";
                if (parent != null && (repos = parent.getRemoteProjectRepositories()) != null) {
                    block0: for (RemoteRepository repo : repos) {
                        if (snapshotRepoUrl.equals(repo.getUrl()) || (snapshotRepoUrl + "/").equals(repo.getUrl())) {
                            addRepository = false;
                            break;
                        }
                        if (repo.getMirroredRepositories() == null) continue;
                        for (RemoteRepository mirr : repo.getMirroredRepositories()) {
                            if (!snapshotRepoUrl.equals(mirr.getUrl()) && !(snapshotRepoUrl + "/").equals(mirr.getUrl())) continue;
                            addRepository = false;
                            break block0;
                        }
                    }
                }
                if (addRepository && isSnapshot) {
                    Repository repo = model.getFactory().createRepository();
                    repo.setId("apache.snapshots");
                    repo.setName("Repository hosting NetBeans modules");
                    repo.setUrl(snapshotRepoUrl);
                    RepositoryPolicy policy = model.getFactory().createReleaseRepositoryPolicy();
                    policy.setEnabled(Boolean.valueOf(false));
                    repo.setReleases(policy);
                    root.addRepository(repo);
                }
                boolean addDependency = true;
                String existingVersion = null;
                String managedVersion = null;
                String netbeansVersioProperty = null;
                if (parent != null) {
                    if (parent.getDependencies() != null) {
                        for (Dependency dep : parent.getDependencies()) {
                            if (!"org.netbeans.api".equals(dep.getGroupId()) || !"org-netbeans-api-annotations-common".equals(dep.getArtifactId())) continue;
                            addDependency = false;
                            if (dep.getVersion() == null) break;
                            existingVersion = dep.getVersion();
                            break;
                        }
                    }
                    if (parent.getDependencyManagement() != null && parent.getDependencyManagement().getDependencies() != null) {
                        for (Dependency dep : parent.getDependencyManagement().getDependencies()) {
                            if (!"org.netbeans.api".equals(dep.getGroupId()) || !"org-netbeans-api-annotations-common".equals(dep.getArtifactId()) || dep.getVersion() == null) continue;
                            managedVersion = dep.getVersion();
                            break;
                        }
                    }
                    netbeansVersioProperty = parent.getProperties().getProperty("netbeans.version");
                }
                if (!addDependency && !this.netbeansDependencyVersion.equals(existingVersion)) {
                    addDependency = true;
                }
                if (addDependency) {
                    org.netbeans.modules.maven.model.pom.Dependency d = model.getFactory().createDependency();
                    d.setGroupId("org.netbeans.api");
                    d.setArtifactId("org-netbeans-api-annotations-common");
                    String version = this.netbeansDependencyVersion;
                    if (!version.equals(managedVersion)) {
                        if (version.equals(netbeansVersioProperty)) {
                            version = "${netbeans.version}";
                        }
                        d.setVersion(version);
                    }
                    root.addDependency(d);
                }
                boolean addPlugin = true;
                String managedPVersion = null;
                if (parent != null && (pm3 = parent.getPluginManagement()) != null) {
                    for (Plugin p2 : pm3.getPlugins()) {
                        if (!"org.codehaus.mojo".equals(p2.getGroupId()) && !"org.apache.netbeans.utilities".equals(p2.getGroupId()) || !"nbm-maven-plugin".equals(p2.getArtifactId())) continue;
                        managedPVersion = p2.getVersion();
                        break;
                    }
                }
                MavenVersionSettings settings = MavenVersionSettings.getDefault();
                if (addPlugin) {
                    p = model.getFactory().createPlugin();
                    p.setGroupId("org.apache.netbeans.utilities");
                    p.setArtifactId("nbm-maven-plugin");
                    if (managedPVersion == null) {
                        p.setVersion(MavenNbModuleImpl.getLatestNbmPluginVersion());
                    }
                    p.setExtensions(Boolean.valueOf(true));
                    if (this.useOsgi) {
                        Configuration c = model.getFactory().createConfiguration();
                        c.setSimpleParameter("useOSGiDependencies", "true");
                        p.setConfiguration(c);
                    }
                    this.getOrCreateBuild(model).addPlugin(p);
                }
                addPlugin = true;
                managedPVersion = null;
                if (parent != null && (pm2 = parent.getPluginManagement()) != null) {
                    if (parent.getProperties().getProperty("maven.compiler.release") != null) {
                        addPlugin = false;
                    } else {
                        for (Plugin p3 : pm2.getPlugins()) {
                            if (!"org.apache.maven.plugins".equals(p3.getGroupId()) || !"maven-compiler-plugin".equals(p3.getArtifactId())) continue;
                            managedPVersion = p3.getVersion();
                            Xpp3Dom conf = (Xpp3Dom)p3.getConfiguration();
                            if (conf == null || conf.getChild("release") == null && conf.getChild("source") == null && conf.getChild("target") == null) break;
                            addPlugin = false;
                            break;
                        }
                    }
                }
                if (addPlugin) {
                    p = model.getFactory().createPlugin();
                    p.setGroupId("org.apache.maven.plugins");
                    p.setArtifactId("maven-compiler-plugin");
                    if (managedPVersion == null) {
                        p.setVersion(settings.getVersion("org.apache.maven.plugins", "maven-compiler-plugin"));
                    }
                    this.getOrCreateBuild(model).addPlugin(p);
                    model.getProject().getProperties().setProperty("maven.compiler.release", "17");
                }
                managedPVersion = null;
                String useManifest = null;
                if (parent != null && (pm = parent.getPluginManagement()) != null) {
                    for (Plugin p4 : pm.getPlugins()) {
                        if (!"org.apache.maven.plugins".equals(p4.getGroupId()) || !"maven-jar-plugin".equals(p4.getArtifactId())) continue;
                        managedPVersion = p4.getVersion();
                        Xpp3Dom conf = (Xpp3Dom)p4.getConfiguration();
                        if (conf == null) break;
                        if (new ComparableVersion(managedPVersion).compareTo(new ComparableVersion(JAR_PLUGIN_VERSION_MANIFEST_CONFIG_CHANGE)) >= 0) {
                            Xpp3Dom manifestFile;
                            Xpp3Dom archive = conf.getChild("archive");
                            if (archive == null || (manifestFile = archive.getChild("manifestFile")) == null) break;
                            useManifest = manifestFile.getValue();
                            break;
                        }
                        Xpp3Dom useEl = conf.getChild("useDefaultManifestFile");
                        if (useEl == null) break;
                        useManifest = useEl.getValue();
                        break;
                    }
                }
                boolean bl = addPlugin = useManifest == null;
                if (addPlugin) {
                    Plugin p2;
                    p2 = model.getFactory().createPlugin();
                    p2.setGroupId("org.apache.maven.plugins");
                    p2.setArtifactId("maven-jar-plugin");
                    if (managedPVersion == null) {
                        String pVersion = settings.getVersion("org.apache.maven.plugins", "maven-jar-plugin");
                        p2.setVersion(pVersion);
                        managedPVersion = pVersion;
                    }
                    Configuration c = model.getFactory().createConfiguration();
                    if (new ComparableVersion(managedPVersion).compareTo(new ComparableVersion(JAR_PLUGIN_VERSION_MANIFEST_CONFIG_CHANGE)) >= 0) {
                        QName archiveqname = POMQName.createQName((String)"archive", (boolean)model.getPOMQNames().isNSAware());
                        POMExtensibilityElement archiveelement = model.getFactory().createPOMExtensibilityElement(archiveqname);
                        QName manifestqname = POMQName.createQName((String)"manifestFile", (boolean)model.getPOMQNames().isNSAware());
                        POMExtensibilityElement manifestelement = model.getFactory().createPOMExtensibilityElement(manifestqname);
                        manifestelement.setElementText("${project.build.outputDirectory}/META-INF/MANIFEST.MF");
                        archiveelement.addAnyElement(manifestelement, 0);
                        c.addExtensibilityElement(archiveelement);
                    } else {
                        c.setSimpleParameter("useDefaultManifestFile", "true");
                    }
                    p2.setConfiguration(c);
                    this.getOrCreateBuild(model).addPlugin((org.netbeans.modules.maven.model.pom.Plugin)p2);
                }
            }
        }

        private Build getOrCreateBuild(POMModel model) {
            Build bld = model.getProject().getBuild();
            if (bld == null) {
                bld = model.getFactory().createBuild();
                model.getProject().setBuild(bld);
            }
            return bld;
        }
    }
}

