/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.heapwalk.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.modules.debugger.jpda.heapwalk.HeapImpl;
import org.netbeans.modules.debugger.jpda.heapwalk.views.DebuggerHeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.ClassesController;
import org.netbeans.modules.profiler.heapwalk.ClassesListController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class ClassesCountsView
extends TopComponent
implements HelpCtx.Provider {
    private transient EngineListener listener;
    private transient JPanel content;
    private transient HeapFragmentWalker hfw;
    private transient ClassesListController clc;
    private transient RequestProcessor defaultRP = new RequestProcessor(ClassesCountsView.class.getName());

    public ClassesCountsView() {
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/debugger/resources/classesView/Classes.png"));
        this.setLayout(new BorderLayout());
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
    }

    protected String preferredID() {
        return "org.netbeans.modules.debugger.jpda.ui.views.ClassesView";
    }

    private void setUp() {
        if (this.listener == null) {
            this.listener = new EngineListener();
            this.listener.start();
        }
        if (this.content == null) {
            this.listener.getRefreshContentTask().schedule(10);
        }
    }

    private synchronized void tearDown() {
        if (this.content != null) {
            final JPanel tempContent = this.content;
            this.content = null;
            this.hfw = null;
            this.clc = null;
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ ClassesCountsView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.remove(tempContent);
                }
            });
        }
    }

    private void setContent() {
        assert (SwingUtilities.isEventDispatchThread());
        JPDADebugger debugger = null;
        DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (engine != null) {
            debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        }
        if (this.content != null) {
            this.remove(this.content);
            this.content = null;
        }
        if (debugger != null && debugger.canGetInstanceInfo()) {
            final JPDADebugger fDebugger = debugger;
            RequestProcessor rp = (RequestProcessor)engine.lookupFirst(null, RequestProcessor.class);
            if (rp == null) {
                rp = this.defaultRP;
            }
            rp.post(new Runnable(){
                final /* synthetic */ ClassesCountsView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    HeapImpl heap = new HeapImpl(fDebugger);
                    final DebuggerHeapFragmentWalker hfw = new DebuggerHeapFragmentWalker(heap);
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ClassesCountsView classesCountsView = this.this$1.this$0;
                            synchronized (classesCountsView) {
                                this.this$1.this$0.hfw = hfw;
                                ClassesController cc = hfw.getClassesController();
                                if (this.this$1.this$0.content != null) {
                                    this.this$1.this$0.remove(this.this$1.this$0.content);
                                }
                                this.this$1.this$0.content = cc.getPanel();
                                this.this$1.this$0.clc = cc.getClassesListController();
                                Component header = cc.getClassesListController().getPanel().getComponent(0);
                                header.setVisible(false);
                                cc.getClassesListController().setColumnVisibility(3, false);
                                this.this$1.this$0.add(this.this$1.this$0.content, "Center");
                            }
                            this.this$1.this$0.repaint();
                            this.this$1.this$0.revalidate();
                        }
                    });
                }
            });
        }
    }

    private void refreshContent() {
        if (this.clc != null) {
            this.clc.updateData();
        } else {
            this.setContent();
        }
    }

    HeapFragmentWalker getCurrentFragmentWalker() {
        return this.hfw;
    }

    protected void componentShowing() {
        super.componentShowing();
        this.setUp();
    }

    protected void componentHidden() {
        super.componentHidden();
    }

    protected void componentClosed() {
        super.componentClosed();
        this.tearDown();
        if (this.listener != null) {
            this.listener.stop();
            this.listener = null;
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerInstancesNode");
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.content == null) {
            return false;
        }
        return this.content.requestFocusInWindow();
    }

    public String getName() {
        return NbBundle.getMessage(ClassesCountsView.class, (String)"CTL_Classes_view");
    }

    public String getToolTipText() {
        return NbBundle.getMessage(ClassesCountsView.class, (String)"CTL_Classes_tooltip");
    }

    private final class EngineListener
    extends DebuggerManagerAdapter {
        private WeakReference<JPDADebugger> lastDebugger = new WeakReference<Object>(null);
        private RequestProcessor.Task refreshTask;

        private EngineListener() {
        }

        void start() {
            DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            DebuggerEngine engine = DebuggerManager.getDebuggerManager().getCurrentEngine();
            this.attachToStateChange(engine);
        }

        void stop() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
            this.detachFromStateChange();
        }

        private synchronized void attachToStateChange(DebuggerEngine engine) {
            this.detachFromStateChange();
            if (engine == null) {
                return;
            }
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.addPropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            this.lastDebugger = new WeakReference<JPDADebugger>(debugger);
        }

        private synchronized void detachFromStateChange() {
            JPDADebugger debugger = (JPDADebugger)this.lastDebugger.get();
            if (debugger != null) {
                debugger.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            }
            if (this.refreshTask != null) {
                this.refreshTask.cancel();
                this.refreshTask = null;
            }
            ClassesCountsView.this.tearDown();
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() instanceof JPDADebugger) {
                int state = ((JPDADebugger)e.getSource()).getState();
                if (state == 4) {
                    this.detachFromStateChange();
                } else if (state != 1) {
                    this.getRefreshContentTask().schedule(10);
                }
                return;
            }
            DebuggerEngine engine = (DebuggerEngine)e.getNewValue();
            this.attachToStateChange(engine);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClassesCountsView.this.setContent();
                    EngineListener.this.getRefreshContentTask().schedule(10);
                }
            });
        }

        private synchronized RequestProcessor.Task getRefreshContentTask() {
            if (this.refreshTask == null) {
                this.refreshTask = ClassesCountsView.this.defaultRP.create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        JPDADebugger debugger;
                        try {
                            HeapFragmentWalker fragmentWalker = ClassesCountsView.this.hfw;
                            if (fragmentWalker != null) {
                                Heap heap = fragmentWalker.getHeapFragment();
                                ((HeapImpl)heap).computeClasses();
                            }
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ClassesCountsView.this.refreshContent();
                                }
                            });
                        }
                        catch (InterruptedException iex) {
                            return;
                        }
                        catch (InvocationTargetException itex) {
                            ErrorManager.getDefault().notify((Throwable)itex);
                        }
                        Object object = EngineListener.this;
                        synchronized (object) {
                            debugger = (JPDADebugger)EngineListener.this.lastDebugger.get();
                        }
                        if (debugger != null && debugger.getState() == 2) {
                            object = ClassesCountsView.this;
                            synchronized (object) {
                                if (EngineListener.this.refreshTask != null) {
                                    EngineListener.this.refreshTask.schedule(2000);
                                }
                            }
                        }
                    }
                });
            }
            return this.refreshTask;
        }
    }
}

