/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.InstancePoolInstance;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AttachInstancePoolInstanceResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private String opcWorkRequestId;
    private String location;
    private InstancePoolInstance instancePoolInstance;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getLocation() {
        return this.location;
    }

    public InstancePoolInstance getInstancePoolInstance() {
        return this.instancePoolInstance;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "opcWorkRequestId", "location", "instancePoolInstance"})
    private AttachInstancePoolInstanceResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, String opcWorkRequestId, String location, InstancePoolInstance instancePoolInstance) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.opcWorkRequestId = opcWorkRequestId;
        this.location = location;
        this.instancePoolInstance = instancePoolInstance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",instancePoolInstance=").append(String.valueOf((Object)this.instancePoolInstance));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttachInstancePoolInstanceResponse)) {
            return false;
        }
        AttachInstancePoolInstanceResponse other = (AttachInstancePoolInstanceResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.location, other.location) && Objects.equals((Object)this.instancePoolInstance, (Object)other.instancePoolInstance);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.instancePoolInstance == null ? 43 : this.instancePoolInstance.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<AttachInstancePoolInstanceResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private String opcWorkRequestId;
        private String location;
        private InstancePoolInstance instancePoolInstance;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder instancePoolInstance(InstancePoolInstance instancePoolInstance) {
            this.instancePoolInstance = instancePoolInstance;
            return this;
        }

        public Builder copy(AttachInstancePoolInstanceResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.location(o.getLocation());
            this.instancePoolInstance(o.getInstancePoolInstance());
            return this;
        }

        public AttachInstancePoolInstanceResponse build() {
            return new AttachInstancePoolInstanceResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.opcWorkRequestId, this.location, this.instancePoolInstance);
        }
    }
}

